/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.naming;

import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.modeshape.common.SystemFailureException;
import org.modeshape.common.naming.MockInitialContextFactory;

public class MockInitialContext
implements Context {
    private final Map<String, Object> environment = new ConcurrentHashMap<String, Object>();
    private final ConcurrentHashMap<String, Object> registry = new ConcurrentHashMap();

    public static void setup() {
        System.setProperty("java.naming.factory.initial", MockInitialContextFactory.class.getName());
    }

    public static void register(String name, Object obj) {
        MockInitialContext.register(name, obj, null, null, null, null);
    }

    public static void register(String name1, Object obj1, String name2, Object obj2) {
        MockInitialContext.register(name1, obj1, name2, obj2, null, null);
    }

    public static void register(String name1, Object obj1, String name2, Object obj2, String name3, Object obj3) {
        MockInitialContext.setup();
        try {
            InitialContext context = new InitialContext();
            if (name1 != null) {
                context.rebind(name1, obj1);
            }
            if (name2 != null) {
                context.rebind(name2, obj2);
            }
            if (name3 != null) {
                context.rebind(name3, obj3);
            }
        }
        catch (NamingException e) {
            throw new SystemFailureException("Unable to create the mock InitialContext", (Throwable)e);
        }
    }

    public static void tearDown() {
        MockInitialContextFactory.tearDown();
    }

    MockInitialContext(Hashtable<?, ?> environment) {
        for (Map.Entry<?, ?> entry : environment.entrySet()) {
            this.environment.put(entry.getKey().toString(), entry.getValue());
        }
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) {
        return this.environment.put(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) {
        return this.environment.remove(propName);
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        if (this.registry.putIfAbsent(name, obj) != null) {
            throw new NameAlreadyBoundException("The name \"" + name + "\" is already bound to an object");
        }
    }

    @Override
    public void rebind(Name name, Object obj) {
        this.rebind(name.toString(), obj);
    }

    @Override
    public void rebind(String name, Object obj) {
        this.registry.put(name, obj);
    }

    @Override
    public void unbind(String name) {
        this.registry.remove(name);
    }

    @Override
    public void unbind(Name name) {
        this.unbind(name.toString());
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    @Override
    public Object lookup(String name) throws NamingException {
        Object result = this.registry.get(name);
        if (result == null) {
            throw new NameNotFoundException("No object is registered at \"" + name + "\"");
        }
        return result;
    }

    @Override
    public Object lookupLink(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object lookupLink(Name name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rename(Name oldName, Name newName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rename(String oldName, String newName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
    }

    @Override
    public Name composeName(Name name, Name prefix) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String composeName(String name, String prefix) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Context createSubcontext(Name name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Context createSubcontext(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void destroySubcontext(Name name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void destroySubcontext(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Hashtable<?, ?> getEnvironment() {
        return (Hashtable)this.environment;
    }

    @Override
    public String getNameInNamespace() {
        throw new UnsupportedOperationException();
    }

    @Override
    public NameParser getNameParser(Name name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NameParser getNameParser(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) {
        throw new UnsupportedOperationException();
    }
}

