/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.collection;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.collection.AbstractMultimapTest;
import org.modeshape.common.collection.LinkedListMultimap;
import org.modeshape.common.collection.ListMultimap;

public class LinkedListMultimapTest
extends AbstractMultimapTest {
    protected ListMultimap<String, String> listMultimap;

    @Override
    @Before
    public void beforeEach() {
        super.beforeEach();
        this.listMultimap = (ListMultimap)this.multimap;
    }

    protected <K, V> LinkedListMultimap<K, V> createMultimap() {
        return LinkedListMultimap.create();
    }

    @Override
    protected boolean valuesAllowDuplicates() {
        return true;
    }

    @Test
    public void shouldAddEntryToEmtpyMap() {
        LinkedListMultimap listMap = this.createMultimap();
        Assert.assertThat((Object)listMap.size(), (Matcher)Is.is((Object)0));
        listMap.addEntryFor((Object)this.keys[0], (Object)this.values[0]);
        Assert.assertThat((Object)listMap.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldMaintainOrderOfInsertionInKeysAndValues() {
        this.multimap.put((Object)this.keys[0], (Object)this.values[0]);
        this.multimap.put((Object)this.keys[1], (Object)this.values[1]);
        this.multimap.put((Object)this.keys[0], (Object)this.values[0]);
        this.multimap.put((Object)this.keys[1], (Object)this.values[2]);
        this.multimap.put((Object)this.keys[0], (Object)this.values[0]);
        this.multimap.put((Object)this.keys[1], (Object)this.values[3]);
        Assert.assertThat((Object)this.multimap.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.multimap.size(), (Matcher)Is.is((Object)6));
        this.assertKeys(this.multimap, (K[])new String[]{this.keys[0], this.keys[1]});
        this.assertValues(this.multimap, this.keys[0], (V[])new String[]{this.values[0], this.values[0], this.values[0]});
        this.assertValues(this.multimap, this.keys[1], (V[])new String[]{this.values[1], this.values[2], this.values[3]});
        ArrayList entries = new ArrayList();
        entries.add(this.entry(this.keys[0], this.values[0]));
        entries.add(this.entry(this.keys[1], this.values[1]));
        entries.add(this.entry(this.keys[0], this.values[0]));
        entries.add(this.entry(this.keys[1], this.values[2]));
        entries.add(this.entry(this.keys[0], this.values[0]));
        entries.add(this.entry(this.keys[1], this.values[3]));
        this.assertEntries(this.multimap, entries);
    }

    @Test
    public void shouldMaintainOrderOfInsertionInKeysAndValuesAfterRemovalOfFirstKeyValuePair() {
        this.multimap.put((Object)this.keys[0], (Object)this.values[0]);
        this.multimap.put((Object)this.keys[1], (Object)this.values[0]);
        this.multimap.put((Object)this.keys[0], (Object)this.values[1]);
        this.multimap.put((Object)this.keys[1], (Object)this.values[1]);
        this.multimap.put((Object)this.keys[0], (Object)this.values[2]);
        this.multimap.put((Object)this.keys[1], (Object)this.values[2]);
        this.multimap.remove((Object)this.keys[0], (Object)this.values[0]);
        Assert.assertThat((Object)this.multimap.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.multimap.size(), (Matcher)Is.is((Object)5));
        this.assertKeys(this.multimap, (K[])new String[]{this.keys[0], this.keys[1]});
        this.assertValues(this.multimap, this.keys[0], (V[])new String[]{this.values[1], this.values[2]});
        this.assertValues(this.multimap, this.keys[1], (V[])new String[]{this.values[0], this.values[1], this.values[2]});
        ArrayList entries = new ArrayList();
        entries.add(this.entry(this.keys[1], this.values[0]));
        entries.add(this.entry(this.keys[0], this.values[1]));
        entries.add(this.entry(this.keys[1], this.values[1]));
        entries.add(this.entry(this.keys[0], this.values[2]));
        entries.add(this.entry(this.keys[1], this.values[2]));
        this.assertEntries(this.multimap, entries);
    }

    @Test
    public void shouldMaintainOrderOfInsertionInKeysAndValuesAfterRemovalOfMiddleKeyValuePair() {
        this.multimap.put((Object)this.keys[0], (Object)this.values[0]);
        this.multimap.put((Object)this.keys[1], (Object)this.values[1]);
        this.multimap.put((Object)this.keys[0], (Object)this.values[0]);
        this.multimap.put((Object)this.keys[1], (Object)this.values[2]);
        this.multimap.put((Object)this.keys[0], (Object)this.values[0]);
        this.multimap.put((Object)this.keys[1], (Object)this.values[3]);
        this.multimap.remove((Object)this.keys[1], (Object)this.values[2]);
        Assert.assertThat((Object)this.multimap.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.multimap.size(), (Matcher)Is.is((Object)5));
        this.assertKeys(this.multimap, (K[])new String[]{this.keys[0], this.keys[1]});
        this.assertValues(this.multimap, this.keys[0], (V[])new String[]{this.values[0], this.values[0], this.values[0]});
        this.assertValues(this.multimap, this.keys[1], (V[])new String[]{this.values[1], this.values[3]});
        ArrayList entries = new ArrayList();
        entries.add(this.entry(this.keys[0], this.values[0]));
        entries.add(this.entry(this.keys[1], this.values[1]));
        entries.add(this.entry(this.keys[0], this.values[0]));
        entries.add(this.entry(this.keys[0], this.values[0]));
        entries.add(this.entry(this.keys[1], this.values[3]));
        this.assertEntries(this.multimap, entries);
    }

    @Test
    public void shouldMaintainOrderOfInsertionInKeysAndValuesAfterRemovalOfLastKeyValuePair() {
        this.multimap.put((Object)this.keys[0], (Object)this.values[0]);
        this.multimap.put((Object)this.keys[1], (Object)this.values[0]);
        this.multimap.put((Object)this.keys[0], (Object)this.values[1]);
        this.multimap.put((Object)this.keys[1], (Object)this.values[1]);
        this.multimap.put((Object)this.keys[0], (Object)this.values[2]);
        this.multimap.put((Object)this.keys[1], (Object)this.values[2]);
        this.multimap.remove((Object)this.keys[1], (Object)this.values[2]);
        Assert.assertThat((Object)this.multimap.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.multimap.size(), (Matcher)Is.is((Object)5));
        this.assertKeys(this.multimap, (K[])new String[]{this.keys[0], this.keys[1]});
        this.assertValues(this.multimap, this.keys[0], (V[])new String[]{this.values[0], this.values[1], this.values[2]});
        this.assertValues(this.multimap, this.keys[1], (V[])new String[]{this.values[0], this.values[1]});
        ArrayList entries = new ArrayList();
        entries.add(this.entry(this.keys[0], this.values[0]));
        entries.add(this.entry(this.keys[1], this.values[0]));
        entries.add(this.entry(this.keys[0], this.values[1]));
        entries.add(this.entry(this.keys[1], this.values[1]));
        entries.add(this.entry(this.keys[0], this.values[2]));
        this.assertEntries(this.multimap, entries);
    }

    @Test
    public void shouldMaintainOrderOfInsertionInKeysAndValuesAfterRemovalOfFirstValueFromKeyCollection() {
        this.multimap.put((Object)this.keys[0], (Object)this.values[0]);
        this.multimap.put((Object)this.keys[1], (Object)this.values[0]);
        this.multimap.put((Object)this.keys[0], (Object)this.values[1]);
        this.multimap.put((Object)this.keys[1], (Object)this.values[1]);
        this.multimap.put((Object)this.keys[0], (Object)this.values[2]);
        this.multimap.put((Object)this.keys[1], (Object)this.values[2]);
        this.multimap.get((Object)this.keys[0]).remove(this.values[0]);
        Assert.assertThat((Object)this.multimap.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.multimap.size(), (Matcher)Is.is((Object)5));
        this.assertKeys(this.multimap, (K[])new String[]{this.keys[0], this.keys[1]});
        this.assertValues(this.multimap, this.keys[0], (V[])new String[]{this.values[1], this.values[2]});
        this.assertValues(this.multimap, this.keys[1], (V[])new String[]{this.values[0], this.values[1], this.values[2]});
        ArrayList entries = new ArrayList();
        entries.add(this.entry(this.keys[1], this.values[0]));
        entries.add(this.entry(this.keys[0], this.values[1]));
        entries.add(this.entry(this.keys[1], this.values[1]));
        entries.add(this.entry(this.keys[0], this.values[2]));
        entries.add(this.entry(this.keys[1], this.values[2]));
        this.assertEntries(this.multimap, entries);
    }

    @Test
    public void shouldMaintainOrderOfInsertionInKeysAndValuesAfterRemovalOfMiddleValueFromKeyCollection() {
        this.multimap.put((Object)this.keys[0], (Object)this.values[0]);
        this.multimap.put((Object)this.keys[1], (Object)this.values[0]);
        this.multimap.put((Object)this.keys[0], (Object)this.values[1]);
        this.multimap.put((Object)this.keys[1], (Object)this.values[1]);
        this.multimap.put((Object)this.keys[0], (Object)this.values[2]);
        this.multimap.put((Object)this.keys[1], (Object)this.values[2]);
        this.multimap.get((Object)this.keys[1]).remove(this.values[1]);
        Assert.assertThat((Object)this.multimap.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.multimap.size(), (Matcher)Is.is((Object)5));
        this.assertKeys(this.multimap, (K[])new String[]{this.keys[0], this.keys[1]});
        this.assertValues(this.multimap, this.keys[0], (V[])new String[]{this.values[0], this.values[1], this.values[2]});
        this.assertValues(this.multimap, this.keys[1], (V[])new String[]{this.values[0], this.values[2]});
        ArrayList entries = new ArrayList();
        entries.add(this.entry(this.keys[0], this.values[0]));
        entries.add(this.entry(this.keys[1], this.values[0]));
        entries.add(this.entry(this.keys[0], this.values[1]));
        entries.add(this.entry(this.keys[0], this.values[2]));
        entries.add(this.entry(this.keys[1], this.values[2]));
        this.assertEntries(this.multimap, entries);
    }

    @Test
    public void shouldMaintainOrderOfInsertionInKeysAndValuesAfterRemovalOfLastValueFromKeyCollection() {
        this.multimap.put((Object)this.keys[0], (Object)this.values[0]);
        this.multimap.put((Object)this.keys[1], (Object)this.values[0]);
        this.multimap.put((Object)this.keys[0], (Object)this.values[1]);
        this.multimap.put((Object)this.keys[1], (Object)this.values[1]);
        this.multimap.put((Object)this.keys[0], (Object)this.values[2]);
        this.multimap.put((Object)this.keys[1], (Object)this.values[2]);
        this.multimap.get((Object)this.keys[1]).remove(this.values[2]);
        Assert.assertThat((Object)this.multimap.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.multimap.size(), (Matcher)Is.is((Object)5));
        this.assertKeys(this.multimap, (K[])new String[]{this.keys[0], this.keys[1]});
        this.assertValues(this.multimap, this.keys[0], (V[])new String[]{this.values[0], this.values[1], this.values[2]});
        this.assertValues(this.multimap, this.keys[1], (V[])new String[]{this.values[0], this.values[1]});
        ArrayList entries = new ArrayList();
        entries.add(this.entry(this.keys[0], this.values[0]));
        entries.add(this.entry(this.keys[1], this.values[0]));
        entries.add(this.entry(this.keys[0], this.values[1]));
        entries.add(this.entry(this.keys[1], this.values[1]));
        entries.add(this.entry(this.keys[0], this.values[2]));
        this.assertEntries(this.multimap, entries);
    }

    @Test
    public void shouldMaintainOrderOfInsertionInKeysAndValuesAfterAddingValueAtBeginngingOfCollectionForKey() {
        this.multimap.put((Object)this.keys[0], (Object)this.values[0]);
        this.multimap.put((Object)this.keys[1], (Object)this.values[0]);
        this.multimap.put((Object)this.keys[0], (Object)this.values[1]);
        this.multimap.put((Object)this.keys[1], (Object)this.values[1]);
        this.multimap.put((Object)this.keys[0], (Object)this.values[2]);
        this.multimap.put((Object)this.keys[1], (Object)this.values[2]);
        this.addValueUsingCollection(this.listMultimap, this.keys[0], 0, this.values[3]);
        Assert.assertThat((Object)this.multimap.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.multimap.size(), (Matcher)Is.is((Object)7));
        this.assertKeys(this.multimap, (K[])new String[]{this.keys[0], this.keys[1]});
        this.assertValues(this.multimap, this.keys[0], (V[])new String[]{this.values[3], this.values[0], this.values[1], this.values[2]});
        this.assertValues(this.multimap, this.keys[1], (V[])new String[]{this.values[0], this.values[1], this.values[2]});
        ArrayList entries = new ArrayList();
        entries.add(this.entry(this.keys[0], this.values[3]));
        entries.add(this.entry(this.keys[0], this.values[0]));
        entries.add(this.entry(this.keys[1], this.values[0]));
        entries.add(this.entry(this.keys[0], this.values[1]));
        entries.add(this.entry(this.keys[1], this.values[1]));
        entries.add(this.entry(this.keys[0], this.values[2]));
        entries.add(this.entry(this.keys[1], this.values[2]));
        this.assertEntries(this.multimap, entries);
    }

    @Test
    public void shouldMaintainOrderOfInsertionInKeysAndValuesAfterAddingValueAtMiddleOfCollectionForKey() {
        this.multimap.put((Object)this.keys[0], (Object)this.values[0]);
        this.multimap.put((Object)this.keys[1], (Object)this.values[0]);
        this.multimap.put((Object)this.keys[0], (Object)this.values[1]);
        this.multimap.put((Object)this.keys[1], (Object)this.values[1]);
        this.multimap.put((Object)this.keys[0], (Object)this.values[2]);
        this.multimap.put((Object)this.keys[1], (Object)this.values[2]);
        this.addValueUsingCollection(this.listMultimap, this.keys[1], 1, this.values[3]);
        Assert.assertThat((Object)this.multimap.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.multimap.size(), (Matcher)Is.is((Object)7));
        this.assertKeys(this.multimap, (K[])new String[]{this.keys[0], this.keys[1]});
        this.assertValues(this.multimap, this.keys[0], (V[])new String[]{this.values[0], this.values[1], this.values[2]});
        this.assertValues(this.multimap, this.keys[1], (V[])new String[]{this.values[0], this.values[3], this.values[1], this.values[2]});
        ArrayList entries = new ArrayList();
        entries.add(this.entry(this.keys[0], this.values[0]));
        entries.add(this.entry(this.keys[1], this.values[0]));
        entries.add(this.entry(this.keys[0], this.values[1]));
        entries.add(this.entry(this.keys[1], this.values[3]));
        entries.add(this.entry(this.keys[1], this.values[1]));
        entries.add(this.entry(this.keys[0], this.values[2]));
        entries.add(this.entry(this.keys[1], this.values[2]));
        this.assertEntries(this.multimap, entries);
    }

    @Test
    public void shouldMaintainOrderOfInsertionInKeysAndValuesAfterAddingValueAtEndOfCollectionForKey() {
        this.multimap.put((Object)this.keys[0], (Object)this.values[0]);
        this.multimap.put((Object)this.keys[1], (Object)this.values[0]);
        this.multimap.put((Object)this.keys[0], (Object)this.values[1]);
        this.multimap.put((Object)this.keys[1], (Object)this.values[1]);
        this.multimap.put((Object)this.keys[0], (Object)this.values[2]);
        this.multimap.put((Object)this.keys[1], (Object)this.values[2]);
        this.addValueUsingCollection(this.listMultimap, this.keys[1], 3, this.values[3]);
        Assert.assertThat((Object)this.multimap.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.multimap.size(), (Matcher)Is.is((Object)7));
        this.assertKeys(this.multimap, (K[])new String[]{this.keys[0], this.keys[1]});
        this.assertValues(this.multimap, this.keys[0], (V[])new String[]{this.values[0], this.values[1], this.values[2]});
        this.assertValues(this.multimap, this.keys[1], (V[])new String[]{this.values[0], this.values[1], this.values[2], this.values[3]});
        ArrayList entries = new ArrayList();
        entries.add(this.entry(this.keys[0], this.values[0]));
        entries.add(this.entry(this.keys[1], this.values[0]));
        entries.add(this.entry(this.keys[0], this.values[1]));
        entries.add(this.entry(this.keys[1], this.values[1]));
        entries.add(this.entry(this.keys[0], this.values[2]));
        entries.add(this.entry(this.keys[1], this.values[2]));
        entries.add(this.entry(this.keys[1], this.values[3]));
        this.assertEntries(this.multimap, entries);
    }

    @Test
    public void shouldMaintainOrderOfInsertionInKeysAndValuesAfterAddingValueAtBeginngingOfCollectionForKeyUsingIterator() {
        this.multimap.put((Object)this.keys[0], (Object)this.values[0]);
        this.multimap.put((Object)this.keys[1], (Object)this.values[0]);
        this.multimap.put((Object)this.keys[0], (Object)this.values[1]);
        this.multimap.put((Object)this.keys[1], (Object)this.values[1]);
        this.multimap.put((Object)this.keys[0], (Object)this.values[2]);
        this.multimap.put((Object)this.keys[1], (Object)this.values[2]);
        this.addValueUsingIterator(this.listMultimap, this.keys[0], 0, this.values[3]);
        Assert.assertThat((Object)this.multimap.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.multimap.size(), (Matcher)Is.is((Object)7));
        this.assertKeys(this.multimap, (K[])new String[]{this.keys[0], this.keys[1]});
        this.assertValues(this.multimap, this.keys[0], (V[])new String[]{this.values[3], this.values[0], this.values[1], this.values[2]});
        this.assertValues(this.multimap, this.keys[1], (V[])new String[]{this.values[0], this.values[1], this.values[2]});
        ArrayList entries = new ArrayList();
        entries.add(this.entry(this.keys[0], this.values[3]));
        entries.add(this.entry(this.keys[0], this.values[0]));
        entries.add(this.entry(this.keys[1], this.values[0]));
        entries.add(this.entry(this.keys[0], this.values[1]));
        entries.add(this.entry(this.keys[1], this.values[1]));
        entries.add(this.entry(this.keys[0], this.values[2]));
        entries.add(this.entry(this.keys[1], this.values[2]));
        this.assertEntries(this.multimap, entries);
    }

    @Test
    public void shouldMaintainOrderOfInsertionInKeysAndValuesAfterAddingValueAtMiddleOfCollectionForKeyUsingIterator() {
        this.multimap.put((Object)this.keys[0], (Object)this.values[0]);
        this.multimap.put((Object)this.keys[1], (Object)this.values[0]);
        this.multimap.put((Object)this.keys[0], (Object)this.values[1]);
        this.multimap.put((Object)this.keys[1], (Object)this.values[1]);
        this.multimap.put((Object)this.keys[0], (Object)this.values[2]);
        this.multimap.put((Object)this.keys[1], (Object)this.values[2]);
        this.addValueUsingIterator(this.listMultimap, this.keys[1], 1, this.values[3]);
        Assert.assertThat((Object)this.multimap.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.multimap.size(), (Matcher)Is.is((Object)7));
        this.assertKeys(this.multimap, (K[])new String[]{this.keys[0], this.keys[1]});
        this.assertValues(this.multimap, this.keys[0], (V[])new String[]{this.values[0], this.values[1], this.values[2]});
        this.assertValues(this.multimap, this.keys[1], (V[])new String[]{this.values[0], this.values[3], this.values[1], this.values[2]});
        ArrayList entries = new ArrayList();
        entries.add(this.entry(this.keys[0], this.values[0]));
        entries.add(this.entry(this.keys[1], this.values[0]));
        entries.add(this.entry(this.keys[0], this.values[1]));
        entries.add(this.entry(this.keys[1], this.values[3]));
        entries.add(this.entry(this.keys[1], this.values[1]));
        entries.add(this.entry(this.keys[0], this.values[2]));
        entries.add(this.entry(this.keys[1], this.values[2]));
        this.assertEntries(this.multimap, entries);
    }

    @Test
    public void shouldMaintainOrderOfInsertionInKeysAndValuesAfterAddingValueAtEndOfCollectionForKeyUsingIterator() {
        this.multimap.put((Object)this.keys[0], (Object)this.values[0]);
        this.multimap.put((Object)this.keys[1], (Object)this.values[0]);
        this.multimap.put((Object)this.keys[0], (Object)this.values[1]);
        this.multimap.put((Object)this.keys[1], (Object)this.values[1]);
        this.multimap.put((Object)this.keys[0], (Object)this.values[2]);
        this.multimap.put((Object)this.keys[1], (Object)this.values[2]);
        this.addValueUsingIterator(this.listMultimap, this.keys[1], 3, this.values[3]);
        Assert.assertThat((Object)this.multimap.isEmpty(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.multimap.size(), (Matcher)Is.is((Object)7));
        this.assertKeys(this.multimap, (K[])new String[]{this.keys[0], this.keys[1]});
        this.assertValues(this.multimap, this.keys[0], (V[])new String[]{this.values[0], this.values[1], this.values[2]});
        this.assertValues(this.multimap, this.keys[1], (V[])new String[]{this.values[0], this.values[1], this.values[2], this.values[3]});
        ArrayList entries = new ArrayList();
        entries.add(this.entry(this.keys[0], this.values[0]));
        entries.add(this.entry(this.keys[1], this.values[0]));
        entries.add(this.entry(this.keys[0], this.values[1]));
        entries.add(this.entry(this.keys[1], this.values[1]));
        entries.add(this.entry(this.keys[0], this.values[2]));
        entries.add(this.entry(this.keys[1], this.values[2]));
        entries.add(this.entry(this.keys[1], this.values[3]));
        this.assertEntries(this.multimap, entries);
    }

    protected void addValueUsingCollection(ListMultimap<String, String> multimap, String key, int atPosition, String value) {
        List values = multimap.get((Object)key);
        values.add(atPosition, value);
    }

    protected void addValueUsingIterator(ListMultimap<String, String> multimap, String key, int atPosition, String value) {
        List values = multimap.get((Object)key);
        ListIterator<String> iter = values.listIterator();
        while (iter.hasNext()) {
            if (iter.nextIndex() == atPosition) {
                iter.add(value);
                return;
            }
            iter.next();
        }
        iter.add(value);
    }

    protected void setValueUsingCollection(ListMultimap<String, String> multimap, String key, int atPosition, String value) {
        List values = multimap.get((Object)key);
        values.set(atPosition, value);
    }

    protected void setValueUsingIterator(ListMultimap<String, String> multimap, String key, int atPosition, String value) {
        List values = multimap.get((Object)key);
        ListIterator<String> iter = values.listIterator();
        while (iter.hasNext()) {
            if (iter.nextIndex() == atPosition) {
                iter.set(value);
                break;
            }
            iter.next();
        }
    }
}

