/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.CommonI18n;
import org.modeshape.common.annotation.Category;
import org.modeshape.common.annotation.Description;
import org.modeshape.common.annotation.Label;
import org.modeshape.common.collection.Problem;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.util.Reflection;
import org.modeshape.common.util.StringUtil;

public class ReflectionTest {
    private String string;
    private List<String> stringList;
    private Reflection stringReflection;
    private Reflection stringListReflection;

    @Before
    public void setUp() {
        this.string = "This is string #";
        this.stringList = new ArrayList<String>();
        for (int i = 0; i != 10; ++i) {
            this.stringList.add(this.string + (i + 1));
        }
        this.stringReflection = new Reflection(String.class);
        this.stringListReflection = new Reflection(List.class);
    }

    @Test
    public void shouldGetClassNameForClass() {
        Assert.assertThat((Object)Reflection.getClassName(String.class), (Matcher)Is.is((Object)String.class.getName()));
        Assert.assertThat((Object)Reflection.getClassName(ArrayList.class), (Matcher)Is.is((Object)ArrayList.class.getName()));
        Assert.assertThat((Object)Reflection.getClassName(StringUtil.class), (Matcher)Is.is((Object)StringUtil.class.getName()));
    }

    @Test
    public void shouldGetClassNameOfInterface() {
        Assert.assertThat((Object)Reflection.getClassName(CharSequence.class), (Matcher)Is.is((Object)CharSequence.class.getName()));
        Assert.assertThat((Object)Reflection.getClassName(List.class), (Matcher)Is.is((Object)List.class.getName()));
    }

    @Test
    public void shouldGetClassNameWithPrimitive() {
        Assert.assertThat((Object)Reflection.getClassName(Integer.TYPE), (Matcher)Is.is((Object)"int"));
        Assert.assertThat((Object)Reflection.getClassName(Boolean.TYPE), (Matcher)Is.is((Object)"boolean"));
        Assert.assertThat((Object)Reflection.getClassName(Long.TYPE), (Matcher)Is.is((Object)"long"));
        Assert.assertThat((Object)Reflection.getClassName(Short.TYPE), (Matcher)Is.is((Object)"short"));
        Assert.assertThat((Object)Reflection.getClassName(Float.TYPE), (Matcher)Is.is((Object)"float"));
        Assert.assertThat((Object)Reflection.getClassName(Double.TYPE), (Matcher)Is.is((Object)"double"));
        Assert.assertThat((Object)Reflection.getClassName(Character.TYPE), (Matcher)Is.is((Object)"char"));
        Assert.assertThat((Object)Reflection.getClassName(Byte.TYPE), (Matcher)Is.is((Object)"byte"));
        Assert.assertThat((Object)Reflection.getClassName(Void.TYPE), (Matcher)Is.is((Object)"void"));
    }

    @Test
    public void shouldGetClassNameWith1DPrimitiveArray() {
        Assert.assertThat((Object)Reflection.getClassName(new int[0].getClass()), (Matcher)Is.is((Object)"int[]"));
        Assert.assertThat((Object)Reflection.getClassName(new boolean[0].getClass()), (Matcher)Is.is((Object)"boolean[]"));
        Assert.assertThat((Object)Reflection.getClassName(new long[0].getClass()), (Matcher)Is.is((Object)"long[]"));
        Assert.assertThat((Object)Reflection.getClassName(new short[0].getClass()), (Matcher)Is.is((Object)"short[]"));
        Assert.assertThat((Object)Reflection.getClassName(new float[0].getClass()), (Matcher)Is.is((Object)"float[]"));
        Assert.assertThat((Object)Reflection.getClassName(new double[0].getClass()), (Matcher)Is.is((Object)"double[]"));
        Assert.assertThat((Object)Reflection.getClassName(new char[0].getClass()), (Matcher)Is.is((Object)"char[]"));
        Assert.assertThat((Object)Reflection.getClassName(new byte[0].getClass()), (Matcher)Is.is((Object)"byte[]"));
    }

    @Test
    public void shouldGetClassNameWith2DPrimitiveArray() {
        Assert.assertThat((Object)Reflection.getClassName(new int[0][0].getClass()), (Matcher)Is.is((Object)"int[][]"));
        Assert.assertThat((Object)Reflection.getClassName(new boolean[0][0].getClass()), (Matcher)Is.is((Object)"boolean[][]"));
        Assert.assertThat((Object)Reflection.getClassName(new long[0][0].getClass()), (Matcher)Is.is((Object)"long[][]"));
        Assert.assertThat((Object)Reflection.getClassName(new short[0][0].getClass()), (Matcher)Is.is((Object)"short[][]"));
        Assert.assertThat((Object)Reflection.getClassName(new float[0][0].getClass()), (Matcher)Is.is((Object)"float[][]"));
        Assert.assertThat((Object)Reflection.getClassName(new double[0][0].getClass()), (Matcher)Is.is((Object)"double[][]"));
        Assert.assertThat((Object)Reflection.getClassName(new char[0][0].getClass()), (Matcher)Is.is((Object)"char[][]"));
        Assert.assertThat((Object)Reflection.getClassName(new byte[0][0].getClass()), (Matcher)Is.is((Object)"byte[][]"));
    }

    @Test
    public void shouldGetClassNameWith3DPrimitiveArray() {
        Assert.assertThat((Object)Reflection.getClassName(new int[0][0][0].getClass()), (Matcher)Is.is((Object)"int[][][]"));
        Assert.assertThat((Object)Reflection.getClassName(new boolean[0][0][0].getClass()), (Matcher)Is.is((Object)"boolean[][][]"));
        Assert.assertThat((Object)Reflection.getClassName(new long[0][0][0].getClass()), (Matcher)Is.is((Object)"long[][][]"));
        Assert.assertThat((Object)Reflection.getClassName(new short[0][0][0].getClass()), (Matcher)Is.is((Object)"short[][][]"));
        Assert.assertThat((Object)Reflection.getClassName(new float[0][0][0].getClass()), (Matcher)Is.is((Object)"float[][][]"));
        Assert.assertThat((Object)Reflection.getClassName(new double[0][0][0].getClass()), (Matcher)Is.is((Object)"double[][][]"));
        Assert.assertThat((Object)Reflection.getClassName(new char[0][0][0].getClass()), (Matcher)Is.is((Object)"char[][][]"));
        Assert.assertThat((Object)Reflection.getClassName(new byte[0][0][0].getClass()), (Matcher)Is.is((Object)"byte[][][]"));
    }

    @Test
    public void shouldGetClassNameWith8DPrimitiveArray() {
        Assert.assertThat((Object)Reflection.getClassName(new int[0][0][0][0][0][0][0][0].getClass()), (Matcher)Is.is((Object)"int[][][][][][][][]"));
        Assert.assertThat((Object)Reflection.getClassName(new boolean[0][0][0][0][0][0][0][0].getClass()), (Matcher)Is.is((Object)"boolean[][][][][][][][]"));
        Assert.assertThat((Object)Reflection.getClassName(new long[0][0][0][0][0][0][0][0].getClass()), (Matcher)Is.is((Object)"long[][][][][][][][]"));
        Assert.assertThat((Object)Reflection.getClassName(new short[0][0][0][0][0][0][0][0].getClass()), (Matcher)Is.is((Object)"short[][][][][][][][]"));
        Assert.assertThat((Object)Reflection.getClassName(new float[0][0][0][0][0][0][0][0].getClass()), (Matcher)Is.is((Object)"float[][][][][][][][]"));
        Assert.assertThat((Object)Reflection.getClassName(new double[0][0][0][0][0][0][0][0].getClass()), (Matcher)Is.is((Object)"double[][][][][][][][]"));
        Assert.assertThat((Object)Reflection.getClassName(new char[0][0][0][0][0][0][0][0].getClass()), (Matcher)Is.is((Object)"char[][][][][][][][]"));
        Assert.assertThat((Object)Reflection.getClassName(new byte[0][0][0][0][0][0][0][0].getClass()), (Matcher)Is.is((Object)"byte[][][][][][][][]"));
    }

    @Test
    public void shouldHaveTargetClass() {
        Assert.assertThat((Object)(this.stringReflection.getTargetClass() == String.class ? 1 : 0), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)(this.stringListReflection.getTargetClass() == List.class ? 1 : 0), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldFindMethodsWithExactMatchingName() {
        Method[] stringMethods = this.stringReflection.findMethods("indexOf", true);
        Assert.assertThat((Object)stringMethods.length, (Matcher)Is.is((Object)4));
        for (Method method : stringMethods) {
            Assert.assertThat((Object)method.getName(), (Matcher)Is.is((Object)"indexOf"));
        }
        stringMethods = this.stringReflection.findMethods("length", true);
        Assert.assertThat((Object)stringMethods.length, (Matcher)Is.is((Object)1));
        for (Method method : stringMethods) {
            Assert.assertThat((Object)method.getName(), (Matcher)Is.is((Object)"length"));
        }
    }

    @Test
    public void shouldFindMethodsWithNameMatchingRegularExpression() {
        Method[] stringMethods = this.stringReflection.findMethods("indexO.", true);
        Assert.assertThat((Object)stringMethods.length, (Matcher)Is.is((Object)4));
        for (Method method : stringMethods) {
            Assert.assertThat((Object)method.getName(), (Matcher)Is.is((Object)"indexOf"));
        }
        stringMethods = this.stringReflection.findMethods(".+gth", true);
        Assert.assertThat((Object)stringMethods.length, (Matcher)Is.is((Object)1));
        for (Method method : stringMethods) {
            Assert.assertThat((Object)method.getName(), (Matcher)Is.is((Object)"length"));
        }
    }

    @Test
    public void shouldNotFindMethodsWhenThereAreNoMethodsWithThatName() {
        Assert.assertThat((Object)this.stringReflection.findMethods("size", true).length, (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.stringListReflection.findMethods("argleBargle", true).length, (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldGetAllPropertiesOnJavaBean() throws Exception {
        Problem.Status status = Problem.Status.INFO;
        int code = 121;
        I18n msg = CommonI18n.argumentMayNotBeEmpty;
        Object[] params = new Object[]{"argName"};
        String resource = "The source";
        String location = "The place to be";
        Throwable throwable = null;
        Problem problem = new Problem(status, code, msg, params, resource, location, throwable);
        Reflection reflection = new Reflection(Problem.class);
        List props = reflection.getAllPropertiesOn((Object)problem);
        Map propsByName = reflection.getAllPropertiesByNameOn((Object)problem);
        Assert.assertThat((Object)props.size(), (Matcher)Is.is((Object)8));
        Assert.assertThat((Object)propsByName.size(), (Matcher)Is.is((Object)8));
        Assert.assertThat((Object)props.containsAll(propsByName.values()), (Matcher)Is.is((Object)true));
        Reflection.Property property = (Reflection.Property)propsByName.remove("status");
        Assert.assertThat((Object)property.getName(), (Matcher)Is.is((Object)"status"));
        Assert.assertThat((Object)property.getLabel(), (Matcher)Is.is((Object)"Status"));
        Assert.assertThat((Object)property.getType().equals(Problem.Status.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)property.isReadOnly(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)property, (Matcher)Is.is((Object)this.findProperty(property.getName(), props)));
        this.assertValue(reflection, problem, property, status);
        property = (Reflection.Property)propsByName.remove("code");
        Assert.assertThat((Object)property.getName(), (Matcher)Is.is((Object)"code"));
        Assert.assertThat((Object)property.getLabel(), (Matcher)Is.is((Object)"Code"));
        Assert.assertThat((Object)property.getType().equals(Integer.TYPE), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)property.isReadOnly(), (Matcher)Is.is((Object)true));
        this.assertValue(reflection, problem, property, code);
        property = (Reflection.Property)propsByName.remove("message");
        Assert.assertThat((Object)property.getName(), (Matcher)Is.is((Object)"message"));
        Assert.assertThat((Object)property.getLabel(), (Matcher)Is.is((Object)"Message"));
        Assert.assertThat((Object)property.getType().equals(I18n.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)property.isReadOnly(), (Matcher)Is.is((Object)true));
        this.assertValue(reflection, problem, property, msg);
        property = (Reflection.Property)propsByName.remove("messageString");
        Assert.assertThat((Object)property.getName(), (Matcher)Is.is((Object)"messageString"));
        Assert.assertThat((Object)property.getLabel(), (Matcher)Is.is((Object)"Message String"));
        Assert.assertThat((Object)property.getType().equals(String.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)property.isReadOnly(), (Matcher)Is.is((Object)true));
        this.assertValue(reflection, problem, property, msg.text(params));
        property = (Reflection.Property)propsByName.remove("parameters");
        Assert.assertThat((Object)property.getName(), (Matcher)Is.is((Object)"parameters"));
        Assert.assertThat((Object)property.getLabel(), (Matcher)Is.is((Object)"Parameters"));
        Assert.assertThat((Object)property.getType().equals(Object[].class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)property.isReadOnly(), (Matcher)Is.is((Object)true));
        this.assertValue(reflection, problem, property, params);
        property = (Reflection.Property)propsByName.remove("resource");
        Assert.assertThat((Object)property.getName(), (Matcher)Is.is((Object)"resource"));
        Assert.assertThat((Object)property.getLabel(), (Matcher)Is.is((Object)"Resource"));
        Assert.assertThat((Object)property.getType().equals(String.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)property.isReadOnly(), (Matcher)Is.is((Object)true));
        this.assertValue(reflection, problem, property, resource);
        property = (Reflection.Property)propsByName.remove("location");
        Assert.assertThat((Object)property.getName(), (Matcher)Is.is((Object)"location"));
        Assert.assertThat((Object)property.getLabel(), (Matcher)Is.is((Object)"Location"));
        Assert.assertThat((Object)property.getType().equals(String.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)property.isReadOnly(), (Matcher)Is.is((Object)true));
        this.assertValue(reflection, problem, property, location);
        property = (Reflection.Property)propsByName.remove("throwable");
        Assert.assertThat((Object)property.getName(), (Matcher)Is.is((Object)"throwable"));
        Assert.assertThat((Object)property.getLabel(), (Matcher)Is.is((Object)"Throwable"));
        Assert.assertThat((Object)property.getType().equals(Throwable.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)property.isReadOnly(), (Matcher)Is.is((Object)true));
        this.assertValue(reflection, problem, property, throwable);
        Assert.assertThat((Object)propsByName.isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldUseAnnotationsOnClassFieldsForProperties() throws Exception {
        SomeStructure structure = new SomeStructure();
        structure.setCount(33);
        structure.setIdentifier("This is the identifier value");
        Reflection reflection = new Reflection(SomeStructure.class);
        List props = reflection.getAllPropertiesOn((Object)structure);
        Map propsByName = reflection.getAllPropertiesByNameOn((Object)structure);
        Assert.assertThat((Object)props.size(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)propsByName.size(), (Matcher)Is.is((Object)3));
        Reflection.Property property = (Reflection.Property)propsByName.remove("identifier");
        Assert.assertThat((Object)property.getName(), (Matcher)Is.is((Object)"identifier"));
        Assert.assertThat((Object)property.getLabel(), (Matcher)Is.is((Object)CommonI18n.noMoreContent.text(new Object[0])));
        Assert.assertThat((Object)property.getDescription(), (Matcher)Is.is((Object)CommonI18n.nullActivityMonitorTaskName.text(new Object[0])));
        Assert.assertThat((Object)property.getCategory(), (Matcher)Is.is((Object)CommonI18n.noMoreContent.text(new Object[0])));
        Assert.assertThat((Object)property.getType().equals(String.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)property.isReadOnly(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)property, (Matcher)Is.is((Object)this.findProperty(property.getName(), props)));
        this.assertValue(reflection, structure, property, structure.getIdentifier());
        property = (Reflection.Property)propsByName.remove("count");
        Assert.assertThat((Object)property.getName(), (Matcher)Is.is((Object)"count"));
        Assert.assertThat((Object)property.getLabel(), (Matcher)Is.is((Object)"Count"));
        Assert.assertThat((Object)property.getDescription(), (Matcher)Is.is((Object)"This is the count"));
        Assert.assertThat((Object)property.getCategory(), (Matcher)Is.is((Object)""));
        Assert.assertThat((Object)property.getType().equals(Integer.TYPE), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)property.isReadOnly(), (Matcher)Is.is((Object)false));
        this.assertValue(reflection, structure, property, structure.getCount());
        property = (Reflection.Property)propsByName.remove("onFire");
        Assert.assertThat((Object)property.getName(), (Matcher)Is.is((Object)"onFire"));
        Assert.assertThat((Object)property.getLabel(), (Matcher)Is.is((Object)"On Fire"));
        Assert.assertThat((Object)property.getDescription(), (Matcher)Is.is((Object)""));
        Assert.assertThat((Object)property.getCategory(), (Matcher)Is.is((Object)""));
        Assert.assertThat((Object)property.getType().equals(Boolean.TYPE), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)property.isReadOnly(), (Matcher)Is.is((Object)true));
        this.assertValue(reflection, structure, property, structure.isOnFire());
    }

    protected void assertValue(Reflection reflection, Object target, Reflection.Property property, Object expectedValue) throws Exception {
        Object actual = reflection.getProperty(target, property);
        Assert.assertThat((Object)actual, (Matcher)Is.is((Object)expectedValue));
        Assert.assertThat((Object)reflection.getPropertyAsString(target, property), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    protected Reflection.Property findProperty(String propertyName, List<Reflection.Property> properties) {
        for (Reflection.Property prop : properties) {
            if (!prop.getName().equals(propertyName)) continue;
            return prop;
        }
        return null;
    }

    protected static class SomeStructure {
        @Category(i18n=CommonI18n.class, value="noMoreContent")
        @Label(i18n=CommonI18n.class, value="noMoreContent")
        @Description(i18n=CommonI18n.class, value="nullActivityMonitorTaskName")
        private String identifier;
        @Description(value="This is the count")
        private int count;
        private boolean onFire;

        protected SomeStructure() {
        }

        public int getCount() {
            return this.count;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public boolean isOnFire() {
            return this.onFire;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public void setIdentifier(String identifier) {
            this.identifier = identifier;
        }
    }
}

