/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.util;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.common.util.HashCode;

public class HashCodeTest {
    @Test
    public void shouldComputeHashCodeForOnePrimitive() {
        Assert.assertThat((Object)HashCode._compute((int)1, (Object[])new Object[0]), (Matcher)Is.is((Matcher)IsNot.not((Object)0)));
        Assert.assertThat((Object)HashCode.compute((Object[])new Object[]{8L}), (Matcher)Is.is((Matcher)IsNot.not((Object)0)));
        Assert.assertThat((Object)HashCode._compute((int)3, (Object[])new Object[0]), (Matcher)Is.is((Matcher)IsNot.not((Object)0)));
        Assert.assertThat((Object)HashCode.compute((Object[])new Object[]{Float.valueOf(1.0f)}), (Matcher)Is.is((Matcher)IsNot.not((Object)0)));
        Assert.assertThat((Object)HashCode.compute((Object[])new Object[]{1.0}), (Matcher)Is.is((Matcher)IsNot.not((Object)0)));
        Assert.assertThat((Object)HashCode.compute((Object[])new Object[]{true}), (Matcher)Is.is((Matcher)IsNot.not((Object)0)));
    }

    @Test
    public void shouldComputeHashCodeForMultiplePrimitives() {
        Assert.assertThat((Object)HashCode._compute((int)1, (Object[])new Object[]{2, 3}), (Matcher)Is.is((Matcher)IsNot.not((Object)0)));
        Assert.assertThat((Object)HashCode.compute((Object[])new Object[]{8L, 22L, 33}), (Matcher)Is.is((Matcher)IsNot.not((Object)0)));
        Assert.assertThat((Object)HashCode._compute((int)3, (Object[])new Object[]{22L, true}), (Matcher)Is.is((Matcher)IsNot.not((Object)0)));
    }

    @Test
    public void shouldAcceptNoArguments() {
        Assert.assertThat((Object)HashCode.compute((Object[])new Object[0]), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldAcceptNullArguments() {
        Assert.assertThat((Object)HashCode.compute((Object[])new Object[]{null}), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)HashCode.compute((Object[])new Object[]{"abc", null}), (Matcher)Is.is((Matcher)IsNot.not((Object)0)));
    }
}

