/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.util;

import java.io.File;
import java.io.InputStream;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.util.MimeTypeUtil;

@Deprecated
public class MimeTypeUtilTest {
    private MimeTypeUtil detector;

    @Before
    public void beforeEach() throws Exception {
        this.detector = new MimeTypeUtil();
    }

    @Test
    public void shouldFindMimeTypeForExtenionsInStandardPropertiesFile() {
        Assert.assertThat((Object)this.detector.mimeTypeOf("something.txt"), (Matcher)Is.is((Object)"text/plain"));
    }

    @Test
    public void shouldFindMimeTypeForOneCharacterExtension() {
        Assert.assertThat((Object)this.detector.mimeTypeOf("something.gzip.Z"), (Matcher)Is.is((Object)"application/x-compress"));
    }

    @Test
    public void shouldFindMimeTypeForTwoCharacterExtension() {
        Assert.assertThat((Object)this.detector.mimeTypeOf("something.sh"), (Matcher)Is.is((Object)"application/x-sh"));
    }

    @Test
    public void shouldFindMimeTypeForThreeCharacterExtension() {
        Assert.assertThat((Object)this.detector.mimeTypeOf("something.png"), (Matcher)Is.is((Object)"image/png"));
    }

    @Test
    public void shouldNotFindMimeTypeForNameWithoutExtension() {
        Assert.assertThat((Object)this.detector.mimeTypeOf("something"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldNotFindMimeTypeForNameUnknownExtension() {
        Assert.assertThat((Object)this.detector.mimeTypeOf("something.thisExtensionIsNotKnown"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldNotFindMimeTypeForZeroLengthName() {
        Assert.assertThat((Object)this.detector.mimeTypeOf(""), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldNotFindMimeTypeForNameContainingWhitespace() {
        Assert.assertThat((Object)this.detector.mimeTypeOf("/t   /n  "), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldNotFindMimeTypeForNullName() {
        Assert.assertThat((Object)this.detector.mimeTypeOf((String)null), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldNotFindMimeTypeForNullFile() {
        Assert.assertThat((Object)this.detector.mimeTypeOf((File)null), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldFindMimeTypeForUppercaseExtenionsInStandardPropertiesFile() {
        Assert.assertThat((Object)this.detector.mimeTypeOf("something.TXT"), (Matcher)Is.is((Object)"text/plain"));
    }

    @Test
    public void shouldFindMimeTypeForNameWithTrailingWhitespace() {
        Assert.assertThat((Object)this.detector.mimeTypeOf("something.txt \t"), (Matcher)Is.is((Object)"text/plain"));
    }

    @Test
    public void shouldLoadAdditionalMimeTypeMappings() {
        String iniFile = ".ini";
        Assert.assertNull((Object)this.detector.mimeTypeOf(iniFile));
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream("org/modeshape/common/util/additionalmime.types");
        Map customMap = MimeTypeUtil.load((InputStream)stream, null);
        Assert.assertThat((Object)customMap.size(), (Matcher)Is.is((Object)3));
        this.detector = new MimeTypeUtil(customMap, false);
        Assert.assertThat((Object)this.detector.mimeTypeOf(iniFile), (Matcher)Is.is((Object)"text/plain"));
        Assert.assertThat((Object)this.detector.mimeTypeOf(".properties"), (Matcher)Is.is((Object)"text/plain"));
        Assert.assertThat((Object)this.detector.mimeTypeOf(".xsd"), (Matcher)Is.is((Object)"application/xml"));
    }

    @Test
    public void shouldFindMimeTypeOfHiddenFiles() {
        Assert.assertThat((Object)this.detector.mimeTypeOf(".txt"), (Matcher)Is.is((Object)"text/plain"));
    }
}

