/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.collection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.modeshape.common.collection.ImmutableAppendedList;

public class ImmutableAppendedListTest {
    private List<String> list;
    private List<String> parent;
    private String[] data;

    @Before
    public void beforeEach() {
        this.data = new String[]{"a", "b", "c", "d", "e"};
        this.parent = new ArrayList<String>(5);
        for (int i = 0; i != 4; ++i) {
            this.parent.add(this.data[i]);
        }
        this.list = new ImmutableAppendedList(this.parent, (Object)this.data[4]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCreatingWithNullParentList() {
        this.list = new ImmutableAppendedList(null, (Object)this.data[4]);
    }

    @Test
    public void shouldAllowCreatingWithEmptyParentList() {
        this.data = new String[]{this.data[0], this.data[1]};
        this.parent = Collections.singletonList(this.data[0]);
        this.list = new ImmutableAppendedList(this.parent, (Object)this.data[1]);
        Assert.assertThat(this.list, (Matcher)JUnitMatchers.hasItems((Object[])this.data));
        Assert.assertThat((Object)this.list.size(), (Matcher)Is.is((Object)(this.parent.size() + 1)));
        Assert.assertThat((Object)this.list.toArray(), (Matcher)Is.is((Object)this.data));
        Assert.assertThat((Object)this.list.toArray(new String[this.list.size()]), (Matcher)Is.is((Object)this.data));
        Assert.assertThat((Object)this.list.toArray(new String[this.list.size() - 1]), (Matcher)Is.is((Object)this.data));
        Assert.assertThat((Object)this.list.isEmpty(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldAllowCreatingAppendedListWithNullForFinalElement() {
        this.data[4] = null;
        this.list = new ImmutableAppendedList(this.parent, (Object)this.data[4]);
        Assert.assertThat(this.list, (Matcher)JUnitMatchers.hasItems((Object[])this.data));
    }

    @Test
    public void shouldHaveSizeOfParentPlusOne() {
        Assert.assertThat((Object)this.list.size(), (Matcher)Is.is((Object)(this.parent.size() + 1)));
    }

    @Test
    public void shouldConvertToArrayContainingAllValues() {
        Assert.assertThat((Object)this.list.toArray(), (Matcher)Is.is((Object)this.data));
    }

    @Test
    public void shouldConvertToSuppliedArrayContainingAllValues() {
        Assert.assertThat((Object)this.list.toArray(new String[this.list.size()]), (Matcher)Is.is((Object)this.data));
    }

    @Test
    public void shouldConvertToTooSmallSuppliedArrayContainingAllValues() {
        Assert.assertThat((Object)this.list.toArray(new String[this.list.size() - 1]), (Matcher)Is.is((Object)this.data));
    }

    @Test
    public void shouldIterateOverAllValues() {
        Iterator<String> iter = this.list.iterator();
        int i = 0;
        while (iter.hasNext()) {
            Assert.assertThat((Object)iter.next(), (Matcher)Is.is((Object)this.data[i++]));
        }
    }

    @Test
    public void shouldIterateOverAllValuesUsingListIterator() {
        ArrayList<String> copy = new ArrayList<String>(this.list);
        Assert.assertThat((Object)copy.size(), (Matcher)Is.is((Object)this.list.size()));
        ListIterator<String> listIter = this.list.listIterator();
        ListIterator copyIter = copy.listIterator();
        for (int i = 0; i != 3; ++i) {
            Assert.assertThat((Object)listIter.hasPrevious(), (Matcher)Is.is((Object)false));
            Assert.assertThat((Object)copyIter.hasPrevious(), (Matcher)Is.is((Object)false));
            while (listIter.hasNext()) {
                Assert.assertThat((Object)listIter.next(), (Matcher)Is.is(copyIter.next()));
            }
            Assert.assertThat((Object)listIter.hasNext(), (Matcher)Is.is((Object)false));
            Assert.assertThat((Object)copyIter.hasNext(), (Matcher)Is.is((Object)false));
            while (listIter.hasPrevious()) {
                Assert.assertThat((Object)listIter.previous(), (Matcher)Is.is(copyIter.previous()));
            }
        }
        Assert.assertThat((Object)listIter.hasPrevious(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)copyIter.hasPrevious(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldIterateBackwardsOverAllValuesUsingListIterator() {
        ArrayList<String> copy = new ArrayList<String>(this.list);
        Assert.assertThat((Object)copy.size(), (Matcher)Is.is((Object)this.list.size()));
        ListIterator<String> listIter = this.list.listIterator(this.list.size());
        ListIterator copyIter = copy.listIterator(copy.size());
        Assert.assertThat((Object)listIter.hasNext(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)copyIter.hasNext(), (Matcher)Is.is((Object)false));
        while (listIter.hasPrevious()) {
            Assert.assertThat((Object)listIter.previous(), (Matcher)Is.is(copyIter.previous()));
        }
        Assert.assertThat((Object)listIter.hasPrevious(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)copyIter.hasPrevious(), (Matcher)Is.is((Object)false));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldNotAllowAddingAnElement() {
        this.list.add(null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldNotAllowAddingAnElementByIndex() {
        this.list.add(0, null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldNotAllowAddingACollection() {
        this.list.addAll(this.parent);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldNotAllowAddingACollectionWithIndex() {
        this.list.addAll(1, this.parent);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldNotAllowRemovingAnElement() {
        this.list.remove(null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldNotAllowRemovingAnElementByIndex() {
        this.list.remove(0);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldNotAllowRemovingAllElementsInACollection() {
        this.list.removeAll(null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldNotAllowRetainingAllElementsInACollection() {
        this.list.retainAll(null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldNotAllowSettingElementByIndex() {
        this.list.set(0, null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldNotAllowClearingList() {
        this.list.clear();
    }

    @Test
    public void shouldReturnSameHashCodeMultipleTimes() {
        int hc = this.list.hashCode();
        for (int i = 0; i != 100; ++i) {
            Assert.assertThat((Object)this.list.hashCode(), (Matcher)Is.is((Object)hc));
        }
    }

    @Test
    public void shouldReturnSameHashCodeAsEquivalentArrayList() {
        ArrayList<String> copy = new ArrayList<String>(this.list);
        Assert.assertThat((Object)this.list.hashCode(), (Matcher)Is.is((Object)copy.hashCode()));
    }

    @Test
    public void shouldBeEqualToEquivalentArrayList() {
        ArrayList<String> copy = new ArrayList<String>(this.list);
        Assert.assertThat((Object)this.list.equals(copy), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldHaveToStringThatIsTheSameAsEquivalentArrayList() {
        ArrayList<String> copy = new ArrayList<String>(this.list);
        Assert.assertThat((Object)this.list.toString(), (Matcher)Is.is((Object)((Object)copy).toString()));
    }

    @Test
    public void shouldFindLastIndexOfEachValue() {
        for (int i = 0; i != this.data.length; ++i) {
            String value = this.data[i];
            int lastIndex = this.list.lastIndexOf(value);
            Assert.assertThat((Object)lastIndex, (Matcher)Is.is((Object)i));
        }
    }

    @Test
    public void shouldNotFindLastIndexOfValuesThatAreNotInList() {
        Assert.assertThat((Object)this.list.lastIndexOf("not found"), (Matcher)Is.is((Object)-1));
        Assert.assertThat((Object)this.list.lastIndexOf(null), (Matcher)Is.is((Object)-1));
    }

    @Test
    public void shouldFindIndexOfEachValue() {
        for (int i = 0; i != this.data.length; ++i) {
            String value = this.data[i];
            int lastIndex = this.list.lastIndexOf(value);
            Assert.assertThat((Object)lastIndex, (Matcher)Is.is((Object)i));
        }
    }

    @Test
    public void shouldNotFindIndexOfValuesThatAreNotInList() {
        Assert.assertThat((Object)this.list.lastIndexOf("not found"), (Matcher)Is.is((Object)-1));
        Assert.assertThat((Object)this.list.lastIndexOf(null), (Matcher)Is.is((Object)-1));
    }

    @Test
    public void shouldGetValuesByIndex() {
        for (int i = 0; i != this.data.length; ++i) {
            String expectedValue = this.data[i];
            String actualValue = this.list.get(i);
            Assert.assertThat((Object)actualValue, (Matcher)Is.is((Object)expectedValue));
        }
    }

    @Test
    public void shouldContainEachValue() {
        for (int i = 0; i != this.data.length; ++i) {
            String value = this.data[i];
            Assert.assertThat((Object)this.list.contains(value), (Matcher)Is.is((Object)true));
        }
    }

    @Test
    public void shouldNotContainValuesThatAreNotInList() {
        Assert.assertThat((Object)this.list.contains("not found"), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.list.contains(null), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldContainAllValuesInDuplicateCollection() {
        ArrayList<String> copy = new ArrayList<String>(this.list);
        Assert.assertThat((Object)this.list.containsAll(copy), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)copy.containsAll(this.list), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldNeverBeEmpty() {
        Assert.assertThat((Object)this.list.isEmpty(), (Matcher)Is.is((Object)false));
    }
}

