/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.common.util.StringUtil;

public class StringUtilTest {
    public void compareSeparatedLines(Object ... lines) {
        ByteArrayOutputStream content = new ByteArrayOutputStream();
        PrintStream stream = new PrintStream(content);
        for (Object line : lines) {
            stream.println(line);
        }
        List actualLines = StringUtil.splitLines((String)content.toString());
        Assert.assertArrayEquals((Object[])lines, (Object[])actualLines.toArray());
    }

    @Test
    public void splitLinesShouldWorkCorrectly() {
        this.compareSeparatedLines("Line 1", "Line 2", "Line 3", "Line 4");
    }

    @Test(expected=IllegalArgumentException.class)
    public void createStringShouldFailIfNoPatternSupplied() {
        StringUtil.createString(null, (Object[])null);
    }

    @Test
    public void createStringShouldAllowNoParametersSupplied() {
        Assert.assertThat((Object)StringUtil.createString((String)"test", (Object[])null), (Matcher)Is.is((Object)"test"));
    }

    @Test
    public void createStringShouldCreateStringFromPattern() {
        String pattern = "This {0} is {1} should {2} not {3} last {4}";
        Assert.assertEquals((Object)"This one is two should three not four last five", (Object)StringUtil.createString((String)pattern, (Object[])new Object[]{"one", "two", "three", "four", "five"}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void createStringShouldFailIfTooFewArgumentsSupplied() {
        String pattern = "This {0} is {1} should {2} not {3} last {4}";
        try {
            StringUtil.createString((String)pattern, (Object[])new Object[]{"one", "two", "three", "four"});
        }
        catch (IllegalArgumentException err) {
            System.err.println(err);
            throw err;
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void createStringShouldFailIfTooManyArgumentsSupplied() {
        String pattern = "This {0} is {1} should {2} not {3} last {4}";
        try {
            StringUtil.createString((String)pattern, (Object[])new Object[]{"one", "two", "three", "four", "five", "six"});
        }
        catch (IllegalArgumentException err) {
            System.err.println(err);
            throw err;
        }
    }

    @Test
    public void createStringExceptionMessageShouldbeGrammaticallyCorrect() {
        String pattern = "One = {0}";
        try {
            StringUtil.createString((String)pattern, (Object[])new Object[0]);
        }
        catch (IllegalArgumentException err) {
            Assert.assertThat((Object)err.getMessage().startsWith("0 parameters supplied, but 1 parameter required"), (Matcher)Is.is((Object)true));
        }
        pattern = "One";
        try {
            StringUtil.createString((String)pattern, (Object[])new Object[]{"one"});
        }
        catch (IllegalArgumentException err) {
            Assert.assertThat((Object)err.getMessage().startsWith("1 parameter supplied, but 0 parameters required"), (Matcher)Is.is((Object)true));
        }
        pattern = "One = {0}, Two = {1}";
        try {
            StringUtil.createString((String)pattern, (Object[])new Object[0]);
        }
        catch (IllegalArgumentException err) {
            Assert.assertThat((Object)err.getMessage().startsWith("0 parameters supplied, but 2 parameters required"), (Matcher)Is.is((Object)true));
        }
    }

    @Test
    public void setLengthShouldTruncateStringsThatAreTooLong() {
        Assert.assertEquals((Object)"This is the st", (Object)StringUtil.setLength((String)"This is the string", (int)14, (char)' '));
    }

    @Test
    public void setLengthShouldAppendCharacterForStringsThatAreTooShort() {
        Assert.assertEquals((Object)"This      ", (Object)StringUtil.setLength((String)"This", (int)10, (char)' '));
    }

    @Test
    public void setLengthShouldNotRemoveLeadingWhitespace() {
        Assert.assertEquals((Object)" This     ", (Object)StringUtil.setLength((String)" This", (int)10, (char)' '));
        Assert.assertEquals((Object)"\tThis     ", (Object)StringUtil.setLength((String)"\tThis", (int)10, (char)' '));
    }

    @Test
    public void setLengthShouldAppendCharacterForEmptyStrings() {
        Assert.assertEquals((Object)"          ", (Object)StringUtil.setLength((String)"", (int)10, (char)' '));
    }

    @Test
    public void setLengthShouldAppendCharacterForNullStrings() {
        Assert.assertEquals((Object)"          ", (Object)StringUtil.setLength(null, (int)10, (char)' '));
    }

    @Test
    public void setLengthShouldReturnStringsThatAreTheDesiredLength() {
        Assert.assertEquals((Object)"This is the string", (Object)StringUtil.setLength((String)"This is the string", (int)18, (char)' '));
    }

    @Test
    public void justifyLeftShouldTruncateStringsThatAreTooLong() {
        Assert.assertEquals((Object)"This is the st", (Object)StringUtil.justifyLeft((String)"This is the string", (int)14, (char)' '));
    }

    @Test
    public void justifyLeftShouldAppendCharacterForStringsThatAreTooShort() {
        Assert.assertEquals((Object)"This      ", (Object)StringUtil.justifyLeft((String)"This", (int)10, (char)' '));
    }

    @Test
    public void justifyLeftShouldRemoveLeadingWhitespace() {
        Assert.assertEquals((Object)"This      ", (Object)StringUtil.justifyLeft((String)" This", (int)10, (char)' '));
        Assert.assertEquals((Object)"This      ", (Object)StringUtil.justifyLeft((String)"\tThis", (int)10, (char)' '));
    }

    @Test
    public void justifyLeftShouldAppendCharacterForEmptyStrings() {
        Assert.assertEquals((Object)"          ", (Object)StringUtil.justifyLeft((String)"", (int)10, (char)' '));
    }

    @Test
    public void justifyLeftShouldAppendCharacterForNullStrings() {
        Assert.assertEquals((Object)"          ", (Object)StringUtil.justifyLeft(null, (int)10, (char)' '));
    }

    @Test
    public void justifyLeftShouldReturnStringsThatAreTheDesiredLength() {
        Assert.assertEquals((Object)"This is the string", (Object)StringUtil.justifyLeft((String)"This is the string", (int)18, (char)' '));
    }

    @Test
    public void justifyRightShouldTruncateStringsThatAreTooLong() {
        Assert.assertEquals((Object)" is the string", (Object)StringUtil.justifyRight((String)"This is the string", (int)14, (char)' '));
    }

    @Test
    public void justifyRightShouldPrependCharacterForStringsThatAreTooShort() {
        Assert.assertEquals((Object)"      This", (Object)StringUtil.justifyRight((String)"This", (int)10, (char)' '));
    }

    @Test
    public void justifyRightShouldPrependCharacterForEmptyStrings() {
        Assert.assertEquals((Object)"          ", (Object)StringUtil.justifyRight((String)"", (int)10, (char)' '));
    }

    @Test
    public void justifyRightShouldPrependCharacterForNullStrings() {
        Assert.assertEquals((Object)"          ", (Object)StringUtil.justifyRight(null, (int)10, (char)' '));
    }

    @Test
    public void justifyRightShouldReturnStringsThatAreTheDesiredLength() {
        Assert.assertEquals((Object)"This is the string", (Object)StringUtil.justifyRight((String)"This is the string", (int)18, (char)' '));
    }

    @Test
    public void justifyCenterShouldTruncateStringsThatAreTooLong() {
        Assert.assertEquals((Object)"This is the st", (Object)StringUtil.justifyCenter((String)"This is the string", (int)14, (char)' '));
    }

    @Test
    public void justifyCenterShouldPrependAndAppendSameNumberOfCharacterForStringsThatAreTooShortButOfAnEvenLength() {
        Assert.assertEquals((Object)"   This   ", (Object)StringUtil.justifyCenter((String)"This", (int)10, (char)' '));
    }

    @Test
    public void justifyCenterShouldPrependOneMoreCharacterThanAppendingForStringsThatAreTooShortButOfAnOddLength() {
        Assert.assertEquals((Object)"   Thing  ", (Object)StringUtil.justifyCenter((String)"Thing", (int)10, (char)' '));
    }

    @Test
    public void justifyCenterShouldPrependCharacterForEmptyStrings() {
        Assert.assertEquals((Object)"          ", (Object)StringUtil.justifyCenter((String)"", (int)10, (char)' '));
    }

    @Test
    public void justifyCenterShouldPrependCharacterForNullStrings() {
        Assert.assertEquals((Object)"          ", (Object)StringUtil.justifyCenter(null, (int)10, (char)' '));
    }

    @Test
    public void justifyCenterShouldReturnStringsThatAreTheDesiredLength() {
        Assert.assertEquals((Object)"This is the string", (Object)StringUtil.justifyCenter((String)"This is the string", (int)18, (char)' '));
    }

    @Test
    public void truncateShouldReturnEmptyStringIfNullReferenceIsSupplied() {
        Assert.assertThat((Object)StringUtil.truncate(null, (int)0), (Matcher)Is.is((Object)""));
        Assert.assertThat((Object)StringUtil.truncate(null, (int)1), (Matcher)Is.is((Object)""));
        Assert.assertThat((Object)StringUtil.truncate(null, (int)100), (Matcher)Is.is((Object)""));
    }

    @Test(expected=IllegalArgumentException.class)
    public void truncateShouldNotAllowNegativeLength() {
        StringUtil.truncate((Object)"some string", (int)-1);
    }

    @Test
    public void truncateShouldReturnEmptyStringForMaximumLengthOfZero() {
        String str = "This is the string with some text";
        Assert.assertThat((Object)StringUtil.truncate((Object)str, (int)0), (Matcher)Is.is((Object)""));
        Assert.assertThat((Object)StringUtil.truncate((Object)"", (int)0), (Matcher)Is.is((Object)""));
        Assert.assertThat((Object)StringUtil.truncate((Object)str, (int)0, (String)"123"), (Matcher)Is.is((Object)""));
        Assert.assertThat((Object)StringUtil.truncate((Object)"", (int)0, (String)"123"), (Matcher)Is.is((Object)""));
    }

    @Test
    public void truncateShouldNotTruncateStringShorterThanMaximumLength() {
        String str = "This is the string with some text";
        Assert.assertThat((Object)StringUtil.truncate((Object)str, (int)(str.length() + 2)), (Matcher)Is.is((Object)str));
        Assert.assertThat((Object)StringUtil.truncate((Object)str, (int)(str.length() + 2), null), (Matcher)Is.is((Object)str));
        Assert.assertThat((Object)StringUtil.truncate((Object)str, (int)(str.length() + 2), (String)"really long suffix"), (Matcher)Is.is((Object)str));
    }

    @Test
    public void truncateShouldNotTruncateStringWithLengthEqualToMaximumLength() {
        String str = "This is the string with some text";
        Assert.assertThat((Object)StringUtil.truncate((Object)str, (int)str.length()), (Matcher)Is.is((Object)str));
        Assert.assertThat((Object)StringUtil.truncate((Object)str, (int)str.length(), null), (Matcher)Is.is((Object)str));
        Assert.assertThat((Object)StringUtil.truncate((Object)str, (int)str.length(), (String)"really long suffix"), (Matcher)Is.is((Object)str));
    }

    @Test
    public void truncateShouldProperlyTruncateStringWithLengthGreaterThanMaximumLength() {
        String str = "This is the string";
        Assert.assertThat((Object)StringUtil.truncate((Object)str, (int)(str.length() - 1)), (Matcher)Is.is((Object)"This is the st..."));
        Assert.assertThat((Object)StringUtil.truncate((Object)str, (int)(str.length() - 1), null), (Matcher)Is.is((Object)"This is the st..."));
        Assert.assertThat((Object)StringUtil.truncate((Object)str, (int)(str.length() - 1), (String)"X"), (Matcher)Is.is((Object)"This is the striX"));
    }

    @Test
    public void truncateShouldProperlyTruncateStringWithLengthGreaterThanMaximumLengthAndMaximumLengthLongerThanPrefixLength() {
        String str = "This is the string";
        Assert.assertThat((Object)StringUtil.truncate((Object)str, (int)2), (Matcher)Is.is((Object)".."));
        Assert.assertThat((Object)StringUtil.truncate((Object)str, (int)2, null), (Matcher)Is.is((Object)".."));
        Assert.assertThat((Object)StringUtil.truncate((Object)str, (int)1, (String)"XX"), (Matcher)Is.is((Object)"X"));
    }

    @Test
    public void readShouldReturnEmptyStringForNullInputStream() throws Exception {
        Assert.assertThat((Object)StringUtil.read((InputStream)null), (Matcher)Is.is((Object)""));
    }

    @Test
    public void readShouldReturnEmptyStringForNullReader() throws Exception {
        Assert.assertThat((Object)StringUtil.read((Reader)null), (Matcher)Is.is((Object)""));
    }

    @Test
    public void readShouldReadInputStreamCorrectlyAndShouldCloseStream() throws Exception {
        String content = "This is the way to grandma's house.";
        ByteArrayInputStream stream = new ByteArrayInputStream(content.getBytes());
        InputStreamWrapper wrapper = new InputStreamWrapper(stream);
        Assert.assertThat((Object)wrapper.isClosed(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)StringUtil.read((InputStream)wrapper), (Matcher)Is.is((Object)content));
        Assert.assertThat((Object)wrapper.isClosed(), (Matcher)Is.is((Object)true));
        for (int i = 0; i != 10; ++i) {
            content = content + content;
        }
        stream = new ByteArrayInputStream(content.getBytes());
        wrapper = new InputStreamWrapper(stream);
        Assert.assertThat((Object)wrapper.isClosed(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)StringUtil.read((InputStream)wrapper), (Matcher)Is.is((Object)content));
        Assert.assertThat((Object)wrapper.isClosed(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void readShouldReadReaderCorrectlyAndShouldCloseStream() throws Exception {
        String content = "This is the way to grandma's house.";
        StringReader reader = new StringReader(content);
        ReaderWrapper wrapper = new ReaderWrapper(reader);
        Assert.assertThat((Object)wrapper.isClosed(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)StringUtil.read((Reader)wrapper), (Matcher)Is.is((Object)content));
        Assert.assertThat((Object)wrapper.isClosed(), (Matcher)Is.is((Object)true));
        for (int i = 0; i != 10; ++i) {
            content = content + content;
        }
        reader = new StringReader(content);
        wrapper = new ReaderWrapper(reader);
        Assert.assertThat((Object)wrapper.isClosed(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)StringUtil.read((Reader)wrapper), (Matcher)Is.is((Object)content));
        Assert.assertThat((Object)wrapper.isClosed(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void getStackTraceShouldReturnStackTrace() {
        String msg = "This is the message for a test exception";
        IllegalArgumentException t = new IllegalArgumentException(msg);
        String trace = StringUtil.getStackTrace((Throwable)t);
        Assert.assertThat((Object)trace, (Matcher)CoreMatchers.containsString((String)msg));
        Assert.assertThat((Object)trace, (Matcher)CoreMatchers.containsString((String)this.getClass().getName()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void normalizeShouldFailIfTextNull() {
        StringUtil.normalize(null);
    }

    @Test
    public void normalizeShouldRemoveLeadingTrailingWhitespace() {
        Assert.assertThat((Object)StringUtil.normalize((String)" \t\n test this \t"), (Matcher)Is.is((Object)"test this"));
    }

    @Test
    public void normalizeShouldReduceInternalWhitespace() {
        Assert.assertThat((Object)StringUtil.normalize((String)"test \t\n\r this"), (Matcher)Is.is((Object)"test this"));
    }

    @Test
    public void normalizeShouldReturnEqualStringIfNothingToNormalize() {
        Assert.assertThat((Object)StringUtil.normalize((String)"test this"), (Matcher)Is.is((Object)"test this"));
    }

    protected class ReaderWrapper
    extends Reader {
        private boolean closed = false;
        private final Reader reader;

        protected ReaderWrapper(Reader reader) {
            this.reader = reader;
        }

        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
            this.closed = true;
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            return this.reader.read(cbuf, off, len);
        }
    }

    protected class InputStreamWrapper
    extends InputStream {
        private boolean closed = false;
        private final InputStream stream;

        protected InputStreamWrapper(InputStream stream) {
            this.stream = stream;
        }

        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public int read() throws IOException {
            return this.stream.read();
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
            this.closed = true;
        }
    }
}

