/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.math;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.common.math.IntegerOperations;

public class IntegerOperationsTest {
    private IntegerOperations ops = new IntegerOperations();

    @Test
    public void shouldReturnProperExponenentInScientificNotation() {
        Assert.assertEquals((long)0L, (long)this.ops.getExponentInScientificNotation(Integer.valueOf(0)));
        Assert.assertEquals((long)0L, (long)this.ops.getExponentInScientificNotation(Integer.valueOf(1)));
        Assert.assertEquals((long)0L, (long)this.ops.getExponentInScientificNotation(Integer.valueOf(2)));
        Assert.assertEquals((long)0L, (long)this.ops.getExponentInScientificNotation(Integer.valueOf(9)));
        Assert.assertEquals((long)1L, (long)this.ops.getExponentInScientificNotation(Integer.valueOf(10)));
        Assert.assertEquals((long)1L, (long)this.ops.getExponentInScientificNotation(Integer.valueOf(20)));
        Assert.assertEquals((long)1L, (long)this.ops.getExponentInScientificNotation(Integer.valueOf(99)));
        Assert.assertEquals((long)2L, (long)this.ops.getExponentInScientificNotation(Integer.valueOf(100)));
        Assert.assertEquals((long)2L, (long)this.ops.getExponentInScientificNotation(Integer.valueOf(200)));
        Assert.assertEquals((long)2L, (long)this.ops.getExponentInScientificNotation(Integer.valueOf(999)));
        Assert.assertEquals((long)3L, (long)this.ops.getExponentInScientificNotation(Integer.valueOf(1000)));
        Assert.assertEquals((long)3L, (long)this.ops.getExponentInScientificNotation(Integer.valueOf(2000)));
        Assert.assertEquals((long)3L, (long)this.ops.getExponentInScientificNotation(Integer.valueOf(9999)));
    }

    @Test
    public void shouldRoundNumbersGreaterThan10() {
        Assert.assertThat((Object)this.ops.roundUp(Integer.valueOf(-101), 0), (Matcher)Is.is((Object)-101));
        Assert.assertThat((Object)this.ops.roundUp(Integer.valueOf(-101), 1), (Matcher)Is.is((Object)-101));
        Assert.assertThat((Object)this.ops.roundUp(Integer.valueOf(-101), 1), (Matcher)Is.is((Object)-101));
        Assert.assertThat((Object)this.ops.roundUp(Integer.valueOf(-101), -1), (Matcher)Is.is((Object)-100));
        Assert.assertThat((Object)this.ops.roundUp(Integer.valueOf(-109), -1), (Matcher)Is.is((Object)-110));
        Assert.assertThat((Object)this.ops.roundUp(Integer.valueOf(101), 0), (Matcher)Is.is((Object)101));
        Assert.assertThat((Object)this.ops.roundUp(Integer.valueOf(101), 0), (Matcher)Is.is((Object)101));
        Assert.assertThat((Object)this.ops.roundUp(Integer.valueOf(101), 1), (Matcher)Is.is((Object)101));
        Assert.assertThat((Object)this.ops.roundUp(Integer.valueOf(101), 1), (Matcher)Is.is((Object)101));
        Assert.assertThat((Object)this.ops.roundUp(Integer.valueOf(109), -1), (Matcher)Is.is((Object)110));
        Assert.assertThat((Object)this.ops.roundUp(Integer.valueOf(101), -1), (Matcher)Is.is((Object)100));
    }

    @Test
    public void shouldKeepSignificantFigures() {
        Assert.assertThat((Object)this.ops.keepSignificantFigures(Integer.valueOf(0), 2), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.ops.keepSignificantFigures(Integer.valueOf(1201234), 5), (Matcher)Is.is((Object)1201200));
        Assert.assertThat((Object)this.ops.keepSignificantFigures(Integer.valueOf(1201254), 5), (Matcher)Is.is((Object)1201300));
        Assert.assertThat((Object)this.ops.keepSignificantFigures(Integer.valueOf(1201234), 4), (Matcher)Is.is((Object)1201000));
        Assert.assertThat((Object)this.ops.keepSignificantFigures(Integer.valueOf(1201234), 3), (Matcher)Is.is((Object)1200000));
        Assert.assertThat((Object)this.ops.keepSignificantFigures(Integer.valueOf(1201234), 2), (Matcher)Is.is((Object)1200000));
        Assert.assertThat((Object)this.ops.keepSignificantFigures(Integer.valueOf(1201234), 1), (Matcher)Is.is((Object)1000000));
        Assert.assertThat((Object)this.ops.keepSignificantFigures(Integer.valueOf(-1320), 2), (Matcher)Is.is((Object)-1300));
    }
}

