/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.util;

import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.util.StringURLClassLoader;

public class StringURLClassLoaderTest {
    private static final String RESOURCE_PATH = StringURLClassLoaderTest.class.getPackage().getName().replaceAll("\\.", "/") + "/additionalmime.types";
    private static final URL RESOURCE_URL = StringURLClassLoaderTest.class.getClassLoader().getResource(RESOURCE_PATH);

    @Before
    public void setUp() throws Exception {
        Assert.assertNotNull((Object)RESOURCE_URL);
    }

    @Test
    public void shouldNotResolveURLsIfEmptyListProvided() throws Exception {
        StringURLClassLoader classLoader = new StringURLClassLoader(Collections.emptyList());
        Assert.assertNull((Object)classLoader.getResource(RESOURCE_PATH));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowNullArgument() throws Exception {
        new StringURLClassLoader(null);
    }

    @Test
    public void shouldResolveResourceIfURLProvided() throws Exception {
        String folderUrl = RESOURCE_URL.toString().substring(0, RESOURCE_URL.toString().indexOf(RESOURCE_PATH));
        StringURLClassLoader classLoader = new StringURLClassLoader(Arrays.asList("invalidURL", folderUrl));
        Assert.assertNotNull((Object)classLoader.getResource(RESOURCE_PATH));
    }
}

