/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.modeshape.common.annotation.NotThreadSafe;

@NotThreadSafe
public final class MultiIterator<E>
implements Iterator<E> {
    private final Iterator<Iterator<E>> iterators;
    private Iterator<E> current;

    public static <E> MultiIterator<E> fromIterators(Iterable<Iterator<E>> iterators) {
        return new MultiIterator<E>(iterators);
    }

    public static <E> MultiIterator<E> fromIterables(Iterable<? extends Iterable<E>> iterables) {
        final Iterator<? extends Iterable<E>> iterator = iterables.iterator();
        Iterable iterators = new Iterable<Iterator<E>>(){

            @Override
            public Iterator<Iterator<E>> iterator() {
                return new Iterator<Iterator<E>>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public Iterator<E> next() {
                        return ((Iterable)iterator.next()).iterator();
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }
                };
            }
        };
        return new MultiIterator<E>(iterators);
    }

    protected MultiIterator(Iterable<Iterator<E>> iterators) {
        this.iterators = iterators.iterator();
    }

    @Override
    public boolean hasNext() {
        if (this.nextIterator()) {
            return this.current.hasNext();
        }
        return false;
    }

    @Override
    public E next() {
        if (this.nextIterator()) {
            return this.current.next();
        }
        throw new NoSuchElementException();
    }

    protected boolean nextIterator() {
        while (this.current == null || !this.current.hasNext()) {
            if (!this.iterators.hasNext()) {
                return false;
            }
            this.current = this.iterators.next();
        }
        return true;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

