/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.collection;

import java.util.Iterator;

public class SequentialIterator<T>
implements Iterator<T> {
    private final Iterator<T> first;
    private final Iterator<T> second;
    private boolean completedFirst = false;

    public static <T> SequentialIterator<T> create(Iterator<T> first, Iterator<T> second) {
        return new SequentialIterator<T>(first, second);
    }

    public SequentialIterator(Iterator<T> first, Iterator<T> second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public boolean hasNext() {
        if (!this.completedFirst) {
            if (this.first.hasNext()) {
                return true;
            }
            this.completedFirst = true;
        }
        return this.second.hasNext();
    }

    @Override
    public T next() {
        if (!this.completedFirst) {
            if (this.first.hasNext()) {
                return this.first.next();
            }
            this.completedFirst = true;
        }
        return this.second.next();
    }

    @Override
    public void remove() {
        if (!this.completedFirst) {
            this.first.remove();
        }
        this.second.remove();
    }
}

