/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.statistic;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.i18n.MockI18n;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.math.FloatOperations;
import org.modeshape.common.math.MathOperations;
import org.modeshape.common.statistic.Histogram;
import org.modeshape.common.text.Inflector;

public class HistogramTest {
    private Logger logger = Logger.getLogger(HistogramTest.class);
    private Inflector inflector = Inflector.getInstance();

    public static <T extends Number> Histogram<T> createRandomHistogram(T minimum, T maximum, int numberOfValues, MathOperations<T> ops) {
        ArrayList<Number> values = new ArrayList<Number>();
        Random rng = new Random();
        for (int i = 0; i != numberOfValues; ++i) {
            Number newValue = (Number)ops.random(minimum, maximum, rng);
            values.add(newValue);
        }
        return new Histogram(ops, values);
    }

    public static <T extends Number> void writeHistogramToLog(Logger logger, Histogram<T> histogram, int barLength, String description) {
        logger.info((I18nResource)MockI18n.passthrough, new Object[]{description != null ? description : "Histogram:"});
        List barGraph = histogram.getTextGraph(barLength);
        for (String line : barGraph) {
            logger.debug("  " + line, new Object[0]);
        }
    }

    public <T extends Number> void assertBucketValueCount(Histogram<T> histogram, long ... values) {
        List buckets = histogram.getBuckets();
        Assert.assertEquals((String)"The number of buckets didn't match expected number", (long)values.length, (long)buckets.size());
        for (int i = 0; i != buckets.size(); ++i) {
            Assert.assertEquals((String)("The " + this.inflector.ordinalize(i + 1) + " bucket didn't have the expected number of values"), (long)values[i], (long)((Histogram.Bucket)buckets.get(i)).getNumberOfValues());
        }
    }

    @Test
    public void shouldCorrectlyPlaceAnOddNumberOfFloatValuesIntoSameOddNumberOfBuckets() {
        Number[] values = new Float[]{Float.valueOf(3.0f), Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(4.0f)};
        Histogram gram = new Histogram((MathOperations)new FloatOperations(), values);
        gram.setBucketCount(3);
        this.assertBucketValueCount(gram, 1L, 1L, 2L);
    }

    @Test
    public void shouldCorrectlyPlaceAnEvenNumberOfFloatValuesIntoSameEvenNumberOfBuckets() {
        Number[] values = new Float[]{Float.valueOf(3.0f), Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(4.0f)};
        Histogram gram = new Histogram((MathOperations)new FloatOperations(), values);
        gram.setBucketCount(4);
        this.assertBucketValueCount(gram, 1L, 1L, 1L, 1L);
    }

    @Test
    public void shouldCorrectlyPlaceAnOddNumberOfFloatValuesIntoSmallerNumberOfBuckets() {
        Number[] values = new Float[]{Float.valueOf(3.0f), Float.valueOf(1.0f), Float.valueOf(2.0f)};
        Histogram gram = new Histogram((MathOperations)new FloatOperations(), values);
        gram.setBucketCount(2);
        this.assertBucketValueCount(gram, 1L, 2L);
    }

    @Test
    public void shouldCorrectlyPlaceAnEvenNumberOfFloatValuesIntoSmallerNumberOfBuckets() {
        Number[] values = new Float[]{Float.valueOf(3.0f), Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(4.0f)};
        Histogram gram = new Histogram((MathOperations)new FloatOperations(), values);
        gram.setBucketCount(2);
        this.assertBucketValueCount(gram, 2L, 2L);
    }

    @Test
    public void shouldReturnListOfBuckets() {
        Number[] values = new Float[]{Float.valueOf(3.0f), Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(4.0f)};
        Histogram gram = new Histogram((MathOperations)new FloatOperations(), values);
        Assert.assertTrue((boolean)(gram.getBuckets() instanceof LinkedList));
    }

    @Test
    public void shouldCorrectlyPlaceAnOddNumberOfFloatValuesIntoSmallerNumberOfBucketsWithMinimumAndMaximumRanges() {
        Number[] values = new Float[]{Float.valueOf(3.0f), Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(4.0f), Float.valueOf(5.0f), Float.valueOf(6.0f), Float.valueOf(7.0f), Float.valueOf(8.0f), Float.valueOf(9.0f), Float.valueOf(10.0f)};
        Histogram gram = new Histogram((MathOperations)new FloatOperations(), values);
        gram.setBucketCount(5);
        this.assertBucketValueCount(gram, 2L, 2L, 2L, 2L, 2L);
    }

    @Test
    public void shouldCorrectlyPlaceAnOddNumberOfFloatValuesIntoSmallerNumberOfBucketsWithMinimumRanges() {
        Number[] values = new Float[]{Float.valueOf(3.0f), Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(4.0f), Float.valueOf(5.0f), Float.valueOf(6.0f), Float.valueOf(7.0f), Float.valueOf(8.0f), Float.valueOf(9.0f), Float.valueOf(9.999f)};
        Histogram gram = new Histogram((MathOperations)new FloatOperations(), values);
        gram.setBucketCount(5);
        this.assertBucketValueCount(gram, 2L, 2L, 2L, 2L, 2L);
    }

    @Test
    public void shouldCorrectlyConstructHistogramWithStandardDeviation() {
        Number[] values = new Float[]{Float.valueOf(3.0f), Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(4.0f), Float.valueOf(5.0f), Float.valueOf(6.0f), Float.valueOf(7.0f), Float.valueOf(8.0f), Float.valueOf(9.0f), Float.valueOf(9.999f), Float.valueOf(3.1f), Float.valueOf(3.2f), Float.valueOf(3.3f), Float.valueOf(3.21f), Float.valueOf(3.22f), Float.valueOf(3.33f)};
        Histogram gram = new Histogram((MathOperations)new FloatOperations(), values);
        gram.setBucketCount(6);
        gram.setStrategy((double)3.315f, (double)2.52367f, 1);
        HistogramTest.writeHistogramToLog(this.logger, gram, 0, "shouldCorrectlyConstructHistogramWithStandardDeviation");
        this.assertBucketValueCount(gram, 1L, 1L, 7L, 1L, 1L, 5L);
    }

    @Test
    public void shouldCorrectlyPlace1000RandomFloatValues() {
        Histogram<Float> gram = HistogramTest.createRandomHistogram(Float.valueOf(10.0f), Float.valueOf(100.0f), 1000, new FloatOperations());
        HistogramTest.writeHistogramToLog(this.logger, gram, 0, "Histogram of 1000 random float values in " + gram.getBucketCount() + " buckets: ");
    }

    @Test
    public void shouldCorrectlyConstructBoundariesWithWindowSmallerThanActualFloats() {
        List boundaries = Histogram.getBucketBoundaries((MathOperations)new FloatOperations(), (Object)Float.valueOf(10.0f), (Object)Float.valueOf(20.0f), (Object)Float.valueOf(5.0f), (Object)Float.valueOf(25.0f), (int)12, (int)3);
        Assert.assertNotNull((Object)boundaries);
        Assert.assertEquals((long)13L, (long)boundaries.size());
        Object[] expectedBoundaries = new Float[]{Float.valueOf(5.0f), Float.valueOf(10.0f), Float.valueOf(11.0f), Float.valueOf(12.0f), Float.valueOf(13.0f), Float.valueOf(14.0f), Float.valueOf(15.0f), Float.valueOf(16.0f), Float.valueOf(17.0f), Float.valueOf(18.0f), Float.valueOf(19.0f), Float.valueOf(20.0f), Float.valueOf(25.0f)};
        Assert.assertArrayEquals((Object[])expectedBoundaries, (Object[])boundaries.toArray(new Float[boundaries.size()]));
    }

    @Test
    public void shouldCorrectlyConstructBoundariesWithWindowSmallerThanActualNarrowlyVaryingFloats() {
        List boundaries = Histogram.getBucketBoundaries((MathOperations)new FloatOperations(), (Object)Float.valueOf(10.0002f), (Object)Float.valueOf(10.0003f), (Object)Float.valueOf(10.00011f), (Object)Float.valueOf(10.0005f), (int)12, (int)3);
        Assert.assertNotNull((Object)boundaries);
        Assert.assertEquals((long)13L, (long)boundaries.size());
        Assert.assertEquals((float)10.00011f, (float)((Float)boundaries.get(0)).floatValue(), (float)1.0E-5f);
        Assert.assertEquals((float)10.0002f, (float)((Float)boundaries.get(1)).floatValue(), (float)1.0E-5f);
        Assert.assertEquals((float)10.00021f, (float)((Float)boundaries.get(2)).floatValue(), (float)1.0E-5f);
        Assert.assertEquals((float)10.00022f, (float)((Float)boundaries.get(3)).floatValue(), (float)1.0E-5f);
        Assert.assertEquals((float)10.00023f, (float)((Float)boundaries.get(4)).floatValue(), (float)1.0E-5f);
        Assert.assertEquals((float)10.00024f, (float)((Float)boundaries.get(5)).floatValue(), (float)1.0E-5f);
        Assert.assertEquals((float)10.00025f, (float)((Float)boundaries.get(6)).floatValue(), (float)1.0E-5f);
        Assert.assertEquals((float)10.00026f, (float)((Float)boundaries.get(7)).floatValue(), (float)1.0E-5f);
        Assert.assertEquals((float)10.00027f, (float)((Float)boundaries.get(8)).floatValue(), (float)1.0E-5f);
        Assert.assertEquals((float)10.00028f, (float)((Float)boundaries.get(9)).floatValue(), (float)1.0E-5f);
        Assert.assertEquals((float)10.00029f, (float)((Float)boundaries.get(10)).floatValue(), (float)1.0E-5f);
        Assert.assertEquals((float)10.0003f, (float)((Float)boundaries.get(11)).floatValue(), (float)1.0E-5f);
        Assert.assertEquals((float)10.0005f, (float)((Float)boundaries.get(12)).floatValue(), (float)1.0E-5f);
    }
}

