/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.collection;

import java.util.ArrayList;
import java.util.Iterator;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.AllOf;
import org.hamcrest.core.IsEqual;

public class IsIteratorContaining<T>
extends TypeSafeMatcher<Iterator<T>> {
    private final Matcher<? extends T> elementMatcher;

    public IsIteratorContaining(Matcher<? extends T> elementMatcher) {
        this.elementMatcher = elementMatcher;
    }

    public boolean matchesSafely(Iterator<T> iterator) {
        while (iterator.hasNext()) {
            T item = iterator.next();
            if (!this.elementMatcher.matches(item)) continue;
            return true;
        }
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("a iterator containing ").appendDescriptionOf(this.elementMatcher);
    }

    @Factory
    public static <T> Matcher<Iterator<T>> hasItem(Matcher<? extends T> elementMatcher) {
        return new IsIteratorContaining<T>(elementMatcher);
    }

    @Factory
    public static <T> Matcher<Iterator<T>> hasItem(T element) {
        return IsIteratorContaining.hasItem(IsEqual.equalTo(element));
    }

    @Factory
    @SafeVarargs
    public static <T> Matcher<Iterator<T>> hasItems(Matcher<? extends T> ... elementMatchers) {
        ArrayList<Matcher<Iterator<Matcher<? extends T>>>> all = new ArrayList<Matcher<Iterator<Matcher<? extends T>>>>(elementMatchers.length);
        for (Matcher<? extends T> elementMatcher : elementMatchers) {
            all.add(IsIteratorContaining.hasItem(elementMatcher));
        }
        return AllOf.allOf(all);
    }

    @Factory
    @SafeVarargs
    public static <T> Matcher<Iterator<T>> hasItems(T ... elements) {
        ArrayList<Matcher<Iterator<T>>> all = new ArrayList<Matcher<Iterator<T>>>(elements.length);
        for (T element : elements) {
            all.add(IsIteratorContaining.hasItem(element));
        }
        return AllOf.allOf(all);
    }
}

