/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.naming;

import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import junit.framework.AssertionFailedError;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsSame;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.naming.SingletonInitialContext;
import org.modeshape.common.naming.SingletonInitialContextFactory;

public class SingletonInitialContextTest {
    private String validName;
    private Object registeredObject;

    @Before
    public void beforeEach() {
        this.validName = "java:jboss/unit/test/name";
        this.registeredObject = "This is the registered object";
    }

    @After
    public void afterEach() {
        SingletonInitialContextFactory.tearDown();
    }

    @Test
    public void shouldCreateInitialContextAndRegisterAnObject() throws Exception {
        SingletonInitialContext.register((String)this.validName, (Object)this.registeredObject);
        for (int i = 0; i != 10; ++i) {
            Assert.assertThat((Object)new InitialContext().lookup(this.validName), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.registeredObject)));
        }
    }

    @Test
    public void shouldTearDownMockInitialContextUponRequest() throws Exception {
        SingletonInitialContext.register((String)this.validName, (Object)this.registeredObject);
        for (int i = 0; i != 10; ++i) {
            Assert.assertThat((Object)new InitialContext().lookup(this.validName), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.registeredObject)));
        }
        SingletonInitialContextFactory.tearDown();
        try {
            new InitialContext().lookup(this.validName);
            throw new AssertionFailedError("Failed to throw exception");
        }
        catch (NameNotFoundException nameNotFoundException) {
            return;
        }
    }
}

