/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.disk;

import java.io.File;
import java.util.Set;
import java.util.UUID;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.text.FilenameEncoder;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.connector.disk.DiskConnectorI18n;
import org.modeshape.connector.disk.DiskNode;
import org.modeshape.connector.disk.DiskRepository;
import org.modeshape.connector.disk.DiskWorkspace;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.connector.base.MapTransaction;
import org.modeshape.graph.connector.base.Repository;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.request.InvalidWorkspaceException;

@NotThreadSafe
public class DiskTransaction
extends MapTransaction<DiskNode, DiskWorkspace> {
    private static final TextEncoder FILE_ENCODER = new FilenameEncoder();
    private final DiskRepository repository;
    private final DiskRepository.DiskLock lock;

    protected DiskTransaction(ExecutionContext context, DiskRepository repository, UUID rootNodeUuid, DiskRepository.DiskLock lock) {
        super(context, (Repository)repository, rootNodeUuid);
        this.repository = repository;
        this.lock = lock;
    }

    public Set<String> getWorkspaceNames() {
        return this.repository.getWorkspaceNames();
    }

    public DiskWorkspace getWorkspace(String name, DiskWorkspace originalToClone) {
        File workspaceRoot = this.workspaceRootFor(name);
        if (!workspaceRoot.exists() && !workspaceRoot.mkdir()) {
            String msg = DiskConnectorI18n.unableToCreateWorkspace.text(new Object[]{name, this.repository.getSourceName()});
            throw new InvalidWorkspaceException(msg);
        }
        if (originalToClone != null) {
            return new DiskWorkspace(name, workspaceRoot, originalToClone);
        }
        return new DiskWorkspace(name, workspaceRoot, new DiskNode(this.repository.getRootNodeUuid()), this.repository);
    }

    public boolean destroyWorkspace(DiskWorkspace workspace) {
        if (!this.getRepository().destroyWorkspace(workspace.getName())) {
            return false;
        }
        workspace.destroy();
        return true;
    }

    File workspaceRootFor(String workspaceName) {
        String encodedName = FILE_ENCODER.encode(workspaceName);
        File repositoryRoot = this.repository.getRepositoryRoot();
        return new File(repositoryRoot, encodedName);
    }

    protected DiskNode createNode(UUID uuid, Path.Segment name, UUID parentUuid, Iterable<Property> properties) {
        return new DiskNode(uuid, name, parentUuid, properties, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        try {
            super.commit();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        try {
            super.rollback();
        }
        finally {
            this.lock.unlock();
        }
    }
}

