/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.disk;

import java.io.File;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.util.FileUtil;
import org.modeshape.connector.disk.DiskSource;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.connector.MockRepositoryContext;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.RepositorySource;

public class DiskConnectorDiscoverWorkspacesTest {
    private final int LARGE_VALUE_THRESHOLD = 20;
    private final String REPO_ROOT_PATH = "./target/repoRootPath";
    protected ExecutionContext context;

    @Before
    public void beforeEach() {
        File repoRootPath = new File("./target/repoRootPath");
        if (repoRootPath.exists()) {
            FileUtil.delete((File)repoRootPath);
        }
        repoRootPath.mkdirs();
        this.context = new ExecutionContext();
    }

    private Graph graphForNewSource() throws Exception {
        DiskSource source = new DiskSource();
        source.setName("Disk Source");
        source.setLargeValueSizeInBytes(20L);
        source.setRepositoryRootPath("./target/repoRootPath");
        source.initialize((RepositoryContext)new MockRepositoryContext(this.context));
        return Graph.create((RepositorySource)source, (ExecutionContext)this.context);
    }

    @Test
    public void shouldDiscoverExistingWorkspaces() throws Exception {
        Graph graph = this.graphForNewSource();
        Set originalWorkspaces = graph.getWorkspaces();
        graph.createWorkspace().named("newWorkspace1");
        graph.createWorkspace().named("newWorkspace2");
        Graph newGraph = this.graphForNewSource();
        Set newWorkspaces = newGraph.getWorkspaces();
        Assert.assertThat((Object)newWorkspaces.size(), (Matcher)CoreMatchers.is((Object)(originalWorkspaces.size() + 2)));
        Assert.assertTrue((boolean)newWorkspaces.containsAll(originalWorkspaces));
        Assert.assertTrue((boolean)newWorkspaces.contains("newWorkspace1"));
        Assert.assertTrue((boolean)newWorkspaces.contains("newWorkspace2"));
    }
}

