/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.filesystem;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.common.util.FileUtil;
import org.modeshape.connector.filesystem.FileSystemSource;
import org.modeshape.graph.Graph;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.JcrMixLexicon;
import org.modeshape.graph.JcrNtLexicon;
import org.modeshape.graph.ModeShapeLexicon;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.test.AbstractConnectorTest;
import org.modeshape.graph.request.InvalidRequestException;

public class FileSystemConnectorWritableTest
extends AbstractConnectorTest {
    public static final String ARBITRARY_PROPERTIES_NOT_SUPPORTED = "This connector does not support setting arbitrary properties";
    private static final String REPO_PATH = "./target/repositories/";
    private static final String REPO_SOURCE_PATH = "./src/test/resources/repositories/";
    private final String TEST_CONTENT = "Test content";
    protected File testWorkspaceRoot;
    protected File otherWorkspaceRoot;
    protected File newWorkspaceRoot;
    protected File scratchDirectory;

    protected RepositorySource setUpSource() throws Exception {
        File sourceRepo = new File(REPO_SOURCE_PATH);
        this.scratchDirectory = new File(REPO_PATH);
        this.scratchDirectory.mkdirs();
        FileUtil.delete((File)this.scratchDirectory);
        FileUtil.copy((File)sourceRepo, (File)this.scratchDirectory);
        String[] predefinedWorkspaceNames = new String[]{"test", "otherWorkspace", "airplanes", "cars"};
        FileSystemSource source = new FileSystemSource();
        source.setName("Test Repository");
        source.setWorkspaceRootPath(REPO_PATH);
        source.setPredefinedWorkspaceNames(predefinedWorkspaceNames);
        source.setDefaultWorkspaceName(predefinedWorkspaceNames[0]);
        source.setCreatingWorkspacesAllowed(true);
        source.setUpdatesAllowed(true);
        this.testWorkspaceRoot = new File(REPO_PATH, "test");
        this.testWorkspaceRoot.mkdir();
        this.otherWorkspaceRoot = new File(REPO_PATH, "otherWorkspace");
        this.otherWorkspaceRoot.mkdir();
        this.newWorkspaceRoot = new File(REPO_PATH, "newWorkspace");
        this.newWorkspaceRoot.mkdir();
        return source;
    }

    protected void initializeContent(Graph graph) {
    }

    public void afterEach() throws Exception {
        FileUtil.delete((File)this.scratchDirectory);
        super.afterEach();
    }

    @Test
    public void shouldBeAbleToCreateFileWithContent() {
        this.graph.create("/testFile").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FILE}).orReplace().and();
        this.graph.create("/testFile/jcr:content").with(JcrLexicon.PRIMARY_TYPE, new Object[]{ModeShapeLexicon.RESOURCE}).and(JcrLexicon.DATA, new Object[]{"Test content".getBytes()}).orReplace().and();
        File newFile = new File(this.testWorkspaceRoot, "testFile");
        this.assertContents(newFile, "Test content");
    }

    @Test
    public void shouldRespectConflictBehaviorOnCreate() {
        this.graph.create("/testFile").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FILE}).orReplace().and();
        this.graph.create("/testFile/jcr:content").with(JcrLexicon.PRIMARY_TYPE, new Object[]{ModeShapeLexicon.RESOURCE}).and(JcrLexicon.DATA, new Object[]{"Test content".getBytes()}).orReplace().and();
        this.graph.create("/testFile/jcr:content").with(JcrLexicon.PRIMARY_TYPE, new Object[]{ModeShapeLexicon.RESOURCE}).and(JcrLexicon.DATA, new Object[]{"Should not overwrite".getBytes()}).ifAbsent().and();
        File newFile = new File(this.testWorkspaceRoot, "testFile");
        this.assertContents(newFile, "Test content");
    }

    @Test
    public void shouldBeAbleToCreateFileWithNoContent() {
        this.graph.create("/testEmptyFile").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FILE}).orReplace().and();
        File newFile = new File(this.testWorkspaceRoot, "testEmptyFile");
        Assert.assertThat((Object)newFile.exists(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)newFile.isFile(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldBeAbleToCreateFolder() {
        this.graph.create("/testFolder").orReplace().and();
        File newFile = new File(this.testWorkspaceRoot, "testFolder");
        Assert.assertThat((Object)newFile.exists(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)newFile.isDirectory(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldBeAbleToAddChildrenToFolder() throws Exception {
        this.graph.create("/testFolder").orReplace().and();
        File newFolder = new File(this.testWorkspaceRoot, "testFolder");
        Assert.assertThat((Object)newFolder.exists(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)newFolder.isDirectory(), (Matcher)Is.is((Object)true));
        this.graph.create("/testFolder/testFile").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FILE}).orReplace().and();
        this.graph.create("/testFolder/testFile/jcr:content").with(JcrLexicon.PRIMARY_TYPE, new Object[]{ModeShapeLexicon.RESOURCE}).and(JcrLexicon.DATA, new Object[]{"Test content".getBytes()}).orReplace().and();
        File newFile = new File(this.testWorkspaceRoot, "testFolder/testFile");
        this.assertContents(newFile, "Test content");
    }

    @Test(expected=RepositorySourceException.class)
    public void shouldNotBeAbleToCreateInvalidTypeForRepository() {
        this.graph.create("/testFile").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.UNSTRUCTURED}).orReplace().and();
    }

    @Test(expected=RepositorySourceException.class)
    public void shouldNotBeAbleToSetArbitraryProperties() {
        this.graph.create("/testFile").with(JcrLexicon.MIXIN_TYPES, new Object[]{JcrMixLexicon.LOCKABLE}).orReplace().and();
    }

    @Test
    public void shouldBeAbleToCopyFile() {
        this.graph.create("/testFile").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FILE}).orReplace().and();
        this.graph.create("/testFile/jcr:content").with(JcrLexicon.PRIMARY_TYPE, new Object[]{ModeShapeLexicon.RESOURCE}).and(JcrLexicon.DATA, new Object[]{"Test content".getBytes()}).orReplace().and();
        File newFile = new File(this.testWorkspaceRoot, "testFile");
        this.assertContents(newFile, "Test content");
        this.graph.copy("/testFile").to("/copiedFile");
        File copiedFile = new File(this.testWorkspaceRoot, "copiedFile");
        this.assertContents(copiedFile, "Test content");
    }

    @Test
    public void shouldBeAbleToCopyFolder() {
        this.graph.create("/testFolder").orReplace().and();
        this.graph.create("/testFolder/testFile").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FILE}).orReplace().and();
        this.graph.create("/testFolder/testFile/jcr:content").with(JcrLexicon.PRIMARY_TYPE, new Object[]{ModeShapeLexicon.RESOURCE}).and(JcrLexicon.DATA, new Object[]{"Test content".getBytes()}).orReplace().and();
        File newFile = new File(this.testWorkspaceRoot, "testFolder/testFile");
        this.assertContents(newFile, "Test content");
        this.graph.copy("/testFolder").to("/copiedFolder");
        File copiedFolder = new File(this.testWorkspaceRoot, "copiedFolder");
        Assert.assertTrue((boolean)copiedFolder.exists());
        Assert.assertTrue((boolean)copiedFolder.isDirectory());
        File copiedFile = new File(this.testWorkspaceRoot, "copiedFolder/testFile");
        this.assertContents(copiedFile, "Test content");
    }

    @Test
    public void shouldBeAbleToMoveFile() {
        this.graph.create("/testFile").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FILE}).orReplace().and();
        this.graph.create("/testFile/jcr:content").with(JcrLexicon.PRIMARY_TYPE, new Object[]{ModeShapeLexicon.RESOURCE}).and(JcrLexicon.DATA, new Object[]{"Test content".getBytes()}).orReplace().and();
        File newFile = new File(this.testWorkspaceRoot, "testFile");
        this.assertContents(newFile, "Test content");
        this.graph.create("/newFolder").orReplace().and();
        this.graph.move("/testFile").into("/newFolder");
        Assert.assertThat((Object)newFile.exists(), (Matcher)Is.is((Object)false));
        File copiedFile = new File(this.testWorkspaceRoot, "newFolder/testFile");
        this.assertContents(copiedFile, "Test content");
    }

    @Test
    public void shouldBeAbleToMoveFolder() {
        this.graph.create("/testFolder").orReplace().and();
        this.graph.create("/testFolder/testFile").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FILE}).orReplace().and();
        this.graph.create("/testFolder/testFile/jcr:content").with(JcrLexicon.PRIMARY_TYPE, new Object[]{ModeShapeLexicon.RESOURCE}).and(JcrLexicon.DATA, new Object[]{"Test content".getBytes()}).orReplace().and();
        File newFile = new File(this.testWorkspaceRoot, "testFolder/testFile");
        this.assertContents(newFile, "Test content");
        this.graph.create("/newFolder").orReplace().and();
        this.graph.move("/testFolder").into("/newFolder");
        Assert.assertThat((Object)newFile.exists(), (Matcher)Is.is((Object)false));
        File copiedFolder = new File(this.testWorkspaceRoot, "newFolder/testFolder");
        Assert.assertTrue((boolean)copiedFolder.exists());
        Assert.assertTrue((boolean)copiedFolder.isDirectory());
        File copiedFile = new File(this.testWorkspaceRoot, "newFolder/testFolder/testFile");
        this.assertContents(copiedFile, "Test content");
    }

    @Test
    public void shouldBeAbleToDeleteFolderWithContents() {
        this.graph.create("/testFolder").orReplace().and();
        this.graph.create("/testFolder/testFile").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FILE}).orReplace().and();
        this.graph.create("/testFolder/testFile/jcr:content").with(JcrLexicon.PRIMARY_TYPE, new Object[]{ModeShapeLexicon.RESOURCE}).and(JcrLexicon.DATA, new Object[]{"Test content".getBytes()}).orReplace().and();
        File newFolder = new File(this.testWorkspaceRoot, "testFolder");
        Assert.assertTrue((boolean)newFolder.exists());
        Assert.assertTrue((boolean)newFolder.isDirectory());
        File newFile = new File(this.testWorkspaceRoot, "testFolder/testFile");
        this.assertContents(newFile, "Test content");
        this.graph.delete("/testFolder");
        Assert.assertThat((Object)newFolder.exists(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldBeAbleToDeleteFile() {
        this.graph.create("/testFolder").orReplace().and();
        this.graph.create("/testFolder/testFile").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FILE}).orReplace().and();
        this.graph.create("/testFolder/testFile/jcr:content").with(JcrLexicon.PRIMARY_TYPE, new Object[]{ModeShapeLexicon.RESOURCE}).and(JcrLexicon.DATA, new Object[]{"Test content".getBytes()}).orReplace().and();
        File newFolder = new File(this.testWorkspaceRoot, "testFolder");
        Assert.assertTrue((boolean)newFolder.exists());
        Assert.assertTrue((boolean)newFolder.isDirectory());
        File newFile = new File(this.testWorkspaceRoot, "testFolder/testFile");
        this.assertContents(newFile, "Test content");
        this.graph.delete("/testFolder/testFile");
        Assert.assertTrue((boolean)newFolder.exists());
        Assert.assertThat((Object)newFile.exists(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldBeAbleToCloneFolder() {
        this.graph.useWorkspace("otherWorkspace");
        this.graph.create("/testFolder").orReplace().and();
        this.graph.create("/testFolder/testFile").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FILE}).orReplace().and();
        this.graph.create("/testFolder/testFile/jcr:content").with(JcrLexicon.PRIMARY_TYPE, new Object[]{ModeShapeLexicon.RESOURCE}).and(JcrLexicon.DATA, new Object[]{"Test content".getBytes()}).orReplace().and();
        File newFile = new File(this.otherWorkspaceRoot, "testFolder/testFile");
        this.assertContents(newFile, "Test content");
        this.graph.useWorkspace("test");
        ((Graph.WithUuids)((Graph.Into)((Graph.AsChild)this.graph.clone("/testFolder").fromWorkspace("otherWorkspace")).as("clonedFolder")).into("/")).failingIfAnyUuidsMatch();
        File copiedFolder = new File(this.testWorkspaceRoot, "clonedFolder");
        Assert.assertTrue((boolean)copiedFolder.exists());
        Assert.assertTrue((boolean)copiedFolder.isDirectory());
        File copiedFile = new File(this.testWorkspaceRoot, "clonedFolder/testFile");
        this.assertContents(copiedFile, "Test content");
    }

    @Test
    public void shouldBeAbleToCloneFile() {
        this.graph.useWorkspace("otherWorkspace");
        this.graph.create("/testFile").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FILE}).orReplace().and();
        this.graph.create("/testFile/jcr:content").with(JcrLexicon.PRIMARY_TYPE, new Object[]{ModeShapeLexicon.RESOURCE}).and(JcrLexicon.DATA, new Object[]{"Test content".getBytes()}).orReplace().and();
        File newFile = new File(this.otherWorkspaceRoot, "testFile");
        this.assertContents(newFile, "Test content");
        this.graph.useWorkspace("test");
        ((Graph.WithUuids)((Graph.Into)((Graph.AsChild)this.graph.clone("/testFile").fromWorkspace("otherWorkspace")).as("clonedFile")).into("/")).failingIfAnyUuidsMatch();
        File copiedFile = new File(this.testWorkspaceRoot, "clonedFile");
        this.assertContents(copiedFile, "Test content");
    }

    @Test(expected=InvalidRequestException.class)
    public void shouldNotBeAbleToReorderFolder() {
        this.graph.create("/testFolder").orReplace().and();
        this.graph.create("/testFolder2").orReplace().and();
        File newFolder = new File(this.testWorkspaceRoot, "testFolder");
        Assert.assertTrue((boolean)newFolder.exists());
        Assert.assertTrue((boolean)newFolder.isDirectory());
        File newFolder2 = new File(this.testWorkspaceRoot, "testFolder2");
        Assert.assertTrue((boolean)newFolder2.exists());
        Assert.assertTrue((boolean)newFolder2.isDirectory());
        this.graph.move("/testFolder2").before("/testFolder");
    }

    @Test(expected=InvalidRequestException.class)
    public void shouldNotBeAbleToReorderFile() {
        this.graph.create("/testFolder").orReplace().and();
        this.graph.create("/testFolder/testFile").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FILE}).orReplace().and();
        this.graph.create("/testFolder/testFile/jcr:content").with(JcrLexicon.PRIMARY_TYPE, new Object[]{ModeShapeLexicon.RESOURCE}).and(JcrLexicon.DATA, new Object[]{"Test content".getBytes()}).orReplace().and();
        this.graph.create("/testFolder/testFile2").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FILE}).orReplace().and();
        this.graph.create("/testFolder/testFile2/jcr:content").with(JcrLexicon.PRIMARY_TYPE, new Object[]{ModeShapeLexicon.RESOURCE}).and(JcrLexicon.DATA, new Object[]{"Test content".getBytes()}).orReplace().and();
        File newFolder = new File(this.testWorkspaceRoot, "testFolder");
        Assert.assertTrue((boolean)newFolder.exists());
        Assert.assertTrue((boolean)newFolder.isDirectory());
        File newFile = new File(this.testWorkspaceRoot, "testFolder/testFile");
        this.assertContents(newFile, "Test content");
        File newFile2 = new File(this.testWorkspaceRoot, "testFolder/testFile2");
        this.assertContents(newFile2, "Test content");
        this.graph.move("/testFolder/testFile2").before("/testFolder/testFile");
    }

    @Test
    public void shouldBeAbleToRenameFolder() {
        this.graph.create("/testFolder").orReplace().and();
        this.graph.create("/testFolder/testFile").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FILE}).orReplace().and();
        this.graph.create("/testFolder/testFile/jcr:content").with(JcrLexicon.PRIMARY_TYPE, new Object[]{ModeShapeLexicon.RESOURCE}).and(JcrLexicon.DATA, new Object[]{"Test content".getBytes()}).orReplace().and();
        File newFile = new File(this.testWorkspaceRoot, "testFolder/testFile");
        this.assertContents(newFile, "Test content");
        ((Graph.Into)this.graph.move("/testFolder").as("newFolder")).into("/");
        Assert.assertThat((Object)newFile.exists(), (Matcher)Is.is((Object)false));
        File copiedFolder = new File(this.testWorkspaceRoot, "newFolder");
        Assert.assertTrue((boolean)copiedFolder.exists());
        Assert.assertTrue((boolean)copiedFolder.isDirectory());
        File copiedFile = new File(this.testWorkspaceRoot, "newFolder/testFile");
        this.assertContents(copiedFile, "Test content");
    }

    @Test
    public void shouldBeAbleToRenameFile() {
        this.graph.create("/testFile").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FILE}).orReplace().and();
        this.graph.create("/testFile/jcr:content").with(JcrLexicon.PRIMARY_TYPE, new Object[]{ModeShapeLexicon.RESOURCE}).and(JcrLexicon.DATA, new Object[]{"Test content".getBytes()}).orReplace().and();
        File newFile = new File(this.testWorkspaceRoot, "testFile");
        this.assertContents(newFile, "Test content");
        ((Graph.Into)this.graph.move("/testFile").as("copiedFile")).into("/");
        Assert.assertThat((Object)newFile.exists(), (Matcher)Is.is((Object)false));
        File copiedFile = new File(this.testWorkspaceRoot, "copiedFile");
        this.assertContents(copiedFile, "Test content");
    }

    @Test
    public void shouldBeAbleToCreateWorkspace() {
        this.graph.createWorkspace().named("newWorkspace");
        this.graph.useWorkspace("newWorkspace");
        this.graph.create("/testFile").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FILE}).orReplace().and();
        this.graph.create("/testFile/jcr:content").with(JcrLexicon.PRIMARY_TYPE, new Object[]{ModeShapeLexicon.RESOURCE}).and(JcrLexicon.DATA, new Object[]{"Test content".getBytes()}).orReplace().and();
        File newFile = new File(this.newWorkspaceRoot, "testFile");
        this.assertContents(newFile, "Test content");
    }

    @Test
    public void shouldBeAbleToCloneWorkspace() {
        this.graph.create("/testFile").with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FILE}).orReplace().and();
        this.graph.create("/testFile/jcr:content").with(JcrLexicon.PRIMARY_TYPE, new Object[]{ModeShapeLexicon.RESOURCE}).and(JcrLexicon.DATA, new Object[]{"Test content".getBytes()}).orReplace().and();
        File newFile = new File(this.testWorkspaceRoot, "testFile");
        this.assertContents(newFile, "Test content");
        this.graph.createWorkspace().clonedFrom("test").named("newWorkspace");
        newFile = new File(this.newWorkspaceRoot, "testFile");
        this.assertContents(newFile, "Test content");
    }

    @Test
    public void shouldBeAbleToCreateDeepPath() {
        String pathName = "";
        for (int i = 0; i < 20; ++i) {
            pathName = pathName + "/test";
            this.graph.create(pathName).orReplace().and();
        }
    }

    @Test(expected=RepositorySourceException.class)
    public void shouldNotBeAbleToCreateTooDeepPath() {
        String pathName = "";
        for (int i = 0; i < 100; ++i) {
            pathName = pathName + "/testFolder";
            this.graph.create(pathName).orReplace().and();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertContents(File file, String contents) {
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((boolean)file.isFile());
        StringBuilder buff = new StringBuilder();
        int BUFF_SIZE = 8192;
        byte[] bytes = new byte[8192];
        FileInputStream fis = null;
        try {
            int len;
            fis = new FileInputStream(file);
            while (-1 != (len = fis.read(bytes, 0, 8192))) {
                buff.append(new String(bytes, 0, len));
            }
            Assert.assertThat((Object)buff.toString(), (Matcher)Is.is((Object)contents));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            Assert.fail((String)ioe.getMessage());
            return;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception ignore) {
                }
                finally {
                    fis = null;
                }
            }
        }
    }
}

