/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.filesystem;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.naming.BinaryRefAddr;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import net.jcip.annotations.ThreadSafe;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;
import org.modeshape.connector.filesystem.CustomPropertiesFactory;
import org.modeshape.connector.filesystem.FileSystemI18n;
import org.modeshape.connector.filesystem.FileSystemRepository;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.Location;
import org.modeshape.graph.ModeShapeIntLexicon;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositorySourceCapabilities;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.path.AbstractPathRepositorySource;
import org.modeshape.graph.connector.path.PathRepository;
import org.modeshape.graph.connector.path.PathRepositoryConnection;
import org.modeshape.graph.connector.path.PathRepositorySource;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class FileSystemSource
extends AbstractPathRepositorySource
implements ObjectFactory {
    protected static CustomPropertiesFactory DEFAULT_PROPERTIES_FACTORY = new StandardPropertiesFactory();
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_NAME_OF_DEFAULT_WORKSPACE = "default";
    protected static final String SOURCE_NAME = "sourceName";
    protected static final String DEFAULT_WORKSPACE = "defaultWorkspace";
    protected static final String WORKSPACE_ROOT = "workspaceRootPath";
    protected static final String PREDEFINED_WORKSPACE_NAMES = "predefinedWorkspaceNames";
    protected static final String ALLOW_CREATING_WORKSPACES = "allowCreatingWorkspaces";
    protected static final String MAX_PATH_LENGTH = "maxPathLength";
    protected static final String EXCLUSION_PATTERN = "exclusionPattern";
    protected static final String CUSTOM_PROPERTY_FACTORY = "customPropertyFactory";
    protected static final boolean SUPPORTS_EVENTS = true;
    protected static final boolean SUPPORTS_SAME_NAME_SIBLINGS = true;
    protected static final boolean DEFAULT_SUPPORTS_CREATING_WORKSPACES = true;
    public static final boolean DEFAULT_SUPPORTS_UPDATES = false;
    protected static final boolean SUPPORTS_REFERENCES = false;
    public static final int DEFAULT_MAX_PATH_LENGTH = 255;
    public static final String DEFAULT_EXCLUSION_PATTERN = null;
    private volatile String defaultWorkspaceName = "default";
    private volatile String workspaceRootPath;
    private volatile String[] predefinedWorkspaces = new String[0];
    private volatile int maxPathLength = 255;
    private volatile String exclusionPattern = DEFAULT_EXCLUSION_PATTERN;
    private volatile RepositorySourceCapabilities capabilities = new RepositorySourceCapabilities(true, false, true, true, false);
    private transient FileSystemRepository repository;
    private volatile CustomPropertiesFactory customPropertiesFactory;

    public RepositorySourceCapabilities getCapabilities() {
        return this.capabilities;
    }

    public boolean getUpdatesAllowed() {
        return this.capabilities.supportsUpdates();
    }

    public String getWorkspaceRootPath() {
        return this.workspaceRootPath;
    }

    public synchronized void setWorkspaceRootPath(String workspaceRootPath) {
        this.workspaceRootPath = workspaceRootPath;
    }

    public String getExclusionPattern() {
        return this.exclusionPattern;
    }

    public synchronized void setExclusionPattern(String exclusionPattern) {
        this.exclusionPattern = exclusionPattern;
    }

    FilenameFilter filenameFilter() {
        FilenameFilter filenameFilter = null;
        final String filterPattern = this.exclusionPattern;
        if (filterPattern != null) {
            filenameFilter = new FilenameFilter(){
                Pattern filter;
                {
                    this.filter = Pattern.compile(filterPattern);
                }

                public boolean accept(File dir, String name) {
                    return !this.filter.matcher(name).matches();
                }
            };
        }
        return filenameFilter;
    }

    public int getMaxPathLength() {
        return this.maxPathLength;
    }

    public synchronized void setMaxPathLength(int maxPathLength) {
        CheckArg.isNonNegative((int)maxPathLength, (String)MAX_PATH_LENGTH);
        this.maxPathLength = maxPathLength;
    }

    public String getDefaultWorkspaceName() {
        return this.defaultWorkspaceName;
    }

    public synchronized void setDefaultWorkspaceName(String nameOfDefaultWorkspace) {
        this.defaultWorkspaceName = nameOfDefaultWorkspace != null ? nameOfDefaultWorkspace : DEFAULT_NAME_OF_DEFAULT_WORKSPACE;
    }

    public synchronized String[] getPredefinedWorkspaceNames() {
        String[] copy = new String[this.predefinedWorkspaces.length];
        System.arraycopy(this.predefinedWorkspaces, 0, copy, 0, this.predefinedWorkspaces.length);
        return copy;
    }

    public synchronized void setPredefinedWorkspaceNames(String[] predefinedWorkspaceNames) {
        this.predefinedWorkspaces = predefinedWorkspaceNames;
    }

    public boolean isCreatingWorkspacesAllowed() {
        return this.capabilities.supportsCreatingWorkspaces();
    }

    public synchronized void setCreatingWorkspacesAllowed(boolean allowWorkspaceCreation) {
        this.capabilities = new RepositorySourceCapabilities(this.capabilities.supportsSameNameSiblings(), this.capabilities.supportsUpdates(), this.capabilities.supportsEvents(), allowWorkspaceCreation, this.capabilities.supportsReferences());
    }

    public boolean areUpdatesAllowed() {
        return this.capabilities.supportsUpdates();
    }

    public synchronized void setUpdatesAllowed(boolean allowUpdates) {
        this.capabilities = new RepositorySourceCapabilities(this.capabilities.supportsSameNameSiblings(), allowUpdates, this.capabilities.supportsEvents(), this.capabilities.supportsCreatingWorkspaces(), this.capabilities.supportsReferences());
    }

    public synchronized CustomPropertiesFactory getCustomPropertiesFactory() {
        return this.customPropertiesFactory;
    }

    CustomPropertiesFactory customPropertiesFactory() {
        return this.customPropertiesFactory != null ? this.customPropertiesFactory : DEFAULT_PROPERTIES_FACTORY;
    }

    public synchronized void setCustomPropertiesFactory(CustomPropertiesFactory customPropertiesFactory) {
        this.customPropertiesFactory = customPropertiesFactory;
    }

    public synchronized Reference getReference() {
        String className = this.getClass().getName();
        String factoryClassName = this.getClass().getName();
        Reference ref = new Reference(className, factoryClassName, null);
        if (this.getName() != null) {
            ref.add(new StringRefAddr(SOURCE_NAME, this.getName()));
        }
        ref.add(new StringRefAddr(DEFAULT_WORKSPACE, this.getDefaultWorkspaceName()));
        ref.add(new StringRefAddr(ALLOW_CREATING_WORKSPACES, Boolean.toString(this.isCreatingWorkspacesAllowed())));
        ref.add(new StringRefAddr(EXCLUSION_PATTERN, this.exclusionPattern));
        ref.add(new StringRefAddr(MAX_PATH_LENGTH, String.valueOf(this.maxPathLength)));
        String[] workspaceNames = this.getPredefinedWorkspaceNames();
        if (workspaceNames != null && workspaceNames.length != 0) {
            ref.add(new StringRefAddr(PREDEFINED_WORKSPACE_NAMES, StringUtil.combineLines((String[])workspaceNames)));
        }
        if (this.getCustomPropertiesFactory() != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            CustomPropertiesFactory factory = this.getCustomPropertiesFactory();
            try {
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(factory);
                ref.add(new BinaryRefAddr(CUSTOM_PROPERTY_FACTORY, baos.toByteArray()));
            }
            catch (IOException e) {
                I18n msg = FileSystemI18n.errorSerializingCustomPropertiesFactory;
                throw new RepositorySourceException(this.getName(), msg.text(new Object[]{factory.getClass().getName(), this.getName()}), (Throwable)e);
            }
        }
        return ref;
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (obj instanceof Reference) {
            Map values = this.valuesFrom((Reference)obj);
            String sourceName = (String)values.get(SOURCE_NAME);
            String defaultWorkspace = (String)values.get(DEFAULT_WORKSPACE);
            String createWorkspaces = (String)values.get(ALLOW_CREATING_WORKSPACES);
            String exclusionPattern = (String)values.get(EXCLUSION_PATTERN);
            String maxPathLength = (String)values.get(255);
            Object customPropertiesFactory = values.get(CUSTOM_PROPERTY_FACTORY);
            String combinedWorkspaceNames = (String)values.get(PREDEFINED_WORKSPACE_NAMES);
            String[] workspaceNames = null;
            if (combinedWorkspaceNames != null) {
                List paths = StringUtil.splitLines((String)combinedWorkspaceNames);
                workspaceNames = paths.toArray(new String[paths.size()]);
            }
            FileSystemSource source = new FileSystemSource();
            if (sourceName != null) {
                source.setName(sourceName);
            }
            if (defaultWorkspace != null) {
                source.setDefaultWorkspaceName(defaultWorkspace);
            }
            if (createWorkspaces != null) {
                source.setCreatingWorkspacesAllowed(Boolean.parseBoolean(createWorkspaces));
            }
            if (workspaceNames != null && workspaceNames.length != 0) {
                source.setPredefinedWorkspaceNames(workspaceNames);
            }
            if (exclusionPattern != null) {
                source.setExclusionPattern(exclusionPattern);
            }
            if (maxPathLength != null) {
                source.setMaxPathLength(Integer.valueOf(maxPathLength));
            }
            if (customPropertiesFactory != null) {
                source.setCustomPropertiesFactory((CustomPropertiesFactory)customPropertiesFactory);
            }
            return source;
        }
        return null;
    }

    public synchronized RepositoryConnection getConnection() throws RepositorySourceException {
        String sourceName = this.getName();
        if (sourceName == null || sourceName.trim().length() == 0) {
            I18n msg = FileSystemI18n.propertyIsRequired;
            throw new RepositorySourceException(this.getName(), msg.text(new Object[]{"name"}));
        }
        if (this.repository == null) {
            this.repository = new FileSystemRepository(this);
        }
        return new PathRepositoryConnection((PathRepositorySource)this, (PathRepository)this.repository);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class StandardPropertiesFactory
    implements CustomPropertiesFactory {
        private static final long serialVersionUID = 1L;
        private final Collection<Property> empty = Collections.emptyList();
        private final Set<org.modeshape.graph.property.Name> ALLOWABLE_PROPERTIES_FOR_CONTENT = Collections.unmodifiableSet(new HashSet<org.modeshape.graph.property.Name>(Arrays.asList(JcrLexicon.PRIMARY_TYPE, JcrLexicon.DATA, JcrLexicon.ENCODED, JcrLexicon.MIMETYPE, JcrLexicon.LAST_MODIFIED, JcrLexicon.UUID, ModeShapeIntLexicon.NODE_DEFINITON)));
        private final Set<org.modeshape.graph.property.Name> ALLOWABLE_PROPERTIES_FOR_FILE_OR_FOLDER = Collections.unmodifiableSet(new HashSet<org.modeshape.graph.property.Name>(Arrays.asList(JcrLexicon.PRIMARY_TYPE, JcrLexicon.CREATED, JcrLexicon.UUID, ModeShapeIntLexicon.NODE_DEFINITON)));

        protected StandardPropertiesFactory() {
        }

        @Override
        public Collection<Property> getDirectoryProperties(ExecutionContext context, Location location, File directory) {
            return this.empty;
        }

        @Override
        public Collection<Property> getFileProperties(ExecutionContext context, Location location, File file) {
            return this.empty;
        }

        @Override
        public Collection<Property> getResourceProperties(ExecutionContext context, Location location, File file, String mimeType) {
            return this.empty;
        }

        @Override
        public Set<org.modeshape.graph.property.Name> recordDirectoryProperties(ExecutionContext context, String sourceName, Location location, File file, Map<org.modeshape.graph.property.Name, Property> properties) throws RepositorySourceException {
            this.ensureValidProperties(context, sourceName, properties.values(), this.ALLOWABLE_PROPERTIES_FOR_FILE_OR_FOLDER);
            return null;
        }

        @Override
        public Set<org.modeshape.graph.property.Name> recordFileProperties(ExecutionContext context, String sourceName, Location location, File file, Map<org.modeshape.graph.property.Name, Property> properties) throws RepositorySourceException {
            this.ensureValidProperties(context, sourceName, properties.values(), this.ALLOWABLE_PROPERTIES_FOR_FILE_OR_FOLDER);
            return null;
        }

        @Override
        public Set<org.modeshape.graph.property.Name> recordResourceProperties(ExecutionContext context, String sourceName, Location location, File file, Map<org.modeshape.graph.property.Name, Property> properties) throws RepositorySourceException {
            this.ensureValidProperties(context, sourceName, properties.values(), this.ALLOWABLE_PROPERTIES_FOR_CONTENT);
            return null;
        }

        protected void ensureValidProperties(ExecutionContext context, String sourceName, Collection<Property> properties, Set<org.modeshape.graph.property.Name> validPropertyNames) {
            LinkedList<String> invalidNames = new LinkedList<String>();
            NamespaceRegistry registry = context.getNamespaceRegistry();
            for (Property property : properties) {
                if (validPropertyNames.contains(property.getName())) continue;
                invalidNames.add(property.getName().getString(registry));
            }
            if (!invalidNames.isEmpty()) {
                throw new RepositorySourceException(sourceName, FileSystemI18n.invalidPropertyNames.text(new Object[]{((Object)invalidNames).toString()}));
            }
        }
    }
}

