/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.filesystem;

import java.util.HashSet;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.connector.filesystem.FileSystemSource;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Workspace;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.test.WorkspaceConnectorTest;

public class FileSystemConnectorCreateWorkspacesTest
extends WorkspaceConnectorTest {
    private String pathToRepositories;

    protected RepositorySource setUpSource() throws Exception {
        this.pathToRepositories = "./src/test/resources/repositories/";
        String[] predefinedWorkspaceNames = new String[]{this.pathToRepositories + "airplanes", this.pathToRepositories + "cars"};
        FileSystemSource source = new FileSystemSource();
        source.setName("Test Repository");
        source.setPredefinedWorkspaceNames(predefinedWorkspaceNames);
        source.setDefaultWorkspaceName(predefinedWorkspaceNames[0]);
        source.setCreatingWorkspacesAllowed(true);
        source.setUpdatesAllowed(true);
        source.setExclusionPattern("\\.svn");
        return source;
    }

    protected void initializeContent(Graph graph) throws Exception {
    }

    protected String[] generateInvalidNamesForNewWorkspaces() {
        return null;
    }

    protected String[] generateValidNamesForNewWorkspaces() {
        return new String[]{this.pathToRepositories + "trains"};
    }

    @Test
    public void shouldReturnListOfWorkspacesMatchingAbsoluteCanonicalPathsToDirectories() {
        HashSet<String> workspaceNames = new HashSet<String>();
        for (String workspaceName : this.graph.getWorkspaces()) {
            Workspace workspace = this.graph.useWorkspace(workspaceName);
            workspaceNames.add(workspace.getName());
        }
        String absolutePathToRepositories = "./src/test/resources/repositories/";
        Assert.assertThat((Object)workspaceNames.remove(absolutePathToRepositories + "airplanes"), Is.is(true));
        Assert.assertThat((Object)workspaceNames.remove(absolutePathToRepositories + "cars"), Is.is(true));
        Assert.assertThat((Object)workspaceNames.isEmpty(), Is.is(true));
        workspaceNames = new HashSet(this.graph.getWorkspaces());
        Assert.assertThat((Object)workspaceNames.remove(absolutePathToRepositories + "airplanes"), Is.is(true));
        Assert.assertThat((Object)workspaceNames.remove(absolutePathToRepositories + "cars"), Is.is(true));
        Assert.assertThat((Object)workspaceNames.isEmpty(), Is.is(true));
    }
}

