/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.filesystem;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.util.FileUtil;
import org.modeshape.common.util.IoUtil;
import org.modeshape.connector.filesystem.CustomPropertiesFactory;
import org.modeshape.connector.filesystem.FileSystemI18n;
import org.modeshape.connector.filesystem.FileSystemRepository;
import org.modeshape.connector.filesystem.FileSystemSource;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.JcrNtLexicon;
import org.modeshape.graph.Location;
import org.modeshape.graph.ModeShapeLexicon;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.base.PathNode;
import org.modeshape.graph.connector.base.PathWorkspace;
import org.modeshape.graph.mimetype.MimeTypeDetector;
import org.modeshape.graph.property.Binary;
import org.modeshape.graph.property.BinaryFactory;
import org.modeshape.graph.property.DateTimeFactory;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyFactory;

class FileSystemWorkspace
extends PathWorkspace<PathNode> {
    private static final String DEFAULT_MIME_TYPE = "application/octet";
    private static final Set<Name> VALID_PRIMARY_TYPES = new HashSet<Name>(Arrays.asList(JcrNtLexicon.FOLDER, JcrNtLexicon.FILE, JcrNtLexicon.RESOURCE, ModeShapeLexicon.RESOURCE));
    private final FileSystemSource source;
    private final FileSystemRepository repository;
    private final ExecutionContext context;
    private final File workspaceRoot;

    public FileSystemWorkspace(String name, FileSystemWorkspace originalToClone, File workspaceRoot) {
        super(name, originalToClone.getRootNodeUuid());
        this.source = originalToClone.source;
        this.context = originalToClone.context;
        this.workspaceRoot = workspaceRoot;
        this.repository = originalToClone.repository;
        this.cloneWorkspace(originalToClone);
    }

    public FileSystemWorkspace(FileSystemRepository repository, String name) {
        super(name, repository.getRootNodeUuid());
        this.workspaceRoot = repository.getWorkspaceDirectory(name);
        this.repository = repository;
        this.context = repository.getContext();
        this.source = repository.source;
    }

    private void cloneWorkspace(FileSystemWorkspace original) {
        File originalRoot = this.repository.getWorkspaceDirectory(original.getName());
        File newRoot = this.repository.getWorkspaceDirectory(this.getName());
        try {
            FileUtil.copy((File)originalRoot, (File)newRoot, (FilenameFilter)this.source.filenameFilter());
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
    }

    public PathNode moveNode(PathNode node, PathNode newNode) {
        PathFactory pathFactory = this.context.getValueFactories().getPathFactory();
        Path newPath = pathFactory.create(newNode.getParent(), new Path.Segment[]{newNode.getName()});
        File originalFile = this.fileFor(pathFactory.create(node.getParent(), new Path.Segment[]{node.getName()}));
        File newFile = this.fileFor(newPath, false);
        if (newFile.exists()) {
            newFile.delete();
        }
        originalFile.renameTo(newFile);
        return this.getNode(newPath);
    }

    public PathNode putNode(PathNode node) {
        Name primaryType;
        NameFactory nameFactory = this.context.getValueFactories().getNameFactory();
        PathFactory pathFactory = this.context.getValueFactories().getPathFactory();
        NamespaceRegistry registry = this.context.getNamespaceRegistry();
        CustomPropertiesFactory customPropertiesFactory = this.source.customPropertiesFactory();
        Map properties = node.getProperties();
        if (node.getParent() == null) {
            Path rootPath = pathFactory.createRootPath();
            Location rootLocation = Location.create((Path)rootPath, (UUID)this.repository.getRootNodeUuid());
            customPropertiesFactory.recordDirectoryProperties(this.context, this.source.getName(), rootLocation, this.workspaceRoot, node.getProperties());
            return this.getNode(rootPath);
        }
        Path parentPath = node.getParent();
        boolean isRoot = parentPath == null;
        File parentFile = this.fileFor(parentPath);
        Path newPath = isRoot ? pathFactory.createRootPath() : pathFactory.create(parentPath, new Path.Segment[]{node.getName()});
        Name name = node.getName().getName();
        String newName = name.getString(registry);
        File newFile = new File(parentFile, newName);
        Property primaryTypeProp = (Property)properties.get(JcrLexicon.PRIMARY_TYPE);
        Name name2 = primaryType = primaryTypeProp == null ? JcrNtLexicon.FOLDER : (Name)nameFactory.create(primaryTypeProp.getFirstValue());
        if (JcrNtLexicon.FILE.equals(primaryType)) {
            if (!parentFile.canWrite()) {
                I18n msg = FileSystemI18n.parentIsReadOnly;
                throw new RepositorySourceException(this.source.getName(), msg.text(new Object[]{parentPath, this.getName(), this.source.getName()}));
            }
            try {
                this.ensureValidPathLength(newFile);
                if (!newFile.exists() && !newFile.createNewFile()) {
                    I18n msg = FileSystemI18n.fileAlreadyExists;
                    throw new RepositorySourceException(this.source.getName(), msg.text(new Object[]{parentPath, this.getName(), this.source.getName()}));
                }
            }
            catch (IOException ioe) {
                I18n msg = FileSystemI18n.couldNotCreateFile;
                throw new RepositorySourceException(this.source.getName(), msg.text(new Object[]{parentPath, this.getName(), this.source.getName(), ioe.getMessage()}), (Throwable)ioe);
            }
            customPropertiesFactory.recordFileProperties(this.context, this.source.getName(), Location.create((Path)newPath), newFile, properties);
        } else if (JcrNtLexicon.RESOURCE.equals(primaryType) || ModeShapeLexicon.RESOURCE.equals(primaryType)) {
            assert (parentFile != null);
            if (!JcrLexicon.CONTENT.equals(name)) {
                I18n msg = FileSystemI18n.invalidNameForResource;
                String nodeName = name.getString();
                throw new RepositorySourceException(this.source.getName(), msg.text(new Object[]{parentPath, this.getName(), this.source.getName(), nodeName}));
            }
            if (!parentFile.isFile()) {
                I18n msg = FileSystemI18n.invalidPathForResource;
                throw new RepositorySourceException(this.source.getName(), msg.text(new Object[]{parentPath, this.getName(), this.source.getName()}));
            }
            if (!parentFile.canWrite()) {
                I18n msg = FileSystemI18n.parentIsReadOnly;
                throw new RepositorySourceException(this.source.getName(), msg.text(new Object[]{parentPath, this.getName(), this.source.getName()}));
            }
            FileOutputStream fos = null;
            try {
                File temp = File.createTempFile("dna", null);
                fos = new FileOutputStream(temp);
                Property dataProp = (Property)properties.get(JcrLexicon.DATA);
                if (dataProp == null) {
                    I18n msg = FileSystemI18n.missingRequiredProperty;
                    String dataPropName = JcrLexicon.DATA.getString();
                    throw new RepositorySourceException(this.source.getName(), msg.text(new Object[]{parentPath, this.getName(), this.source.getName(), dataPropName}));
                }
                BinaryFactory binaryFactory = this.context.getValueFactories().getBinaryFactory();
                Binary binary = (Binary)binaryFactory.create(((Property)properties.get(JcrLexicon.DATA)).getFirstValue());
                IoUtil.write((InputStream)binary.getStream(), (OutputStream)fos);
                if (!FileUtil.delete((File)parentFile)) {
                    I18n msg = FileSystemI18n.deleteFailed;
                    throw new RepositorySourceException(this.source.getName(), msg.text(new Object[]{parentPath, this.getName(), this.source.getName()}));
                }
                if (!temp.renameTo(parentFile)) {
                    I18n msg = FileSystemI18n.couldNotUpdateData;
                    throw new RepositorySourceException(this.source.getName(), msg.text(new Object[]{parentPath, this.getName(), this.source.getName()}));
                }
            }
            catch (IOException ioe) {
                I18n msg = FileSystemI18n.couldNotWriteData;
                throw new RepositorySourceException(this.source.getName(), msg.text(new Object[]{parentPath, this.getName(), this.source.getName(), ioe.getMessage()}), (Throwable)ioe);
            }
            finally {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (Exception ex) {}
            }
            customPropertiesFactory.recordResourceProperties(this.context, this.source.getName(), Location.create((Path)parentPath), newFile, properties);
        } else if (JcrNtLexicon.FOLDER.equals(primaryType) || primaryType == null) {
            this.ensureValidPathLength(newFile);
            if (!newFile.exists() && !newFile.mkdir()) {
                I18n msg = FileSystemI18n.couldNotCreateFile;
                throw new RepositorySourceException(this.source.getName(), msg.text(new Object[]{parentPath, this.getName(), this.source.getName(), primaryType == null ? "null" : primaryType.getString(registry)}));
            }
            customPropertiesFactory.recordDirectoryProperties(this.context, this.source.getName(), Location.create((Path)newPath), newFile, properties);
        } else {
            I18n msg = FileSystemI18n.unsupportedPrimaryType;
            throw new RepositorySourceException(this.source.getName(), msg.text(new Object[]{primaryType.getString(registry), parentPath, this.getName(), this.source.getName()}));
        }
        node = this.getNode(newPath);
        return node;
    }

    public PathNode removeNode(Path nodePath) {
        if (!nodePath.isRoot() && JcrLexicon.CONTENT.equals(nodePath.getLastSegment().getName())) {
            File nodeFile = this.fileFor(nodePath.getParent());
            if (!nodeFile.exists()) {
                return null;
            }
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(nodeFile);
                IoUtil.write((String)"", (OutputStream)fos);
            }
            catch (IOException ioe) {
                throw new RepositorySourceException(this.source.getName(), FileSystemI18n.deleteFailed.text(new Object[]{nodePath, this.getName(), this.source.getName()}));
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        File nodeFile = this.fileFor(nodePath);
        if (!nodeFile.exists()) {
            return null;
        }
        FileUtil.delete((File)nodeFile);
        return null;
    }

    public PathNode getRootNode() {
        return this.getNode(this.context.getValueFactories().getPathFactory().createRootPath());
    }

    public PathNode getNode(Path path) {
        HashMap<Name, Property> properties = new HashMap<Name, Property>();
        PropertyFactory factory = this.context.getPropertyFactory();
        PathFactory pathFactory = this.context.getValueFactories().getPathFactory();
        DateTimeFactory dateFactory = this.context.getValueFactories().getDateFactory();
        MimeTypeDetector mimeTypeDetector = this.context.getMimeTypeDetector();
        CustomPropertiesFactory customPropertiesFactory = this.source.customPropertiesFactory();
        NamespaceRegistry registry = this.context.getNamespaceRegistry();
        Location location = Location.create((Path)path);
        if (!path.isRoot() && JcrLexicon.CONTENT.equals(path.getLastSegment().getName())) {
            File file = this.fileFor(path.getParent());
            if (file == null) {
                return null;
            }
            String mimeType = null;
            InputStream contents = null;
            try {
                contents = new BufferedInputStream(new FileInputStream(file));
                mimeType = mimeTypeDetector.mimeTypeOf(file.getName(), contents);
                if (mimeType == null) {
                    mimeType = DEFAULT_MIME_TYPE;
                }
                properties.put(JcrLexicon.MIMETYPE, factory.create(JcrLexicon.MIMETYPE, new Object[]{mimeType}));
            }
            catch (IOException e) {
                I18n msg = FileSystemI18n.couldNotReadData;
                throw new RepositorySourceException(this.source.getName(), msg.text(new Object[]{this.source.getName(), this.getName(), path.getString(registry)}));
            }
            finally {
                if (contents != null) {
                    try {
                        contents.close();
                    }
                    catch (IOException e) {}
                }
            }
            Collection<Property> customProps = customPropertiesFactory.getResourceProperties(this.context, location, file, mimeType);
            for (Property customProp : customProps) {
                properties.put(customProp.getName(), customProp);
            }
            properties.put(JcrLexicon.PRIMARY_TYPE, factory.create(JcrLexicon.PRIMARY_TYPE, new Object[]{ModeShapeLexicon.RESOURCE}));
            properties.put(JcrLexicon.LAST_MODIFIED, factory.create(JcrLexicon.LAST_MODIFIED, new Object[]{dateFactory.create(file.lastModified())}));
            BinaryFactory binaryFactory = this.context.getValueFactories().getBinaryFactory();
            properties.put(JcrLexicon.DATA, factory.create(JcrLexicon.DATA, new Object[]{binaryFactory.create(file)}));
            return new PathNode(null, path.getParent(), path.getLastSegment(), properties, Collections.emptyList());
        }
        File file = this.fileFor(path);
        if (file == null) {
            return null;
        }
        if (file.isDirectory()) {
            Object[] childNames = file.list(this.source.filenameFilter());
            Arrays.sort(childNames);
            ArrayList<Path.Segment> childSegments = new ArrayList<Path.Segment>(childNames.length);
            for (Object childName : childNames) {
                childSegments.add(pathFactory.createSegment((String)childName));
            }
            Collection<Property> customProps = customPropertiesFactory.getDirectoryProperties(this.context, location, file);
            for (Property customProp : customProps) {
                properties.put(customProp.getName(), customProp);
            }
            if (path.isRoot()) {
                properties.put(JcrLexicon.PRIMARY_TYPE, factory.create(JcrLexicon.PRIMARY_TYPE, new Object[]{ModeShapeLexicon.ROOT}));
                return new PathNode(this.source.getRootNodeUuidObject(), path.getParent(), path.getLastSegment(), properties, childSegments);
            }
            properties.put(JcrLexicon.PRIMARY_TYPE, factory.create(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FOLDER}));
            return new PathNode(null, path.getParent(), path.getLastSegment(), properties, childSegments);
        }
        Collection<Property> customProps = customPropertiesFactory.getFileProperties(this.context, location, file);
        for (Property customProp : customProps) {
            properties.put(customProp.getName(), customProp);
        }
        properties.put(JcrLexicon.PRIMARY_TYPE, factory.create(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FILE}));
        properties.put(JcrLexicon.CREATED, factory.create(JcrLexicon.CREATED, new Object[]{dateFactory.create(file.lastModified())}));
        return new PathNode(null, path.getParent(), path.getLastSegment(), properties, Collections.singletonList(pathFactory.createSegment(JcrLexicon.CONTENT)));
    }

    protected File fileFor(Path path) {
        return this.fileFor(path, true);
    }

    protected File fileFor(Path path, boolean existingFilesOnly) {
        if (path == null || path.isRoot()) {
            return this.workspaceRoot;
        }
        if (path.getLastSegment().getName().equals(JcrLexicon.CONTENT)) {
            path = path.getParent();
        }
        File file = this.workspaceRoot;
        for (Path.Segment segment : path) {
            String localName = segment.getName().getLocalName();
            if (segment.getIndex() > 1) {
                I18n msg = FileSystemI18n.sameNameSiblingsAreNotAllowed;
                throw new RepositorySourceException(this.source.getName(), msg.text(new Object[]{this.source.getName()}));
            }
            String defaultNamespaceUri = this.context.getNamespaceRegistry().getDefaultNamespaceUri();
            if (!segment.getName().getNamespaceUri().equals(defaultNamespaceUri)) {
                I18n msg = FileSystemI18n.onlyTheDefaultNamespaceIsAllowed;
                throw new RepositorySourceException(this.source.getName(), msg.text(new Object[]{this.source.getName()}));
            }
            file = new File(file, localName);
            if (!existingFilesOnly || file.canRead() && file.exists()) continue;
            return null;
        }
        assert (file != null);
        return file;
    }

    protected void validate(PathNode node) {
        Name primaryType;
        if (node.getParent() == null) {
            return;
        }
        NameFactory nameFactory = this.context.getValueFactories().getNameFactory();
        Map properties = node.getProperties();
        Property primaryTypeProp = (Property)properties.get(JcrLexicon.PRIMARY_TYPE);
        Name name = primaryType = primaryTypeProp == null ? JcrNtLexicon.FOLDER : (Name)nameFactory.create(primaryTypeProp.getFirstValue());
        if (!VALID_PRIMARY_TYPES.contains(primaryType)) {
            I18n msg = FileSystemI18n.unsupportedPrimaryType;
            NamespaceRegistry registry = this.context.getNamespaceRegistry();
            Path parentPath = node.getParent();
            throw new RepositorySourceException(this.source.getName(), msg.text(new Object[]{primaryType.getString(registry), parentPath, this.getName(), this.source.getName()}));
        }
        Path nodePath = this.context.getValueFactories().getPathFactory().create(node.getParent(), new Path.Segment[]{node.getName()});
        this.ensureValidPathLength(this.fileFor(nodePath, false));
    }

    protected void ensureValidPathLength(File file) {
        this.ensureValidPathLength(file, 0);
    }

    protected void ensureValidPathLength(File root, int delta) {
        try {
            int len = root.getCanonicalPath().length();
            if (len > this.source.getMaxPathLength() - delta) {
                String msg = FileSystemI18n.maxPathLengthExceeded.text(new Object[]{this.source.getMaxPathLength(), this.source.getName(), root.getCanonicalPath(), delta});
                throw new RepositorySourceException(this.source.getName(), msg);
            }
            if (root.isDirectory()) {
                for (File child : root.listFiles(this.source.filenameFilter())) {
                    this.ensureValidPathLength(child, delta);
                }
            }
        }
        catch (IOException ioe) {
            throw new RepositorySourceException(this.source.getName(), FileSystemI18n.getCanonicalPathFailed.text(new Object[0]), (Throwable)ioe);
        }
    }
}

