/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.filesystem;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import net.jcip.annotations.ThreadSafe;
import org.modeshape.common.annotation.Category;
import org.modeshape.common.annotation.Description;
import org.modeshape.common.annotation.Label;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;
import org.modeshape.connector.filesystem.CustomPropertiesFactory;
import org.modeshape.connector.filesystem.FileSystemI18n;
import org.modeshape.connector.filesystem.FileSystemRepository;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.Location;
import org.modeshape.graph.ModeShapeIntLexicon;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositorySourceCapabilities;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.base.AbstractRepositorySource;
import org.modeshape.graph.connector.base.BaseRepositorySource;
import org.modeshape.graph.connector.base.Connection;
import org.modeshape.graph.connector.base.Repository;
import org.modeshape.graph.connector.base.Transaction;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.request.CreateWorkspaceRequest;

@ThreadSafe
public class FileSystemSource
extends AbstractRepositorySource
implements ObjectFactory {
    protected static CustomPropertiesFactory DEFAULT_PROPERTIES_FACTORY = new StandardPropertiesFactory();
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_NAME_OF_DEFAULT_WORKSPACE = "default";
    protected static final String SOURCE_NAME = "sourceName";
    protected static final String DEFAULT_WORKSPACE = "defaultWorkspace";
    protected static final String WORKSPACE_ROOT = "workspaceRootPath";
    protected static final String PREDEFINED_WORKSPACE_NAMES = "predefinedWorkspaceNames";
    protected static final String ALLOW_CREATING_WORKSPACES = "allowCreatingWorkspaces";
    protected static final String MAX_PATH_LENGTH = "maxPathLength";
    protected static final String EXCLUSION_PATTERN = "exclusionPattern";
    protected static final String FILENAME_FILTER = "filenameFilter";
    protected static final String CUSTOM_PROPERTY_FACTORY = "customPropertyFactory";
    protected static final boolean SUPPORTS_EVENTS = true;
    protected static final boolean SUPPORTS_SAME_NAME_SIBLINGS = true;
    protected static final boolean DEFAULT_SUPPORTS_CREATING_WORKSPACES = true;
    public static final boolean DEFAULT_SUPPORTS_UPDATES = false;
    protected static final boolean SUPPORTS_REFERENCES = false;
    public static final int DEFAULT_MAX_PATH_LENGTH = 255;
    public static final String DEFAULT_EXCLUSION_PATTERN = null;
    public static final FilenameFilter DEFAULT_FILENAME_FILTER = null;
    @Description(i18n=FileSystemI18n.class, value="defaultWorkspaceNamePropertyDescription")
    @Label(i18n=FileSystemI18n.class, value="defaultWorkspaceNamePropertyLabel")
    @Category(i18n=FileSystemI18n.class, value="defaultWorkspaceNamePropertyCategory")
    private volatile String defaultWorkspaceName = "default";
    @Description(i18n=FileSystemI18n.class, value="workspaceRootPathPropertyDescription")
    @Label(i18n=FileSystemI18n.class, value="workspaceRootPathPropertyLabel")
    @Category(i18n=FileSystemI18n.class, value="workspaceRootPathPropertyCategory")
    private volatile String workspaceRootPath;
    @Description(i18n=FileSystemI18n.class, value="predefinedWorkspacesPropertyDescription")
    @Label(i18n=FileSystemI18n.class, value="predefinedWorkspacesPropertyLabel")
    @Category(i18n=FileSystemI18n.class, value="predefinedWorkspacesPropertyCategory")
    private volatile String[] predefinedWorkspaces = new String[0];
    @Description(i18n=FileSystemI18n.class, value="maxPathLengthPropertyDescription")
    @Label(i18n=FileSystemI18n.class, value="maxPathLengthPropertyLabel")
    @Category(i18n=FileSystemI18n.class, value="maxPathLengthPropertyCategory")
    private volatile int maxPathLength = 255;
    @Description(i18n=FileSystemI18n.class, value="exclusionPatternPropertyDescription")
    @Label(i18n=FileSystemI18n.class, value="exclusionPatternPropertyLabel")
    @Category(i18n=FileSystemI18n.class, value="exclusionPatternPropertyCategory")
    private volatile String exclusionPattern = DEFAULT_EXCLUSION_PATTERN;
    private volatile FilenameFilter filenameFilter = DEFAULT_FILENAME_FILTER;
    private volatile RepositorySourceCapabilities capabilities = new RepositorySourceCapabilities(true, false, true, true, false);
    private transient FileSystemRepository repository;
    private volatile CustomPropertiesFactory customPropertiesFactory;
    private ExecutionContext defaultContext = new ExecutionContext();

    public RepositorySourceCapabilities getCapabilities() {
        return this.capabilities;
    }

    public boolean getUpdatesAllowed() {
        return this.capabilities.supportsUpdates();
    }

    public String getWorkspaceRootPath() {
        return this.workspaceRootPath;
    }

    public synchronized void setWorkspaceRootPath(String workspaceRootPath) {
        this.workspaceRootPath = workspaceRootPath;
    }

    public String getExclusionPattern() {
        return this.exclusionPattern;
    }

    public synchronized void setExclusionPattern(String exclusionPattern) {
        this.exclusionPattern = exclusionPattern;
        this.filenameFilter = null;
    }

    public FilenameFilter getFilenameFilter() {
        return this.filenameFilter;
    }

    public synchronized void setFilenameFilter(FilenameFilter filenameFilter) {
        this.filenameFilter = filenameFilter;
        this.exclusionPattern = null;
    }

    public synchronized void setFilenameFilter(String filenameFilterClassName) throws ClassCastException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (filenameFilterClassName == null) {
            this.filenameFilter = null;
            return;
        }
        Class<?> filenameFilterClass = Class.forName(filenameFilterClassName);
        this.filenameFilter = (FilenameFilter)filenameFilterClass.newInstance();
        this.exclusionPattern = null;
    }

    FilenameFilter filenameFilter() {
        if (this.filenameFilter != null) {
            return this.filenameFilter;
        }
        FilenameFilter filenameFilter = null;
        final String filterPattern = this.exclusionPattern;
        if (filterPattern != null) {
            filenameFilter = new FilenameFilter(){
                Pattern filter;
                {
                    this.filter = Pattern.compile(filterPattern);
                }

                @Override
                public boolean accept(File dir, String name) {
                    return !this.filter.matcher(name).matches();
                }
            };
        }
        return filenameFilter;
    }

    public int getMaxPathLength() {
        return this.maxPathLength;
    }

    public synchronized void setMaxPathLength(int maxPathLength) {
        CheckArg.isNonNegative((int)maxPathLength, (String)MAX_PATH_LENGTH);
        this.maxPathLength = maxPathLength;
    }

    public String getDefaultWorkspaceName() {
        return this.defaultWorkspaceName;
    }

    public synchronized void setDefaultWorkspaceName(String nameOfDefaultWorkspace) {
        this.defaultWorkspaceName = nameOfDefaultWorkspace != null ? nameOfDefaultWorkspace : DEFAULT_NAME_OF_DEFAULT_WORKSPACE;
    }

    public synchronized String[] getPredefinedWorkspaceNames() {
        String[] copy = new String[this.predefinedWorkspaces.length];
        System.arraycopy(this.predefinedWorkspaces, 0, copy, 0, this.predefinedWorkspaces.length);
        return copy;
    }

    public synchronized void setPredefinedWorkspaceNames(String[] predefinedWorkspaceNames) {
        this.predefinedWorkspaces = predefinedWorkspaceNames;
    }

    public boolean isCreatingWorkspacesAllowed() {
        return this.capabilities.supportsCreatingWorkspaces();
    }

    public synchronized void setCreatingWorkspacesAllowed(boolean allowWorkspaceCreation) {
        this.capabilities = new RepositorySourceCapabilities(this.capabilities.supportsSameNameSiblings(), this.capabilities.supportsUpdates(), this.capabilities.supportsEvents(), allowWorkspaceCreation, this.capabilities.supportsReferences());
    }

    @Description(i18n=FileSystemI18n.class, value="updatesAllowedPropertyDescription")
    @Label(i18n=FileSystemI18n.class, value="updatesAllowedPropertyLabel")
    @Category(i18n=FileSystemI18n.class, value="updatesAllowedPropertyCategory")
    public boolean areUpdatesAllowed() {
        return this.capabilities.supportsUpdates();
    }

    public synchronized void setUpdatesAllowed(boolean allowUpdates) {
        this.capabilities = new RepositorySourceCapabilities(this.capabilities.supportsSameNameSiblings(), allowUpdates, this.capabilities.supportsEvents(), this.capabilities.supportsCreatingWorkspaces(), this.capabilities.supportsReferences());
    }

    public synchronized CustomPropertiesFactory getCustomPropertiesFactory() {
        return this.customPropertiesFactory;
    }

    CustomPropertiesFactory customPropertiesFactory() {
        return this.customPropertiesFactory != null ? this.customPropertiesFactory : DEFAULT_PROPERTIES_FACTORY;
    }

    public synchronized void setCustomPropertiesFactory(CustomPropertiesFactory customPropertiesFactory) {
        this.customPropertiesFactory = customPropertiesFactory;
    }

    public synchronized void setCustomPropertiesFactory(String customPropertiesFactoryClassName) throws ClassCastException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (customPropertiesFactoryClassName == null) {
            this.customPropertiesFactory = null;
            return;
        }
        Class<?> customPropertiesFactoryClass = Class.forName(customPropertiesFactoryClassName);
        this.customPropertiesFactory = (CustomPropertiesFactory)customPropertiesFactoryClass.newInstance();
    }

    public synchronized Reference getReference() {
        String className = this.getClass().getName();
        String factoryClassName = this.getClass().getName();
        Reference ref = new Reference(className, factoryClassName, null);
        if (this.getName() != null) {
            ref.add(new StringRefAddr(SOURCE_NAME, this.getName()));
        }
        ref.add(new StringRefAddr(DEFAULT_WORKSPACE, this.getDefaultWorkspaceName()));
        ref.add(new StringRefAddr(ALLOW_CREATING_WORKSPACES, Boolean.toString(this.isCreatingWorkspacesAllowed())));
        ref.add(new StringRefAddr(MAX_PATH_LENGTH, String.valueOf(this.maxPathLength)));
        String[] workspaceNames = this.getPredefinedWorkspaceNames();
        if (workspaceNames != null && workspaceNames.length != 0) {
            ref.add(new StringRefAddr(PREDEFINED_WORKSPACE_NAMES, StringUtil.combineLines((String[])workspaceNames)));
        }
        if (this.getCustomPropertiesFactory() != null) {
            ref.add(new StringRefAddr(CUSTOM_PROPERTY_FACTORY, this.getCustomPropertiesFactory().getClass().getName()));
        }
        if (this.exclusionPattern != null) {
            ref.add(new StringRefAddr(EXCLUSION_PATTERN, this.exclusionPattern));
        }
        if (this.filenameFilter != null) {
            ref.add(new StringRefAddr(FILENAME_FILTER, this.filenameFilter.getClass().getName()));
        }
        return ref;
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (obj instanceof Reference) {
            Map values = this.valuesFrom((Reference)obj);
            String sourceName = (String)values.get(SOURCE_NAME);
            String defaultWorkspace = (String)values.get(DEFAULT_WORKSPACE);
            String createWorkspaces = (String)values.get(ALLOW_CREATING_WORKSPACES);
            String exclusionPattern = (String)values.get(EXCLUSION_PATTERN);
            String filenameFilterClassName = (String)values.get(FILENAME_FILTER);
            String maxPathLength = (String)values.get(255);
            String customPropertiesFactoryClassName = (String)values.get(CUSTOM_PROPERTY_FACTORY);
            String combinedWorkspaceNames = (String)values.get(PREDEFINED_WORKSPACE_NAMES);
            String[] workspaceNames = null;
            if (combinedWorkspaceNames != null) {
                List paths = StringUtil.splitLines((String)combinedWorkspaceNames);
                workspaceNames = paths.toArray(new String[paths.size()]);
            }
            FileSystemSource source = new FileSystemSource();
            if (sourceName != null) {
                source.setName(sourceName);
            }
            if (defaultWorkspace != null) {
                source.setDefaultWorkspaceName(defaultWorkspace);
            }
            if (createWorkspaces != null) {
                source.setCreatingWorkspacesAllowed(Boolean.parseBoolean(createWorkspaces));
            }
            if (workspaceNames != null && workspaceNames.length != 0) {
                source.setPredefinedWorkspaceNames(workspaceNames);
            }
            if (exclusionPattern != null) {
                source.setExclusionPattern(exclusionPattern);
            }
            if (filenameFilterClassName != null) {
                source.setFilenameFilter(filenameFilterClassName);
            }
            if (maxPathLength != null) {
                source.setMaxPathLength(Integer.valueOf(maxPathLength));
            }
            if (customPropertiesFactoryClassName != null) {
                source.setCustomPropertiesFactory(customPropertiesFactoryClassName);
            }
            return source;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized RepositoryConnection getConnection() throws RepositorySourceException {
        String sourceName = this.getName();
        if (sourceName == null || sourceName.trim().length() == 0) {
            I18n msg = FileSystemI18n.propertyIsRequired;
            throw new RepositorySourceException(this.getName(), msg.text(new Object[]{"name"}));
        }
        if (this.repository == null) {
            this.repository = new FileSystemRepository(this);
            ExecutionContext context = this.repositoryContext != null ? this.repositoryContext.getExecutionContext() : this.defaultContext;
            FileSystemRepository.FileSystemTransaction txn = this.repository.startTransaction(context, false);
            try {
                for (String initialName : this.getPredefinedWorkspaceNames()) {
                    this.repository.createWorkspace((Transaction)txn, initialName, CreateWorkspaceRequest.CreateConflictBehavior.DO_NOT_CREATE, null);
                }
            }
            finally {
                txn.commit();
            }
        }
        return new Connection((BaseRepositorySource)this, (Repository)this.repository);
    }

    protected static class StandardPropertiesFactory
    implements CustomPropertiesFactory {
        private static final long serialVersionUID = 1L;
        private final Collection<Property> empty = Collections.emptyList();
        private final Set<org.modeshape.graph.property.Name> ALLOWABLE_PROPERTIES_FOR_CONTENT = Collections.unmodifiableSet(new HashSet<org.modeshape.graph.property.Name>(Arrays.asList(JcrLexicon.PRIMARY_TYPE, JcrLexicon.DATA, JcrLexicon.ENCODED, JcrLexicon.MIMETYPE, JcrLexicon.LAST_MODIFIED, JcrLexicon.UUID, ModeShapeIntLexicon.NODE_DEFINITON)));
        private final Set<org.modeshape.graph.property.Name> ALLOWABLE_PROPERTIES_FOR_FILE_OR_FOLDER = Collections.unmodifiableSet(new HashSet<org.modeshape.graph.property.Name>(Arrays.asList(JcrLexicon.PRIMARY_TYPE, JcrLexicon.CREATED, JcrLexicon.UUID, ModeShapeIntLexicon.NODE_DEFINITON)));

        protected StandardPropertiesFactory() {
        }

        @Override
        public Collection<Property> getDirectoryProperties(ExecutionContext context, Location location, File directory) {
            return this.empty;
        }

        @Override
        public Collection<Property> getFileProperties(ExecutionContext context, Location location, File file) {
            return this.empty;
        }

        @Override
        public Collection<Property> getResourceProperties(ExecutionContext context, Location location, File file, String mimeType) {
            return this.empty;
        }

        @Override
        public Set<org.modeshape.graph.property.Name> recordDirectoryProperties(ExecutionContext context, String sourceName, Location location, File file, Map<org.modeshape.graph.property.Name, Property> properties) throws RepositorySourceException {
            this.ensureValidProperties(context, sourceName, properties.values(), this.ALLOWABLE_PROPERTIES_FOR_FILE_OR_FOLDER);
            return null;
        }

        @Override
        public Set<org.modeshape.graph.property.Name> recordFileProperties(ExecutionContext context, String sourceName, Location location, File file, Map<org.modeshape.graph.property.Name, Property> properties) throws RepositorySourceException {
            this.ensureValidProperties(context, sourceName, properties.values(), this.ALLOWABLE_PROPERTIES_FOR_FILE_OR_FOLDER);
            return null;
        }

        @Override
        public Set<org.modeshape.graph.property.Name> recordResourceProperties(ExecutionContext context, String sourceName, Location location, File file, Map<org.modeshape.graph.property.Name, Property> properties) throws RepositorySourceException {
            this.ensureValidProperties(context, sourceName, properties.values(), this.ALLOWABLE_PROPERTIES_FOR_CONTENT);
            return null;
        }

        protected void ensureValidProperties(ExecutionContext context, String sourceName, Collection<Property> properties, Set<org.modeshape.graph.property.Name> validPropertyNames) {
            LinkedList<String> invalidNames = new LinkedList<String>();
            NamespaceRegistry registry = context.getNamespaceRegistry();
            for (Property property : properties) {
                if (validPropertyNames.contains(property.getName())) continue;
                invalidNames.add(property.getName().getString(registry));
            }
            if (!invalidNames.isEmpty()) {
                throw new RepositorySourceException(sourceName, FileSystemI18n.invalidPropertyNames.text(new Object[]{((Object)invalidNames).toString()}));
            }
        }
    }
}

