/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.filesystem;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.util.FileUtil;
import org.modeshape.connector.filesystem.StoreProperties;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Location;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Property;

public class SimplePropertiesFactoryTest {
    private static final String JAVA_TYPE = "text/x-java-source";
    private StoreProperties factory;
    private File testArea;
    private ExecutionContext context;
    private Collection<Property> properties;
    private Location location;
    private String source;
    private Map<Name, Property> newProperties;

    @Before
    public void beforeEach() throws IOException {
        this.testArea = new File("target/test/properties");
        FileUtil.delete((File)this.testArea);
        this.testArea.mkdirs();
        FileUtil.copy((File)new File("src/main/java/org"), (File)new File(this.testArea, "org"));
        this.factory = new StoreProperties();
        this.newProperties = new HashMap<Name, Property>();
        this.context = new ExecutionContext();
        this.context.getNamespaceRegistry().register("test", "http://www.modeshape.org/test/1.0");
    }

    @After
    public void afterEach() {
        this.testArea = null;
    }

    @Test
    public void shouldHaveCopiedFilesIntoTestArea() throws Exception {
        this.assertFolder("org");
        this.assertFolder("org/modeshape");
        this.assertFolder("org/modeshape/connector");
        this.assertFolder("org/modeshape/connector/filesystem");
        this.assertFile("org/modeshape/connector/filesystem/CustomPropertiesFactory.java");
        this.assertFile("org/modeshape/connector/filesystem/FileSystemI18n.java");
        this.assertFile("org/modeshape/connector/filesystem/FileSystemRepository.java");
        this.assertFile("org/modeshape/connector/filesystem/FileSystemSource.java");
        this.assertFile("org/modeshape/connector/filesystem/FileSystemWorkspace.java");
        this.assertFile("org/modeshape/connector/filesystem/package-info.java");
        this.assertFile("org/modeshape/connector/filesystem/StoreProperties.java");
    }

    @Test
    public void shouldReadPropertiesForDirectoryWhenExtraPropertiesFileDoesNotExist() throws Exception {
        this.properties = this.factory.getDirectoryProperties(this.context, this.location, this.fileAt("org"));
        Assert.assertThat((Object)this.properties.isEmpty(), Is.is(true));
        this.properties = this.factory.getDirectoryProperties(this.context, this.location, this.fileAt("org/modeshape"));
        Assert.assertThat((Object)this.properties.isEmpty(), Is.is(true));
        this.properties = this.factory.getDirectoryProperties(this.context, this.location, this.fileAt("org/modeshape/connector"));
        Assert.assertThat((Object)this.properties.isEmpty(), Is.is(true));
        this.properties = this.factory.getDirectoryProperties(this.context, this.location, this.fileAt("org/modeshape/connector/filesystem"));
        Assert.assertThat((Object)this.properties.isEmpty(), Is.is(true));
    }

    @Test
    public void shouldReadPropertiesForFileWhenExtraPropertiesFileDoesNotExist() throws Exception {
        File file = this.fileAt("org/modeshape/connector/filesystem/CustomPropertiesFactory.java");
        this.properties = this.factory.getFileProperties(this.context, this.location, file);
        Assert.assertThat((Object)this.properties.isEmpty(), Is.is(true));
    }

    @Test
    public void shouldReadPropertiesForResourceWhenExtraPropertiesFileDoesNotExist() throws Exception {
        File file = this.fileAt("org/modeshape/connector/filesystem/CustomPropertiesFactory.java");
        this.properties = this.factory.getResourceProperties(this.context, this.location, file, JAVA_TYPE);
        Assert.assertThat((Object)this.properties.isEmpty(), Is.is(true));
    }

    @Test
    public void shouldWritePropertiesForDirectory() throws Exception {
        File dir = this.fileAt("org");
        this.addProperties();
        this.factory.recordDirectoryProperties(this.context, this.source, this.location, dir, this.newProperties);
        this.properties = this.factory.getDirectoryProperties(this.context, this.location, dir);
        this.assertPropertiesMatch();
    }

    protected File fileAt(String path) {
        return new File(this.testArea, path);
    }

    protected void addProperty(String name, Object ... values) {
        Name propName = (Name)this.context.getValueFactories().getNameFactory().create(name);
        Property property = this.context.getPropertyFactory().create(propName, values);
        this.newProperties.put(property.getName(), property);
    }

    protected void addProperties() {
        this.addProperty("test:stringProp", "val1");
        this.addProperty("test:stringPropWithOddChars", "val1 has spaces and \"quotes\" and \n new line characters");
        this.addProperty("test:longProp", 2L);
        this.addProperty("test:doubleProp", 3.523);
        this.addProperty("test:booleanProp", true);
        this.addProperty("test:binaryProp", this.context.getValueFactories().getBinaryFactory().create("This is the content".getBytes()));
    }

    protected void assertPropertiesMatch() {
        Assert.assertThat((Object)this.properties.size(), Is.is(this.newProperties.size()));
        for (Property prop : this.properties) {
            Assert.assertThat((Object)this.newProperties.containsKey(prop.getName()), Is.is(true));
            Assert.assertThat((Object)this.newProperties.get(prop.getName()), Is.is(prop));
        }
    }

    protected void assertFolder(String path) {
        File file = new File(this.testArea, path);
        Assert.assertThat((Object)file.exists(), Is.is(true));
        Assert.assertThat((Object)file.canRead(), Is.is(true));
        Assert.assertThat((Object)file.isDirectory(), Is.is(true));
    }

    protected void assertFile(String path) {
        File file = new File(this.testArea, path);
        Assert.assertThat((Object)file.exists(), Is.is(true));
        Assert.assertThat((Object)file.canRead(), Is.is(true));
        Assert.assertThat((Object)file.isFile(), Is.is(true));
        Assert.assertThat((Object)(file.length() > 0L ? 1 : 0), Is.is(true));
    }
}

