/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.filesystem;

import java.util.List;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.connector.filesystem.FileSystemSource;
import org.modeshape.graph.Graph;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.JcrNtLexicon;
import org.modeshape.graph.Location;
import org.modeshape.graph.Node;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.test.ReadableConnectorTest;
import org.modeshape.graph.property.PathNotFoundException;

public class FileSystemConnectorReadableTest
extends ReadableConnectorTest {
    protected RepositorySource setUpSource() {
        String path = "./src/test/resources/repositories/";
        String[] predefinedWorkspaceNames = new String[]{path + "airplanes", path + "cars"};
        FileSystemSource source = new FileSystemSource();
        source.setName("Test Repository");
        source.setPredefinedWorkspaceNames(predefinedWorkspaceNames);
        source.setDefaultWorkspaceName(predefinedWorkspaceNames[0]);
        source.setCreatingWorkspacesAllowed(true);
        return source;
    }

    protected void initializeContent(Graph graph) {
    }

    public void assertThatNodeIsFile(Node node, String mimeType, String contents) {
        Assert.assertThat((Object)node, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)node.getProperty(JcrLexicon.PRIMARY_TYPE).getFirstValue(), Is.is(JcrNtLexicon.FILE));
        List children = node.getChildren();
        Assert.assertThat((Object)children.size(), Is.is(1));
        Location jcrContentLocation = (Location)children.get(0);
        Assert.assertThat((Object)jcrContentLocation.getPath().getLastSegment().getName(), Is.is(JcrLexicon.CONTENT));
        Node jcrContent = this.graph.getNodeAt(jcrContentLocation);
        Assert.assertThat((Object)this.string(jcrContent.getProperty(JcrLexicon.MIMETYPE).getFirstValue()), Is.is(mimeType));
        if (contents != null) {
            Assert.assertThat((Object)this.string(jcrContent.getProperty(JcrLexicon.DATA).getFirstValue()), Is.is(contents));
        }
    }

    public void assertThatNodeIsFolder(Node node) {
        Assert.assertThat((Object)node, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)node.getProperty(JcrLexicon.PRIMARY_TYPE).getFirstValue(), Is.is(JcrNtLexicon.FOLDER));
    }

    @Test
    public void shouldFindFolderSpecifiedInPathsAsNodesBelowRoot() {
        Node commercial = this.graph.getNodeAt("/commercial");
        this.assertThatNodeIsFolder(commercial);
        Node readme = this.graph.getNodeAt("/commercial/Boeing_777.jpg");
        this.assertThatNodeIsFile(readme, "image/jpeg", null);
    }

    @Test
    public void shouldBeAbleToExcludePattern() {
        ((FileSystemSource)this.source).setExclusionPattern("emptyfile.txt");
        try {
            this.graph.getNodeAt("/emptyfile.txt");
            Assert.fail((String)"Should not exist");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        ((FileSystemSource)this.source).setExclusionPattern(null);
    }
}

