/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.filesystem;

import java.io.File;
import java.util.LinkedList;
import java.util.UUID;
import org.modeshape.common.i18n.I18n;
import org.modeshape.connector.filesystem.FileSystemI18n;
import org.modeshape.connector.filesystem.FileSystemSource;
import org.modeshape.connector.filesystem.FileSystemWorkspace;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Location;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.base.BaseRepositorySource;
import org.modeshape.graph.connector.base.PathNode;
import org.modeshape.graph.connector.base.PathTransaction;
import org.modeshape.graph.connector.base.PathWorkspace;
import org.modeshape.graph.connector.base.Processor;
import org.modeshape.graph.connector.base.Repository;
import org.modeshape.graph.connector.base.Transaction;
import org.modeshape.graph.observe.Observer;
import org.modeshape.graph.property.InvalidPathException;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.request.InvalidRequestException;
import org.modeshape.graph.request.InvalidWorkspaceException;
import org.modeshape.graph.request.MoveBranchRequest;
import org.modeshape.graph.request.Request;
import org.modeshape.graph.request.VerifyWorkspaceRequest;
import org.modeshape.graph.request.processor.RequestProcessor;

public class FileSystemRepository
extends Repository<PathNode, FileSystemWorkspace> {
    protected final FileSystemSource source;
    private File repositoryRoot;

    public FileSystemRepository(FileSystemSource source) {
        super((BaseRepositorySource)source);
        this.source = source;
        this.initialize();
    }

    protected void initialize() {
        String repositoryRootPath = this.source.getWorkspaceRootPath();
        String sourceName = this.getSourceName();
        if (repositoryRootPath != null) {
            this.repositoryRoot = new File(repositoryRootPath);
            if (!this.repositoryRoot.exists()) {
                throw new IllegalStateException(FileSystemI18n.pathForWorkspaceRootDoesNotExist.text(new Object[]{repositoryRootPath, sourceName}));
            }
            if (!this.repositoryRoot.isDirectory()) {
                throw new IllegalStateException(FileSystemI18n.pathForWorkspaceRootIsNotDirectory.text(new Object[]{repositoryRootPath, sourceName}));
            }
            if (!this.repositoryRoot.canRead()) {
                throw new IllegalStateException(FileSystemI18n.pathForWorkspaceRootCannotBeRead.text(new Object[]{repositoryRootPath, sourceName}));
            }
        }
        super.initialize();
    }

    private void createDirectory(File directory) {
        File parent = directory.getParentFile();
        if (!parent.exists()) {
            this.createDirectory(parent);
        } else if (parent.isFile()) {
            I18n msg = FileSystemI18n.ancestorInPathIsFile;
            throw new InvalidWorkspaceException(msg.text(new Object[]{this.source.getName(), parent.getPath()}));
        }
        if (!directory.mkdir()) {
            I18n msg = FileSystemI18n.couldNotCreateDirectory;
            throw new InvalidWorkspaceException(msg.text(new Object[]{this.source.getName(), directory.getPath()}));
        }
    }

    protected File getWorkspaceDirectory(String workspaceName) {
        File directory;
        if (workspaceName == null) {
            workspaceName = this.source.getDefaultWorkspaceName();
        }
        File file = directory = this.repositoryRoot == null ? new File(workspaceName) : new File(this.repositoryRoot, workspaceName);
        if (!directory.exists()) {
            this.createDirectory(directory.getAbsoluteFile());
        }
        if (!directory.canRead()) {
            I18n msg = FileSystemI18n.pathForWorkspaceCannotBeRead;
            throw new InvalidWorkspaceException(msg.text(new Object[]{this.getSourceName(), directory.getAbsolutePath(), workspaceName}));
        }
        if (!directory.isDirectory()) {
            I18n msg = FileSystemI18n.pathForWorkspaceIsNotDirectory;
            throw new InvalidWorkspaceException(msg.text(new Object[]{this.getSourceName(), directory.getAbsolutePath(), workspaceName}));
        }
        return directory;
    }

    public FileSystemTransaction startTransaction(ExecutionContext context, boolean readonly) {
        return new FileSystemTransaction(this, this.source.getRootNodeUuidObject());
    }

    public RequestProcessor createRequestProcessor(Transaction<PathNode, FileSystemWorkspace> txn) {
        RepositoryContext repositoryContext = this.source.getRepositoryContext();
        Observer observer = repositoryContext != null ? repositoryContext.getObserver() : null;
        return new FileSystemProcessor(txn, this, observer, this.source.areUpdatesAllowed());
    }

    class FileSystemProcessor
    extends Processor<PathNode, FileSystemWorkspace> {
        private FileSystemTransaction txn;

        public FileSystemProcessor(Transaction<PathNode, FileSystemWorkspace> txn, Repository<PathNode, FileSystemWorkspace> repository, Observer observer, boolean updatesAllowed) {
            super(txn, repository, observer, updatesAllowed);
            this.txn = (FileSystemTransaction)txn;
        }

        public void process(MoveBranchRequest request) {
            if (request.before() != null) {
                I18n msg = FileSystemI18n.nodeOrderingNotSupported;
                throw new InvalidRequestException(msg.text(new Object[]{FileSystemRepository.this.source.getName()}));
            }
            super.process(request);
        }

        public void process(VerifyWorkspaceRequest request) {
            FileSystemWorkspace workspace = (FileSystemWorkspace)this.getWorkspace((Request)request, request.workspaceName());
            if (workspace != null) {
                request.setActualRootLocation(this.txn.getRootLocation());
                request.setActualWorkspaceName(workspace.getName());
            }
        }

        protected int absoluteMaximumDepthForBranchReads() {
            return 1;
        }
    }

    class FileSystemTransaction
    extends PathTransaction<PathNode, FileSystemWorkspace> {
        public FileSystemTransaction(FileSystemRepository repository, UUID rootNodeUuid) {
            super((Repository)repository, rootNodeUuid);
        }

        protected PathNode createNode(Path.Segment name, Path parentPath, Iterable<Property> properties) {
            return new PathNode(null, parentPath, name, properties, new LinkedList());
        }

        public boolean destroyWorkspace(FileSystemWorkspace workspace) throws InvalidWorkspaceException {
            return true;
        }

        public FileSystemWorkspace getWorkspace(String name, FileSystemWorkspace originalToClone) throws InvalidWorkspaceException {
            FileSystemRepository repository = FileSystemRepository.this;
            if (originalToClone != null) {
                return new FileSystemWorkspace(name, originalToClone, repository.getWorkspaceDirectory(name));
            }
            return new FileSystemWorkspace(repository, name);
        }

        protected void validateNode(FileSystemWorkspace workspace, PathNode node) {
            workspace.validate(node);
        }

        public PathNode addChild(FileSystemWorkspace workspace, PathNode parent, Name name, int index, UUID uuid, Iterable<Property> properties) {
            String newFileName = name.getLocalName();
            if (!FileSystemRepository.this.source.filenameFilter(true).accept(null, newFileName)) {
                throw new InvalidPathException(FileSystemI18n.cannotCreateFileAsExcludedPattern.text(new Object[]{newFileName, workspace.getName()}));
            }
            return super.addChild((PathWorkspace)workspace, parent, name, index, uuid, properties);
        }

        public Location addChild(FileSystemWorkspace workspace, PathNode parent, PathNode originalChild, PathNode beforeOtherChild, Name desiredName) {
            if (desiredName != null) {
                String newFileName = desiredName.getLocalName();
                if (!FileSystemRepository.this.source.filenameFilter(true).accept(null, newFileName)) {
                    String oldFileName = originalChild.getName().getString(this.context.getNamespaceRegistry());
                    throw new InvalidPathException(FileSystemI18n.cannotRenameFileToExcludedPattern.text(new Object[]{oldFileName, newFileName, workspace.getName()}));
                }
            }
            return super.addChild((PathWorkspace)workspace, parent, originalChild, beforeOtherChild, desiredName);
        }
    }
}

