/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.git;

import java.io.IOException;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.infinispan.schematic.document.Document;
import org.modeshape.connector.git.CallSpecification;
import org.modeshape.connector.git.GitCommitDetails;
import org.modeshape.connector.git.GitConnector;
import org.modeshape.connector.git.GitFunction;
import org.modeshape.connector.git.GitHistory;
import org.modeshape.connector.git.GitLexicon;
import org.modeshape.connector.git.GitTree;
import org.modeshape.connector.git.Values;
import org.modeshape.jcr.federation.spi.DocumentWriter;

public class GitTags
extends GitFunction {
    protected static final String NAME = "tags";
    protected static final String ID = "/tags";

    public GitTags(GitConnector connector) {
        super(NAME, connector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Document execute(Repository repository, Git git, CallSpecification spec, DocumentWriter writer, Values values) throws GitAPIException, IOException {
        if (spec.parameterCount() == 0) {
            writer.setPrimaryType(GitLexicon.TAGS);
            this.addTagsAsChildren(git, spec, writer);
        } else if (spec.parameterCount() == 1) {
            writer.setPrimaryType(GitLexicon.TAG);
            String tagName = spec.parameter(0);
            Ref ref = repository.getRef(tagName);
            if (ref == null) {
                return null;
            }
            RevWalk walker = new RevWalk(repository);
            try {
                RevCommit commit = walker.parseCommit((AnyObjectId)ref.getObjectId());
                ObjectId objId = commit.getId();
                writer.addProperty(GitLexicon.OBJECT_ID, (Object)objId.name());
                writer.addProperty(GitLexicon.TREE, GitTree.referenceToTree(objId, objId.name(), values));
                writer.addProperty(GitLexicon.HISTORY, GitHistory.referenceToHistory(objId, tagName, values));
                writer.addProperty(GitLexicon.DETAIL, GitCommitDetails.referenceToCommit(objId, values));
            }
            finally {
                walker.dispose();
            }
        } else {
            return null;
        }
        return writer.document();
    }
}

