/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.distribution;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.infinispan.commands.DataCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.distribution.BaseDistributionInterceptor;
import org.infinispan.interceptors.distribution.NonTxDistributionInterceptor;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class NonTxConcurrentDistributionInterceptor
extends NonTxDistributionInterceptor {
    private static Log log = LogFactory.getLog(NonTxConcurrentDistributionInterceptor.class);

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        if (ctx.isOriginLocal()) {
            HashSet<Address> primaryOwners = new HashSet<Address>(command.getAffectedKeys().size());
            for (Object k : command.getAffectedKeys()) {
                primaryOwners.add(this.cdl.getPrimaryOwner(k));
            }
            primaryOwners.remove(this.rpcManager.getAddress());
            if (!primaryOwners.isEmpty()) {
                this.rpcManager.invokeRemotely(primaryOwners, command, this.isSynchronous(command));
            }
        } else if (!command.isForwarded()) {
            HashSet<Object> keysIOwn = new HashSet<Object>(command.getAffectedKeys());
            for (Object k : command.getAffectedKeys()) {
                if (!this.cdl.localNodeIsPrimaryOwner(k)) continue;
                keysIOwn.add(k);
            }
            Collection<Address> backupOwners = this.cdl.getOwners(keysIOwn);
            if (!backupOwners.isEmpty()) {
                command.setFlags(Flag.SKIP_LOCKING);
                command.setForwarded(true);
                this.rpcManager.invokeRemotely(backupOwners, command, this.isSynchronous(command));
                command.setForwarded(false);
            }
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    protected Object handleLocalWrite(InvocationContext ctx, WriteCommand command, BaseDistributionInterceptor.RecipientGenerator rg, boolean skipL1Invalidation, boolean sync) throws Throwable {
        Object key = ((DataCommand)((Object)command)).getKey();
        Address primaryOwner = this.cdl.getPrimaryOwner(key);
        if (primaryOwner.equals(this.rpcManager.getAddress())) {
            List<Address> recipients = rg.generateRecipients();
            log.tracef("I'm the primary owner, sending the command to all (%s) the recipients in order to be applied.", recipients);
            Object result = this.invokeNextInterceptor(ctx, command);
            if (!this.isSingleOwnerAndLocal(rg)) {
                this.rpcManager.invokeRemotely(recipients, command, sync);
            }
            return result;
        }
        log.tracef("I'm not the primary owner, so sending the command to the primary owner(%s) in order to be forwarded", primaryOwner);
        Object localResult = this.invokeNextInterceptor(ctx, command);
        Map<Address, Response> addressResponseMap = this.rpcManager.invokeRemotely(Collections.singletonList(primaryOwner), command, sync);
        if (!sync) {
            return localResult;
        }
        return this.getResponseFromPrimaryOwner(primaryOwner, addressResponseMap);
    }

    @Override
    protected void handleRemoteWrite(InvocationContext ctx, WriteCommand command, BaseDistributionInterceptor.RecipientGenerator recipientGenerator, boolean skipL1Invalidation, boolean sync) throws Throwable {
        DataCommand dataCommand;
        Address primaryOwner;
        if (command instanceof DataCommand && (primaryOwner = this.cdl.getPrimaryOwner((dataCommand = (DataCommand)((Object)command)).getKey())).equals(this.rpcManager.getAddress())) {
            this.rpcManager.invokeRemotely(recipientGenerator.generateRecipients(), command, sync);
        }
    }
}

