/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.dircache;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import org.eclipse.jgit.dircache.BaseDirCacheEditor;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.TreeWalk;

public class DirCacheBuilder
extends BaseDirCacheEditor {
    private boolean sorted;

    protected DirCacheBuilder(DirCache dc, int ecnt) {
        super(dc, ecnt);
    }

    public void add(DirCacheEntry newEntry) {
        if (newEntry.getRawMode() == 0) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().fileModeNotSetForPath, newEntry.getPathString()));
        }
        this.beforeAdd(newEntry);
        this.fastAdd(newEntry);
    }

    public void keep(int pos, int cnt) {
        this.beforeAdd(this.cache.getEntry(pos));
        this.fastKeep(pos, cnt);
    }

    public void addTree(byte[] pathPrefix, int stage, ObjectReader reader, AnyObjectId tree) throws IOException {
        TreeWalk tw = new TreeWalk(reader);
        tw.addTree(new CanonicalTreeParser(pathPrefix, reader, tree.toObjectId()));
        tw.setRecursive(true);
        if (tw.next()) {
            DirCacheEntry newEntry = this.toEntry(stage, tw);
            this.beforeAdd(newEntry);
            this.fastAdd(newEntry);
            while (tw.next()) {
                this.fastAdd(this.toEntry(stage, tw));
            }
        }
    }

    private DirCacheEntry toEntry(int stage, TreeWalk tw) {
        DirCacheEntry e = new DirCacheEntry(tw.getRawPath(), stage);
        AbstractTreeIterator i = tw.getTree(0, AbstractTreeIterator.class);
        e.setFileMode(tw.getFileMode(0));
        e.setObjectIdFromRaw(i.idBuffer(), i.idOffset());
        return e;
    }

    public void finish() {
        if (!this.sorted) {
            this.resort();
        }
        this.replace();
    }

    private void beforeAdd(DirCacheEntry newEntry) {
        if (this.sorted && this.entryCnt > 0) {
            DirCacheEntry lastEntry = this.entries[this.entryCnt - 1];
            int cr = DirCache.cmp(lastEntry, newEntry);
            if (cr > 0) {
                this.sorted = false;
            } else if (cr == 0) {
                int dceStage;
                int peStage = lastEntry.getStage();
                if (peStage == (dceStage = newEntry.getStage())) {
                    throw DirCacheBuilder.bad(newEntry, JGitText.get().duplicateStagesNotAllowed);
                }
                if (peStage == 0 || dceStage == 0) {
                    throw DirCacheBuilder.bad(newEntry, JGitText.get().mixedStagesNotAllowed);
                }
                if (peStage > dceStage) {
                    this.sorted = false;
                }
            }
        }
    }

    private void resort() {
        Arrays.sort(this.entries, 0, this.entryCnt, DirCache.ENT_CMP);
        for (int entryIdx = 1; entryIdx < this.entryCnt; ++entryIdx) {
            int ceStage;
            DirCacheEntry pe = this.entries[entryIdx - 1];
            DirCacheEntry ce = this.entries[entryIdx];
            int cr = DirCache.cmp(pe, ce);
            if (cr != 0) continue;
            int peStage = pe.getStage();
            if (peStage == (ceStage = ce.getStage())) {
                throw DirCacheBuilder.bad(ce, JGitText.get().duplicateStagesNotAllowed);
            }
            if (peStage != 0 && ceStage != 0) continue;
            throw DirCacheBuilder.bad(ce, JGitText.get().mixedStagesNotAllowed);
        }
        this.sorted = true;
    }

    private static IllegalStateException bad(DirCacheEntry a, String msg) {
        return new IllegalStateException(msg + ": " + a.getStage() + " " + a.getPathString());
    }
}

