/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.infinispan;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.infinispan.Cache;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.modeshape.connector.infinispan.InfinispanSource;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Node;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.observe.Observer;
import org.modeshape.graph.property.PathNotFoundException;

@Ignore
public class InfinispanClusterTest {
    private static final String CONFIG_FILE = "./src/test/resources/infinispan_clustered_config.xml";
    private final ExecutionContext context = new ExecutionContext();

    @Test
    public void shouldDistributeGraphNodes() {
        InfinispanSource source1 = new InfinispanSource();
        source1.setName("source1");
        source1.setCacheConfigurationName(CONFIG_FILE);
        source1.initialize(this.repositoryContextFor((RepositorySource)source1));
        InfinispanSource source2 = new InfinispanSource();
        source2.setName("source2");
        source2.setCacheConfigurationName(CONFIG_FILE);
        source2.initialize(this.repositoryContextFor((RepositorySource)source2));
        Graph graph1 = Graph.create((RepositorySource)source1, (ExecutionContext)this.context);
        Graph graph2 = Graph.create((RepositorySource)source2, (ExecutionContext)this.context);
        Assert.assertThat((Object)source1.getRootNodeUuid(), (Matcher)CoreMatchers.is((Object)source2.getRootNodeUuid()));
        Node root1 = graph1.getNodeAt("/");
        Node root2 = graph2.getNodeAt("/");
        Assert.assertThat((Object)root1.getLocation(), (Matcher)CoreMatchers.is((Object)root2.getLocation()));
        graph1.create("/foo").and();
        Cache cache1 = source1.cacheManager().getCache("");
        Cache cache2 = source2.cacheManager().getCache("");
        Assert.assertThat((Object)cache1.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)cache2.size(), (Matcher)CoreMatchers.is((Object)2));
        graph2.getNodeAt("/foo");
        graph2.delete("/foo");
        try {
            graph1.getNodeAt("/foo");
            Assert.fail((String)"/foo was deleted by the other source and should no longer exist");
        }
        catch (PathNotFoundException expected) {
            // empty catch block
        }
    }

    private final RepositoryContext repositoryContextFor(final RepositorySource source) {
        return new RepositoryContext(){

            public Subgraph getConfiguration(int depth) {
                return null;
            }

            public ExecutionContext getExecutionContext() {
                return InfinispanClusterTest.this.context;
            }

            public Observer getObserver() {
                return null;
            }

            public RepositoryConnectionFactory getRepositoryConnectionFactory() {
                return new RepositoryConnectionFactory(){

                    public RepositoryConnection createConnection(String sourceName) throws RepositorySourceException {
                        return source.getConnection();
                    }
                };
            }
        };
    }
}

