/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.infinispan;

import java.io.File;
import javax.naming.Context;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.infinispan.manager.DefaultCacheManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.modeshape.common.util.FileUtil;
import org.modeshape.connector.infinispan.InfinispanSource;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.SubgraphNode;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.RepositorySourceException;

public class PersistentInfinispanConnectorTest {
    protected static final String JNDI_NAME = "java/MyCacheManager";
    private ExecutionContext context;
    private InfinispanSource source;
    private RepositoryContext mockRepositoryContext;
    private Graph graph;

    @Before
    public void beforeEach() throws Exception {
        this.context = new ExecutionContext();
        this.mockRepositoryContext = (RepositoryContext)Mockito.mock(RepositoryContext.class);
        Mockito.when((Object)this.mockRepositoryContext.getExecutionContext()).thenReturn((Object)this.context);
        String[] predefinedWorkspaceNames = new String[]{"default"};
        this.source = new InfinispanSource();
        this.source.setName("Test Repository");
        this.source.setPredefinedWorkspaceNames(predefinedWorkspaceNames);
        this.source.setDefaultWorkspaceName(predefinedWorkspaceNames[0]);
        this.source.setCreatingWorkspacesAllowed(true);
        this.source.initialize(this.mockRepositoryContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() throws Exception {
        this.graph = null;
        try {
            this.source.close();
        }
        finally {
            File store = new File("target/infinispan/jcr");
            FileUtil.delete((File)store);
        }
    }

    protected Graph graph() {
        if (this.graph == null) {
            this.graph = Graph.create((RepositorySource)this.source, (ExecutionContext)this.context);
        }
        return this.graph;
    }

    private void setupCacheThroughJndi() throws Exception {
        DefaultCacheManager cacheManager = new DefaultCacheManager("infinispan_persistent_config.xml");
        Context mockJndi = (Context)Mockito.mock(Context.class);
        Mockito.when((Object)mockJndi.lookup(Matchers.anyString())).thenReturn(null);
        Mockito.when((Object)mockJndi.lookup(JNDI_NAME)).thenReturn((Object)cacheManager);
        this.source.setContext(mockJndi);
        this.source.setCacheManagerJndiName(JNDI_NAME);
    }

    private void setupCacheThroughClasspath() throws Exception {
        this.source.setCacheConfigurationName("/infinispan_persistent_config.xml");
    }

    private void setupCacheThroughFile() throws Exception {
        this.source.setCacheConfigurationName("./src/test/resources/infinispan_persistent_config.xml");
    }

    private void testWriteAndRead() {
        Subgraph subgraph = (Subgraph)this.graph().getSubgraphOfDepth(10).at("/");
        Assert.assertThat((Object)subgraph.getNode("/"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.graph().create("/a").with("prop1", new Object[]{"value1"}).and();
        subgraph = (Subgraph)this.graph().getSubgraphOfDepth(10).at("/");
        Assert.assertThat((Object)subgraph.getNode("/"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("/a")).getProperty("prop1").getFirstValue(), (Matcher)Is.is((Object)"value1"));
    }

    @Test
    public void shouldShutdownWithoutOpeningConnections() throws Exception {
        this.setupCacheThroughJndi();
        this.source.close();
    }

    @Test
    public void shouldShutdownAfterOpeningConnections() throws Exception {
        this.setupCacheThroughJndi();
        RepositoryConnection connection = this.source.getConnection();
        connection.close();
    }

    @Test
    public void shouldHaveRootNode() throws Exception {
        this.setupCacheThroughJndi();
        Assert.assertThat((Object)this.graph().getNodeAt("/"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldAllowCreatingAndReReadingNodesFromJndiCache() throws Exception {
        this.setupCacheThroughJndi();
        this.testWriteAndRead();
    }

    @Test
    public void shouldAllowCreatingAndReReadingNodesFromClasspathConfig() throws Exception {
        this.setupCacheThroughClasspath();
        this.testWriteAndRead();
    }

    @Test
    public void shouldAllowCreatingAndReReadingNodesFromFileConfig() throws Exception {
        this.setupCacheThroughFile();
        this.testWriteAndRead();
    }

    @Test(expected=RepositorySourceException.class)
    public void shouldThrowExceptionIfBadConfigFileSpecified() {
        this.source.setCacheConfigurationName("./thisFileIsNotOnTheClasspathOrTheFileSystem.xml");
        this.source.getConnection();
    }
}

