/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.atomic.AtomicHashMap;
import org.infinispan.atomic.AtomicMap;
import org.infinispan.batch.AutoBatchSupport;
import org.infinispan.batch.BatchContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class AtomicHashMapProxy<K, V>
extends AutoBatchSupport
implements AtomicMap<K, V> {
    private static final Log log = LogFactory.getLog(AtomicHashMapProxy.class);
    private static final boolean trace = log.isTraceEnabled();
    Object deltaMapKey;
    Cache cache;
    InvocationContextContainer icc;

    AtomicHashMapProxy(Cache cache, Object deltaMapKey, BatchContainer batchContainer, InvocationContextContainer icc) {
        this.cache = cache;
        this.deltaMapKey = deltaMapKey;
        this.batchContainer = batchContainer;
        this.icc = icc;
    }

    private AtomicHashMap<K, V> getDeltaMapForRead() {
        return (AtomicHashMap)this.cache.get(this.deltaMapKey);
    }

    private AtomicHashMap<K, V> getDeltaMapForWrite(InvocationContext ctx) {
        AtomicHashMap<K, V> map;
        boolean lockedAndCopied;
        CacheEntry lookedUpEntry = ctx.lookupEntry(this.deltaMapKey);
        boolean bl = lockedAndCopied = lookedUpEntry != null && lookedUpEntry.isChanged() && ((AtomicHashMap)lookedUpEntry.getValue()).copied;
        if (lockedAndCopied) {
            return this.getDeltaMapForRead();
        }
        boolean suppressLocks = ctx.hasFlag(Flag.SKIP_LOCKING);
        if (!suppressLocks) {
            ctx.setFlags(Flag.FORCE_WRITE_LOCK);
        }
        if (trace) {
            if (suppressLocks) {
                log.trace("Skip locking flag used.  Skipping locking.");
            } else {
                log.trace("Forcing write lock even for reads");
            }
        }
        AtomicHashMap copy = (map = this.getDeltaMapForRead()) == null ? new AtomicHashMap(true) : map.copyForWrite();
        copy.initForWriting();
        if (suppressLocks) {
            ctx.setFlags(Flag.SKIP_LOCKING);
        }
        this.cache.put(this.deltaMapKey, copy);
        return copy;
    }

    @Override
    public Set<K> keySet() {
        AtomicHashMap<K, V> map = this.getDeltaMapForRead();
        return map == null ? Collections.EMPTY_SET : map.keySet();
    }

    @Override
    public Collection<V> values() {
        AtomicHashMap<K, V> map = this.getDeltaMapForRead();
        return map == null ? Collections.EMPTY_SET : map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        AtomicHashMap<K, V> map = this.getDeltaMapForRead();
        return map == null ? Collections.EMPTY_SET : map.entrySet();
    }

    @Override
    public int size() {
        AtomicHashMap<K, V> map = this.getDeltaMapForRead();
        return map == null ? 0 : map.size();
    }

    @Override
    public boolean isEmpty() {
        AtomicHashMap<K, V> map = this.getDeltaMapForRead();
        return map == null ? true : map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        AtomicHashMap<K, V> map = this.getDeltaMapForRead();
        return map == null ? false : map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        AtomicHashMap<K, V> map = this.getDeltaMapForRead();
        return map == null ? false : map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        AtomicHashMap<K, V> map = this.getDeltaMapForRead();
        return map == null ? null : (V)map.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        try {
            this.startAtomic();
            InvocationContext ctx = this.icc.createInvocationContext();
            AtomicHashMap<K, V> deltaMapForWrite = this.getDeltaMapForWrite(ctx);
            V v = deltaMapForWrite.put(key, value);
            return v;
        }
        finally {
            this.endAtomic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        try {
            this.startAtomic();
            InvocationContext ic = this.icc.createInvocationContext();
            V v = this.getDeltaMapForWrite(ic).remove(key);
            return v;
        }
        finally {
            this.endAtomic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        try {
            this.startAtomic();
            InvocationContext ic = this.icc.createInvocationContext();
            this.getDeltaMapForWrite(ic).putAll(m);
        }
        finally {
            this.endAtomic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        try {
            this.startAtomic();
            InvocationContext ic = this.icc.createInvocationContext();
            this.getDeltaMapForWrite(ic).clear();
        }
        finally {
            this.endAtomic();
        }
    }

    public String toString() {
        return "AtomicHashMapProxy{deltaMapKey=" + this.deltaMapKey + '}';
    }
}

