/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.impl.ConfigurationProperties;
import org.infinispan.client.hotrod.impl.RemoteCacheImpl;
import org.infinispan.client.hotrod.impl.operations.OperationsFactory;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;
import org.infinispan.executors.ExecutorFactory;
import org.infinispan.manager.CacheContainer;
import org.infinispan.marshall.Marshaller;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class RemoteCacheManager
implements CacheContainer {
    private static final Log log = LogFactory.getLog(RemoteCacheManager.class);
    public static final String HOTROD_CLIENT_PROPERTIES = "hotrod-client.properties";
    ConfigurationProperties config;
    private TransportFactory transportFactory;
    private Marshaller marshaller;
    private boolean started = false;
    private boolean forceReturnValueDefault = false;
    private ExecutorService asyncExecutorService;
    private final Map<String, RemoteCacheImpl> cacheName2RemoteCache = new HashMap<String, RemoteCacheImpl>();
    private AtomicInteger topologyId = new AtomicInteger();

    public RemoteCacheManager(Marshaller marshaller, Properties props, boolean start) {
        this(props, start);
        this.setMarshaller(marshaller);
        if (log.isTraceEnabled()) {
            log.trace("Using explicitly set marshaller type: " + marshaller.getClass().getName());
        }
        if (start) {
            this.start();
        }
    }

    public RemoteCacheManager(Marshaller marshaller, Properties props) {
        this(marshaller, props, true);
    }

    public RemoteCacheManager(Properties props, boolean start) {
        this.config = new ConfigurationProperties(props);
        if (start) {
            this.start();
        }
    }

    public RemoteCacheManager(Properties props) {
        this(props, true);
    }

    public RemoteCacheManager(boolean start) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream stream = loader.getResourceAsStream(HOTROD_CLIENT_PROPERTIES);
        if (stream == null) {
            log.warn("Could not find 'hotrod-client.properties' file in classpath, using defaults.");
            this.config = new ConfigurationProperties();
        } else {
            this.loadFromStream(stream);
        }
        if (start) {
            this.start();
        }
    }

    public RemoteCacheManager() {
        this(true);
    }

    public RemoteCacheManager(String host, int port, boolean start) {
        this.config = new ConfigurationProperties(host + ":" + port);
        if (start) {
            this.start();
        }
    }

    public RemoteCacheManager(String host, int port) {
        this(host, port, true);
    }

    public RemoteCacheManager(String servers, boolean start) {
        this.config = new ConfigurationProperties(servers);
        if (start) {
            this.start();
        }
    }

    public RemoteCacheManager(String servers) {
        this(servers, true);
    }

    public RemoteCacheManager(URL config, boolean start) {
        try {
            this.loadFromStream(config.openStream());
        }
        catch (IOException e) {
            throw new HotRodClientException("Could not read URL:" + config, e);
        }
        if (start) {
            this.start();
        }
    }

    public RemoteCacheManager(URL config) {
        this(config, true);
    }

    public <K, V> RemoteCache<K, V> getCache(String cacheName) {
        return this.getCache(cacheName, this.forceReturnValueDefault);
    }

    public <K, V> RemoteCache<K, V> getCache(String cacheName, boolean forceReturnValue) {
        return this.createRemoteCache(cacheName, forceReturnValue);
    }

    public <K, V> RemoteCache<K, V> getCache() {
        return this.getCache(this.forceReturnValueDefault);
    }

    public <K, V> RemoteCache<K, V> getCache(boolean forceReturnValue) {
        return this.createRemoteCache("", forceReturnValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        String factory = this.config.getTransportFactory();
        this.transportFactory = (TransportFactory)Util.getInstance(factory);
        Collection<InetSocketAddress> servers = this.config.getServerList();
        this.transportFactory.start(this.config, servers, this.topologyId);
        if (this.marshaller == null) {
            String marshallerName = this.config.getMarshaller();
            this.setMarshaller((Marshaller)Util.getInstance(marshallerName));
        }
        String asyncExecutorClass = this.config.getAsyncExecutorFactory();
        ExecutorFactory executorFactory = (ExecutorFactory)Util.getInstance(asyncExecutorClass);
        this.asyncExecutorService = executorFactory.getExecutor(this.config.getProperties());
        this.forceReturnValueDefault = this.config.getForceReturnValues();
        Map<String, RemoteCacheImpl> map = this.cacheName2RemoteCache;
        synchronized (map) {
            for (RemoteCacheImpl remoteCache : this.cacheName2RemoteCache.values()) {
                this.startRemoteCache(remoteCache);
            }
        }
        this.started = true;
    }

    @Override
    public void stop() {
        if (this.isStarted()) {
            this.transportFactory.destroy();
        }
        this.started = false;
    }

    public boolean isStarted() {
        return this.started;
    }

    private void loadFromStream(InputStream stream) {
        Properties properties = new Properties();
        try {
            properties.load(stream);
        }
        catch (IOException e) {
            throw new HotRodClientException("Issues configuring from client hotrod-client.properties", e);
        }
        this.config = new ConfigurationProperties(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <K, V> RemoteCache<K, V> createRemoteCache(String cacheName, boolean forceReturnValue) {
        Map<String, RemoteCacheImpl> map = this.cacheName2RemoteCache;
        synchronized (map) {
            if (!this.cacheName2RemoteCache.containsKey(cacheName)) {
                RemoteCacheImpl result = new RemoteCacheImpl(this, cacheName);
                this.startRemoteCache(result);
                this.cacheName2RemoteCache.put(cacheName, result);
                return result;
            }
            return this.cacheName2RemoteCache.get(cacheName);
        }
    }

    private <K, V> void startRemoteCache(RemoteCacheImpl<K, V> result) {
        OperationsFactory operationsFactory = new OperationsFactory(this.transportFactory, result.getName(), this.topologyId, this.forceReturnValueDefault);
        result.init(this.marshaller, this.asyncExecutorService, operationsFactory, this.config.getKeySizeEstimate(), this.config.getValueSizeEstimate());
    }

    private void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }
}

