/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transport.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicLong;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.client.hotrod.impl.transport.AbstractTransport;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ThreadSafe
public class TcpTransport
extends AbstractTransport {
    private static AtomicLong ID_COUNTER = new AtomicLong(0L);
    private static final Log log = LogFactory.getLog(TcpTransport.class);
    private static final boolean trace = log.isTraceEnabled();
    private final Socket socket;
    private final InetSocketAddress serverAddress;
    private final long id = ID_COUNTER.incrementAndGet();

    public TcpTransport(InetSocketAddress serverAddress, TransportFactory transportFactory) {
        super(transportFactory);
        this.serverAddress = serverAddress;
        try {
            SocketChannel socketChannel = SocketChannel.open(serverAddress);
            this.socket = socketChannel.socket();
            this.socket.setTcpNoDelay(transportFactory.isTcpNoDelay());
        }
        catch (IOException e) {
            String message = "Could not connect to server: " + serverAddress;
            log.error((Object)message, e);
            throw new TransportException(message, e);
        }
    }

    @Override
    public void writeVInt(int vInt) {
        try {
            UnsignedNumeric.writeUnsignedInt(this.socket.getOutputStream(), vInt);
        }
        catch (IOException e) {
            throw new TransportException(e);
        }
    }

    @Override
    public void writeVLong(long l) {
        try {
            UnsignedNumeric.writeUnsignedLong(this.socket.getOutputStream(), l);
        }
        catch (IOException e) {
            throw new TransportException(e);
        }
    }

    @Override
    public long readVLong() {
        try {
            return UnsignedNumeric.readUnsignedLong(this.socket.getInputStream());
        }
        catch (IOException e) {
            throw new TransportException(e);
        }
    }

    @Override
    public int readVInt() {
        try {
            return UnsignedNumeric.readUnsignedInt(this.socket.getInputStream());
        }
        catch (IOException e) {
            throw new TransportException(e);
        }
    }

    @Override
    protected void writeBytes(byte[] toAppend) {
        try {
            this.socket.getOutputStream().write(toAppend);
            if (trace) {
                log.trace("Wrote " + toAppend.length + " bytes");
            }
        }
        catch (IOException e) {
            throw new TransportException("Problems writing data to stream", e);
        }
    }

    @Override
    public void writeByte(short toWrite) {
        try {
            this.socket.getOutputStream().write(toWrite);
            if (trace) {
                log.trace("Wrote byte " + toWrite);
            }
        }
        catch (IOException e) {
            throw new TransportException("Problems writing data to stream", e);
        }
    }

    @Override
    public void flush() {
        try {
            this.socket.getOutputStream().flush();
            if (trace) {
                log.trace("Flushed socket: " + this.socket);
            }
        }
        catch (IOException e) {
            throw new TransportException(e);
        }
    }

    @Override
    public short readByte() {
        int resultInt;
        try {
            resultInt = this.socket.getInputStream().read();
        }
        catch (IOException e) {
            throw new TransportException(e);
        }
        if (resultInt == -1) {
            throw new TransportException("End of stream reached!");
        }
        return (short)resultInt;
    }

    @Override
    public void release() {
        try {
            this.socket.close();
        }
        catch (IOException e) {
            log.warn("Issues closing socket:" + e.getMessage());
        }
    }

    @Override
    public byte[] readByteArray(int size) {
        byte[] result = new byte[size];
        boolean done = false;
        int offset = 0;
        do {
            int read;
            try {
                int len = size - offset;
                if (trace) {
                    log.trace("Offset: " + offset + ", len=" + len + ", size=" + size);
                }
                read = this.socket.getInputStream().read(result, offset, len);
            }
            catch (IOException e) {
                throw new TransportException(e);
            }
            if (read == -1) {
                throw new RuntimeException("End of stream reached!");
            }
            if (read + offset == size) {
                done = true;
                continue;
            }
            if ((offset += read) <= result.length) continue;
            throw new IllegalStateException("Assertion!");
        } while (!done);
        if (trace) {
            log.trace("Successfully read array with size: " + size);
        }
        return result;
    }

    public InetSocketAddress getServerAddress() {
        return this.serverAddress;
    }

    public String toString() {
        return "TcpTransport{socket=" + this.socket + ", serverAddress=" + this.serverAddress + ", id =" + this.id + "} ";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TcpTransport that = (TcpTransport)o;
        if (this.serverAddress != null ? !this.serverAddress.equals(that.serverAddress) : that.serverAddress != null) {
            return false;
        }
        return !(this.socket != null ? !this.socket.equals(that.socket) : that.socket != null);
    }

    public int hashCode() {
        int result = this.socket != null ? this.socket.hashCode() : 0;
        result = 31 * result + (this.serverAddress != null ? this.serverAddress.hashCode() : 0);
        return result;
    }

    public void destroy() {
        try {
            this.socket.close();
            if (trace) {
                log.trace("Successfully closed socket: " + this.socket);
            }
        }
        catch (IOException e) {
            log.warn((Object)("Issues closing transport: " + this), e);
        }
    }

    public boolean isValid() {
        return !this.socket.isClosed();
    }

    public long getId() {
        return this.id;
    }
}

