/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.distribution.TransactionLogger;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TransactionLoggerImpl
implements TransactionLogger {
    volatile boolean enabled;
    final ReadWriteLock loggingLock = new ReentrantReadWriteLock();
    final BlockingQueue<WriteCommand> commandQueue = new LinkedBlockingQueue<WriteCommand>();
    final Map<GlobalTransaction, PrepareCommand> uncommittedPrepares = new ConcurrentHashMap<GlobalTransaction, PrepareCommand>();
    private static final Log log = LogFactory.getLog(TransactionLoggerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final int DRAIN_LOCK_THRESHOLD = 10;

    @Override
    public void enable() {
        log.info("Starting transaction logging");
        this.enabled = true;
    }

    @Override
    public List<WriteCommand> drain() {
        LinkedList<WriteCommand> list = new LinkedList<WriteCommand>();
        this.commandQueue.drainTo(list);
        if (trace) {
            log.trace((Object)"Drained transaction log to {0}", list);
        }
        return list;
    }

    @Override
    public List<WriteCommand> drainAndLock() {
        this.loggingLock.writeLock().lock();
        return this.drain();
    }

    @Override
    public void unlockAndDisable() {
        this.enabled = false;
        Util.safeRelease(this.loggingLock.writeLock());
        log.info("Stopping transaction logging");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean logIfNeeded(WriteCommand command) {
        block6: {
            if (this.enabled) {
                this.loggingLock.readLock().lock();
                try {
                    if (!this.enabled) break block6;
                    try {
                        this.commandQueue.put(command);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    boolean bl = true;
                    return bl;
                }
                finally {
                    this.loggingLock.readLock().unlock();
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void logIfNeeded(PrepareCommand command) {
        if (command.isOnePhaseCommit()) {
            if (!this.enabled) return;
            this.loggingLock.readLock().lock();
            try {
                if (!this.enabled) return;
                if (trace) {
                    log.trace((Object)"Logging 1PC prepare for tx {0}", command.getGlobalTransaction());
                }
                this.logModificationsInTransaction(command);
                return;
            }
            finally {
                this.loggingLock.readLock().unlock();
            }
        } else {
            if (trace) {
                log.trace((Object)"Logging 2PC prepare for tx {0}", command.getGlobalTransaction());
            }
            this.uncommittedPrepares.put(command.getGlobalTransaction(), command);
        }
    }

    private void logModificationsInTransaction(PrepareCommand command) {
        for (WriteCommand wc : command.getModifications()) {
            try {
                this.commandQueue.put(wc);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logIfNeeded(CommitCommand command) {
        PrepareCommand pc = this.uncommittedPrepares.remove(command.getGlobalTransaction());
        if (this.enabled) {
            this.loggingLock.readLock().lock();
            try {
                if (this.enabled) {
                    if (trace) {
                        log.trace((Object)"Logging commit for tx {0}", command.getGlobalTransaction());
                    }
                    this.logModificationsInTransaction(pc);
                }
            }
            finally {
                this.loggingLock.readLock().unlock();
            }
        }
    }

    @Override
    public void logIfNeeded(RollbackCommand command) {
        if (trace) {
            log.trace((Object)"Logging rollback for tx {0}", command.getGlobalTransaction());
        }
        this.uncommittedPrepares.remove(command.getGlobalTransaction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean logIfNeeded(Collection<WriteCommand> commands) {
        if (this.enabled) {
            this.loggingLock.readLock().lock();
            try {
                if (this.enabled) {
                    for (WriteCommand command : commands) {
                        try {
                            this.commandQueue.put(command);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.loggingLock.readLock().unlock();
            }
        }
        return false;
    }

    private int size() {
        return this.enabled ? 0 : this.commandQueue.size();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean shouldDrainWithoutLock() {
        return this.size() > 10;
    }

    @Override
    public Collection<PrepareCommand> getPendingPrepares() {
        HashSet<PrepareCommand> commands = new HashSet<PrepareCommand>(this.uncommittedPrepares.values());
        this.uncommittedPrepares.clear();
        return commands;
    }
}

