/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.infinispan.CacheException;
import org.infinispan.Version;
import org.infinispan.config.Configuration;
import org.infinispan.config.ConfigurationException;
import org.infinispan.factories.AbstractComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.BootstrapFactory;
import org.infinispan.factories.DataContainerFactory;
import org.infinispan.factories.DistributionManagerFactory;
import org.infinispan.factories.EmptyConstructorFactory;
import org.infinispan.factories.EmptyConstructorNamedCacheFactory;
import org.infinispan.factories.InterceptorChainFactory;
import org.infinispan.factories.LockManagerFactory;
import org.infinispan.factories.MarshallerFactory;
import org.infinispan.factories.NamedComponentFactory;
import org.infinispan.factories.NamedExecutorsFactory;
import org.infinispan.factories.ReplicationQueueFactory;
import org.infinispan.factories.ResponseGeneratorFactory;
import org.infinispan.factories.RpcManagerFactory;
import org.infinispan.factories.StateTransferManagerFactory;
import org.infinispan.factories.TransactionManagerFactory;
import org.infinispan.factories.TransportFactory;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.lifecycle.Lifecycle;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.util.BeanUtils;
import org.infinispan.util.ModuleProperties;
import org.infinispan.util.ReflectionUtil;
import org.infinispan.util.logging.Log;

@SurvivesRestarts
@Scope(value=Scopes.NAMED_CACHE)
public abstract class AbstractComponentRegistry
implements Lifecycle,
Cloneable {
    public static final boolean DEBUG_DEPENDENCIES = false;
    private Stack<String> debugStack = null;
    private Map<Class, Class<? extends AbstractComponentFactory>> defaultFactories = null;
    protected static final Object NULL_COMPONENT = new Object();
    final Map<String, Component> componentLookup = new HashMap<String, Component>();
    protected static List<ModuleLifecycle> moduleLifecycles;
    volatile ComponentStatus state = ComponentStatus.INSTANTIATED;

    public ComponentStatus getStatus() {
        return this.state;
    }

    protected abstract Log getLog();

    public void wireDependencies(Object target) throws ConfigurationException {
        try {
            List<Method> methods = ReflectionUtil.getAllMethods(target.getClass(), Inject.class);
            for (Method method : methods) {
                this.invokeInjectionMethod(target, method);
            }
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to configure component (type: " + target.getClass() + ", instance " + target + ")", e);
        }
    }

    private Set<Class<? extends AbstractComponentFactory>> getHardcodedFactories() {
        HashSet<Class<? extends AbstractComponentFactory>> s = new HashSet<Class<? extends AbstractComponentFactory>>();
        s.add(BootstrapFactory.class);
        s.add(EmptyConstructorNamedCacheFactory.class);
        s.add(EmptyConstructorFactory.class);
        s.add(InterceptorChainFactory.class);
        s.add(RpcManagerFactory.class);
        s.add(TransactionManagerFactory.class);
        s.add(ReplicationQueueFactory.class);
        s.add(StateTransferManagerFactory.class);
        s.add(LockManagerFactory.class);
        s.add(DataContainerFactory.class);
        s.add(NamedExecutorsFactory.class);
        s.add(TransportFactory.class);
        s.add(MarshallerFactory.class);
        s.add(ResponseGeneratorFactory.class);
        s.add(DistributionManagerFactory.class);
        return s;
    }

    public void registerComponent(Object component, Class type) {
        this.registerComponent(component, type.getName());
    }

    public void registerComponent(Object component, String name) {
        Component c;
        if (component == null) {
            throw new NullPointerException("Cannot register a null component under name [" + name + "]");
        }
        Component old = this.componentLookup.get(name);
        if (old != null && old.instance.equals(component)) {
            this.getLog().trace((Object)"Attempting to register a component equal to one that already exists under the same name ({0}).  Not doing anything.", name);
            return;
        }
        if (old != null) {
            this.getLog().trace((Object)"Replacing old component {0} with new instance {1}", old, component);
            old.instance = component;
            old.methodsScanned = false;
            c = old;
            if (this.state == ComponentStatus.RUNNING) {
                this.populateLifecycleMethods();
            }
        } else {
            c = new Component();
            c.name = name;
            c.instance = component;
            this.componentLookup.put(name, c);
        }
        c.nonVolatile = ReflectionUtil.isAnnotationPresent(component.getClass(), SurvivesRestarts.class);
        this.addComponentDependencies(c);
        c.injectDependencies();
        if (old == null) {
            this.getLog().trace((Object)"Registering component {0} under name {1}", c, name);
        }
    }

    protected void addComponentDependencies(Component c) {
        Class<?> type = c.instance.getClass();
        List<Method> methods = ReflectionUtil.getAllMethods(type, Inject.class);
        c.injectionMethods.clear();
        c.injectionMethods.addAll(methods);
    }

    protected void invokeInjectionMethod(Object o, Method m) {
        Class<?>[] dependencies = m.getParameterTypes();
        Annotation[][] parameterAnnotations = m.getParameterAnnotations();
        Object[] params = new Object[dependencies.length];
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)"Injecting dependencies for method [{0}] on an instance of [{1}].", m, o.getClass().getName());
        }
        for (int i = 0; i < dependencies.length; ++i) {
            params[i] = this.getOrCreateComponent(dependencies[i], this.getComponentName(dependencies[i], parameterAnnotations, i));
        }
        ReflectionUtil.invokeAccessibly(o, m, params);
    }

    private String getComponentName(Class component, Annotation[][] annotations, int paramNumber) {
        String name;
        if (annotations == null || annotations.length <= paramNumber || (name = this.findComponentName(annotations[paramNumber])) == null) {
            return component.getName();
        }
        return name;
    }

    private String findComponentName(Annotation[] annotations) {
        if (annotations != null && annotations.length > 0) {
            for (Annotation a : annotations) {
                if (!(a instanceof ComponentName)) continue;
                return ((ComponentName)a).value();
            }
        }
        return null;
    }

    protected <T> T getOrCreateComponent(Class<T> componentClass) {
        return this.getOrCreateComponent(componentClass, componentClass.getName());
    }

    protected <T> T getOrCreateComponent(Class<T> componentClass, String name) {
        T component = this.getComponent(componentClass, name);
        if (component == null) {
            component = this.getFromConfiguration(componentClass);
            boolean attemptedFactoryConstruction = false;
            if (component == null) {
                AbstractComponentFactory factory = this.getFactory(componentClass);
                component = factory instanceof NamedComponentFactory ? ((NamedComponentFactory)factory).construct(componentClass, name) : factory.construct(componentClass);
                attemptedFactoryConstruction = true;
            }
            if (component != null) {
                this.registerComponent(component, componentClass);
            } else if (attemptedFactoryConstruction) {
                if (this.getLog().isTraceEnabled()) {
                    this.getLog().trace((Object)"Registering a null for component {0}", componentClass.getSimpleName());
                }
                this.registerNullComponent(componentClass);
            }
        }
        return component;
    }

    protected AbstractComponentFactory getFactory(Class componentClass) {
        Map<Class, Class<? extends AbstractComponentFactory>> defaultFactoryMap = this.getDefaultFactoryMap();
        Class<? extends AbstractComponentFactory> cfClass = defaultFactoryMap.get(componentClass);
        if (cfClass == null) {
            throw new ConfigurationException("No registered default factory for component '" + componentClass + "' found! Debug stack: " + this.debugStack);
        }
        AbstractComponentFactory cf = this.getComponent(cfClass);
        if (cf == null) {
            cf = this.instantiateFactory(cfClass);
            if (cf == null) {
                throw new ConfigurationException("Unable to locate component factory for component " + componentClass + "  Debug stack: " + this.debugStack);
            }
            this.registerComponent((Object)cf, cfClass);
        }
        Component c = this.lookupComponent(cfClass, cfClass.getName());
        if (c.instance != cf) {
            throw new ConfigurationException("Component factory " + cfClass + " incorrectly registered! Debug stack: " + this.debugStack);
        }
        return cf;
    }

    protected Component lookupComponent(Class type, String componentName) {
        return this.componentLookup.get(componentName);
    }

    protected Map<Class, Class<? extends AbstractComponentFactory>> getDefaultFactoryMap() {
        if (this.defaultFactories == null) {
            this.scanDefaultFactories();
        }
        return this.defaultFactories;
    }

    void scanDefaultFactories() {
        HashMap<Class, Class<? extends AbstractComponentFactory>> temp = new HashMap<Class, Class<? extends AbstractComponentFactory>>();
        Set<Class<? extends AbstractComponentFactory>> factories = this.getHardcodedFactories();
        for (Class<? extends AbstractComponentFactory> factory : factories) {
            boolean factoryValid = true;
            try {
                if (AutoInstantiableFactory.class.isAssignableFrom(factory) && factory.getConstructor(new Class[0]) == null) {
                    factoryValid = false;
                }
            }
            catch (Exception e) {
                factoryValid = false;
            }
            if (!factoryValid) {
                throw new RuntimeException("Factory class " + factory + " implements AutoInstantiableFactory but does not expose a public, no-arg constructor!  Debug stack: " + this.debugStack);
            }
            DefaultFactoryFor dFFAnnotation = factory.getAnnotation(DefaultFactoryFor.class);
            if (dFFAnnotation == null) continue;
            for (Class targetClass : dFFAnnotation.classes()) {
                temp.put(targetClass, factory);
            }
        }
        this.defaultFactories = temp;
    }

    AbstractComponentFactory instantiateFactory(Class<? extends AbstractComponentFactory> factory) {
        if (AutoInstantiableFactory.class.isAssignableFrom(factory)) {
            try {
                return factory.newInstance();
            }
            catch (Exception e) {
                throw new ConfigurationException("Unable to instantiate factory " + factory + "  Debug stack: " + this.debugStack, e);
            }
        }
        throw new ConfigurationException("Cannot auto-instantiate factory " + factory + " as it doesn't implement " + AutoInstantiableFactory.class.getSimpleName() + "!  Debug stack: " + this.debugStack);
    }

    void registerNullComponent(Class type) {
        this.registerComponent(NULL_COMPONENT, type);
    }

    protected <T> T getFromConfiguration(Class<T> componentClass) {
        this.getLog().debug((Object)"Looking in configuration for an instance of {0} that may have been injected from an external source.", componentClass);
        Method getter = BeanUtils.getterMethod(Configuration.class, componentClass);
        Object returnValue = null;
        if (getter != null) {
            try {
                returnValue = getter.invoke((Object)this.getConfiguration(), new Object[0]);
            }
            catch (Exception e) {
                this.getLog().warn((Object)"Unable to invoke getter {0} on Configuration.class!", e, getter);
            }
        }
        return (T)returnValue;
    }

    protected Configuration getConfiguration() {
        return this.getComponent(Configuration.class);
    }

    public <T> T getComponent(Class<T> type) {
        return this.getComponent(type, type.getName());
    }

    public <T> T getComponent(Class<T> type, String name) {
        Component wrapper = this.lookupComponent(type, name);
        if (wrapper == null) {
            return null;
        }
        return (T)(wrapper.instance == NULL_COMPONENT ? null : wrapper.instance);
    }

    public void registerDefaultClassLoader(ClassLoader loader) {
        this.registerComponent((Object)(loader == null ? this.getClass().getClassLoader() : loader), ClassLoader.class);
        this.componentLookup.get((Object)ClassLoader.class.getName()).nonVolatile = true;
    }

    public void rewire() {
        for (Component c : new HashSet<Component>(this.componentLookup.values())) {
            c.injectDependencies();
        }
    }

    private void populateLifecycleMethods() {
        for (Component c : this.componentLookup.values()) {
            PrioritizedMethod em;
            if (c.methodsScanned) continue;
            c.methodsScanned = true;
            c.startMethods.clear();
            c.stopMethods.clear();
            List<Method> methods = ReflectionUtil.getAllMethods(c.instance.getClass(), Start.class);
            for (Method m : methods) {
                em = new PrioritizedMethod();
                em.component = c;
                em.method = m;
                em.priority = m.getAnnotation(Start.class).priority();
                c.startMethods.add(em);
            }
            methods = ReflectionUtil.getAllMethods(c.instance.getClass(), Stop.class);
            for (Method m : methods) {
                em = new PrioritizedMethod();
                em.component = c;
                em.method = m;
                em.priority = m.getAnnotation(Stop.class).priority();
                c.stopMethods.add(em);
            }
        }
    }

    public void resetNonVolatile() {
        for (Component c : new HashSet<Component>(this.componentLookup.values())) {
            if (c.nonVolatile) continue;
            this.componentLookup.remove(c.name);
        }
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)"Reset volatile components.  Registry now contains {0}", this.componentLookup.keySet());
        }
    }

    @Override
    public void start() {
        if (!this.state.startAllowed()) {
            if (this.state.needToDestroyFailedCache()) {
                this.destroy();
            }
            if (this.state.needToInitializeBeforeStart()) {
                this.state = ComponentStatus.INITIALIZING;
                this.rewire();
            } else {
                return;
            }
        }
        try {
            this.internalStart();
        }
        catch (Throwable t) {
            this.handleLifecycleTransitionFailure(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (!this.state.stopAllowed()) {
            return;
        }
        boolean failed = this.state == ComponentStatus.FAILED;
        try {
            this.internalStop();
        }
        catch (Throwable t) {
            if (failed) {
                this.getLog().warn((Object)"Attempted to stop() from FAILED state, but caught exception; try calling destroy()", t);
            }
            failed = true;
            this.handleLifecycleTransitionFailure(t);
        }
        finally {
            if (!failed) {
                this.state = ComponentStatus.TERMINATED;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroy() {
        try {
            this.stop();
        }
        catch (CacheException e) {
            this.getLog().warn((Object)"Needed to call stop() before destroying but stop() threw exception. Proceeding to destroy", e);
        }
        try {
            this.resetNonVolatile();
        }
        finally {
            this.state = ComponentStatus.TERMINATED;
        }
    }

    private void handleLifecycleTransitionFailure(Throwable t) {
        this.state = ComponentStatus.FAILED;
        if (t.getCause() != null && t.getCause() instanceof ConfigurationException) {
            throw (ConfigurationException)t.getCause();
        }
        if (t.getCause() != null && t.getCause() instanceof InvocationTargetException && t.getCause().getCause() != null && t.getCause().getCause() instanceof ConfigurationException) {
            throw (ConfigurationException)t.getCause().getCause();
        }
        if (t instanceof CacheException) {
            throw (CacheException)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new CacheException(t);
    }

    private void internalStart() throws CacheException, IllegalArgumentException {
        this.populateLifecycleMethods();
        ArrayList<PrioritizedMethod> startMethods = new ArrayList<PrioritizedMethod>(this.componentLookup.size());
        for (Component c : this.componentLookup.values()) {
            startMethods.addAll(c.startMethods);
        }
        Collections.sort(startMethods);
        for (PrioritizedMethod em : startMethods) {
            em.invoke();
        }
        this.addShutdownHook();
        this.getLog().info("Infinispan version: " + Version.printVersion());
        this.state = ComponentStatus.RUNNING;
    }

    protected void addShutdownHook() {
    }

    protected void removeShutdownHook() {
    }

    private void internalStop() {
        this.state = ComponentStatus.STOPPING;
        this.removeShutdownHook();
        ArrayList<PrioritizedMethod> stopMethods = new ArrayList<PrioritizedMethod>(this.componentLookup.size());
        for (Component c : this.componentLookup.values()) {
            stopMethods.addAll(c.stopMethods);
        }
        Collections.sort(stopMethods);
        for (PrioritizedMethod em : stopMethods) {
            em.invoke();
        }
        this.destroy();
    }

    public boolean invocationsAllowed(boolean originLocal) {
        this.getLog().trace("Testing if invocations are allowed.");
        if (this.state.allowInvocations()) {
            return true;
        }
        if (originLocal) {
            return false;
        }
        this.getLog().trace("Is remotely originating.");
        if (this.state == ComponentStatus.INITIALIZING) {
            this.getLog().trace("Cache is initializing; block.");
            try {
                this.blockUntilCacheStarts();
                return true;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        } else {
            this.getLog().warn("Received a remote call but the cache is not in STARTED state - ignoring call.");
        }
        return false;
    }

    private void blockUntilCacheStarts() throws InterruptedException, IllegalStateException {
        int pollFrequencyMS = 100;
        long startupWaitTime = this.getConfiguration().getStateRetrievalTimeout();
        long giveUpTime = System.currentTimeMillis() + startupWaitTime;
        while (System.currentTimeMillis() < giveUpTime && !this.state.allowInvocations()) {
            Thread.sleep(pollFrequencyMS);
        }
        if (!this.state.allowInvocations()) {
            throw new IllegalStateException("Cache not in STARTED state, even after waiting " + this.getConfiguration().getStateRetrievalTimeout() + " millis.");
        }
    }

    public Set<Component> getRegisteredComponents() {
        HashSet<Component> defensiveCopy = new HashSet<Component>(this.componentLookup.values());
        return Collections.unmodifiableSet(defensiveCopy);
    }

    public AbstractComponentRegistry clone() throws CloneNotSupportedException {
        AbstractComponentRegistry dolly = (AbstractComponentRegistry)super.clone();
        dolly.state = ComponentStatus.INSTANTIATED;
        return dolly;
    }

    static {
        try {
            moduleLifecycles = ModuleProperties.resolveModuleLifecycles();
        }
        catch (Exception e) {
            moduleLifecycles = Collections.emptyList();
        }
    }

    static class PrioritizedMethod
    implements Comparable<PrioritizedMethod> {
        Method method;
        Component component;
        int priority;

        PrioritizedMethod() {
        }

        @Override
        public int compareTo(PrioritizedMethod o) {
            return this.priority < o.priority ? -1 : (this.priority == o.priority ? 0 : 1);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PrioritizedMethod)) {
                return false;
            }
            PrioritizedMethod that = (PrioritizedMethod)o;
            if (this.priority != that.priority) {
                return false;
            }
            if (this.component != null ? !this.component.equals(that.component) : that.component != null) {
                return false;
            }
            return !(this.method != null ? !this.method.equals(that.method) : that.method != null);
        }

        public int hashCode() {
            int result = this.method != null ? this.method.hashCode() : 0;
            result = 31 * result + (this.component != null ? this.component.hashCode() : 0);
            result = 31 * result + this.priority;
            return result;
        }

        void invoke() {
            ReflectionUtil.invokeAccessibly(this.component.instance, this.method, null);
        }

        public String toString() {
            return "PrioritizedMethod{method=" + this.method + ", priority=" + this.priority + '}';
        }
    }

    public class Component {
        Object instance;
        String name;
        boolean methodsScanned;
        List<Method> injectionMethods = new ArrayList<Method>(2);
        List<PrioritizedMethod> startMethods = new ArrayList<PrioritizedMethod>(2);
        List<PrioritizedMethod> stopMethods = new ArrayList<PrioritizedMethod>(2);
        boolean nonVolatile;

        public String toString() {
            return "Component{instance=" + this.instance + ", name=" + this.name + ", nonVolatile=" + this.nonVolatile + '}';
        }

        public void injectDependencies() {
            for (Method m : this.injectionMethods) {
                AbstractComponentRegistry.this.invokeInjectionMethod(this.instance, m);
            }
        }

        public Object getInstance() {
            return this.instance;
        }

        public String getName() {
            return this.name;
        }
    }
}

