/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall;

import java.io.IOException;
import org.infinispan.io.ByteBuffer;
import org.infinispan.marshall.Marshaller;

public abstract class AbstractMarshaller
implements Marshaller {
    protected static final int DEFAULT_BUF_SIZE = 512;

    protected abstract ByteBuffer objectToBuffer(Object var1, int var2) throws IOException;

    @Override
    public ByteBuffer objectToBuffer(Object obj) throws IOException {
        return this.objectToBuffer(obj, 512);
    }

    @Override
    public byte[] objectToByteBuffer(Object o) throws IOException {
        return this.objectToByteBuffer(o, 512);
    }

    @Override
    public byte[] objectToByteBuffer(Object obj, int estimatedSize) throws IOException {
        ByteBuffer b = this.objectToBuffer(obj, estimatedSize);
        byte[] bytes = new byte[b.getLength()];
        System.arraycopy(b.getBuf(), b.getOffset(), bytes, 0, b.getLength());
        return bytes;
    }

    @Override
    public Object objectFromByteBuffer(byte[] buf) throws IOException, ClassNotFoundException {
        return this.objectFromByteBuffer(buf, 0, buf.length);
    }
}

