/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.jboss;

import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import org.infinispan.CacheException;
import org.infinispan.io.ByteBuffer;
import org.infinispan.io.ExposedByteArrayOutputStream;
import org.infinispan.marshall.AbstractMarshaller;
import org.infinispan.marshall.jboss.JBossMarshaller;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.jboss.marshalling.ContextClassResolver;
import org.jboss.marshalling.ExceptionListener;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.TraceInformation;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.reflect.SunReflectiveCreator;

public class GenericJBossMarshaller
extends AbstractMarshaller {
    protected static final Log log = LogFactory.getLog(JBossMarshaller.class);
    protected static final String DEFAULT_MARSHALLER_FACTORY = "org.jboss.marshalling.river.RiverMarshallerFactory";
    protected ClassLoader defaultCl = this.getClass().getClassLoader();
    protected MarshallingConfiguration configuration;
    protected MarshallerFactory factory;
    private ThreadLocal<Marshaller> marshallerTL = new ThreadLocal<Marshaller>(){

        @Override
        protected Marshaller initialValue() {
            try {
                return GenericJBossMarshaller.this.factory.createMarshaller(GenericJBossMarshaller.this.configuration);
            }
            catch (IOException e) {
                throw new CacheException(e);
            }
        }
    };
    private ThreadLocal<Unmarshaller> unmarshallerTL = new ThreadLocal<Unmarshaller>(){

        @Override
        protected Unmarshaller initialValue() {
            try {
                return GenericJBossMarshaller.this.factory.createUnmarshaller(GenericJBossMarshaller.this.configuration);
            }
            catch (IOException e) {
                throw new CacheException(e);
            }
        }
    };

    public GenericJBossMarshaller() {
        this.factory = (MarshallerFactory)Util.getInstance(DEFAULT_MARSHALLER_FACTORY);
        this.configuration = new MarshallingConfiguration();
        this.configuration.setCreator(new SunReflectiveCreator());
        this.configuration.setExceptionListener(new DebuggingExceptionListener());
        this.configuration.setClassResolver(new ContextClassResolver());
        this.configuration.setVersion(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void objectToObjectStream(Object obj, ObjectOutput out) throws IOException {
        ClassLoader toUse = this.defaultCl;
        Thread current = Thread.currentThread();
        ClassLoader old = current.getContextClassLoader();
        if (old != null) {
            toUse = old;
        }
        try {
            current.setContextClassLoader(toUse);
            out.writeObject(obj);
        }
        finally {
            current.setContextClassLoader(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ByteBuffer objectToBuffer(Object o, int estimatedSize) throws IOException {
        ExposedByteArrayOutputStream baos = new ExposedByteArrayOutputStream(estimatedSize);
        ObjectOutput marshaller = this.startObjectOutput(baos, false);
        try {
            this.objectToObjectStream(o, marshaller);
        }
        finally {
            this.finishObjectOutput(marshaller);
        }
        return new ByteBuffer(baos.getRawBuffer(), 0, baos.size());
    }

    public ObjectOutput startObjectOutput(OutputStream os, boolean isReentrant) throws IOException {
        Marshaller marshaller = isReentrant ? this.factory.createMarshaller(this.configuration) : this.marshallerTL.get();
        marshaller.start(Marshalling.createByteOutput(os));
        return marshaller;
    }

    public void finishObjectOutput(ObjectOutput oo) {
        try {
            ((Marshaller)oo).finish();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object objectFromByteBuffer(byte[] buf, int offset, int length) throws IOException, ClassNotFoundException {
        ByteArrayInputStream is = new ByteArrayInputStream(buf, offset, length);
        ObjectInput unmarshaller = this.startObjectInput(is, false);
        Object o = null;
        try {
            o = this.objectFromObjectStream(unmarshaller);
        }
        finally {
            this.finishObjectInput(unmarshaller);
        }
        return o;
    }

    public ObjectInput startObjectInput(InputStream is, boolean isReentrant) throws IOException {
        Unmarshaller unmarshaller = isReentrant ? this.factory.createUnmarshaller(this.configuration) : this.unmarshallerTL.get();
        unmarshaller.start(Marshalling.createByteInput(is));
        return unmarshaller;
    }

    public Object objectFromObjectStream(ObjectInput in) throws IOException, ClassNotFoundException {
        return in.readObject();
    }

    public void finishObjectInput(ObjectInput oi) {
        try {
            if (oi != null) {
                ((Unmarshaller)oi).finish();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean isMarshallable(Object o) {
        return o instanceof Serializable || o instanceof Externalizable;
    }

    protected static class DebuggingExceptionListener
    implements ExceptionListener {
        private static final URL[] EMPTY_URLS = new URL[0];
        private static final Class[] EMPTY_CLASSES = new Class[0];
        private static final Object[] EMPTY_OBJECTS = new Object[0];

        protected DebuggingExceptionListener() {
        }

        @Override
        public void handleMarshallingException(Throwable problem, Object subject) {
            if (log.isDebugEnabled()) {
                TraceInformation.addUserInformation(problem, (Serializable)((Object)("toString = " + subject.toString())));
            }
        }

        @Override
        public void handleUnmarshallingException(Throwable problem, Class<?> subjectClass) {
            if (log.isDebugEnabled()) {
                StringBuilder builder = new StringBuilder();
                ClassLoader cl = subjectClass.getClassLoader();
                builder.append("classloader hierarchy:");
                for (ClassLoader parent = cl; parent != null; parent = parent.getParent()) {
                    if (parent.equals(cl)) {
                        builder.append("\n\t\t-> type classloader = ").append(parent);
                    } else {
                        builder.append("\n\t\t-> parent classloader = ").append(parent);
                    }
                    URL[] urls = DebuggingExceptionListener.getClassLoaderURLs(parent);
                    if (urls == null) continue;
                    for (URL u : urls) {
                        builder.append("\n\t\t->...").append(u);
                    }
                }
                TraceInformation.addUserInformation(problem, (Serializable)((Object)builder.toString()));
            }
        }

        @Override
        public void handleUnmarshallingException(Throwable problem) {
        }

        private static URL[] getClassLoaderURLs(ClassLoader cl) {
            URL[] urls = EMPTY_URLS;
            try {
                Class<?> returnType = urls.getClass();
                Class[] parameterTypes = EMPTY_CLASSES;
                Method getURLs = cl.getClass().getMethod("getURLs", parameterTypes);
                if (returnType.isAssignableFrom(getURLs.getReturnType())) {
                    Object[] args = EMPTY_OBJECTS;
                    urls = (URL[])getURLs.invoke((Object)cl, args);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return urls;
        }
    }
}

