/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.jboss;

import java.io.IOException;
import java.io.InputStream;
import org.infinispan.commands.RemoteCommandsFactory;
import org.infinispan.io.ExposedByteArrayOutputStream;
import org.infinispan.marshall.Marshallable;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.marshall.jboss.ConstantObjectTable;
import org.infinispan.marshall.jboss.GenericJBossMarshaller;
import org.infinispan.util.ReflectionUtil;

public class JBossMarshaller
extends GenericJBossMarshaller
implements StreamingMarshaller {
    private ConstantObjectTable objectTable;

    public void start(ClassLoader defaultCl, RemoteCommandsFactory cmdFactory, StreamingMarshaller ispnMarshaller) {
        if (log.isDebugEnabled()) {
            log.debug("Using JBoss Marshalling");
        }
        this.defaultCl = defaultCl;
        this.objectTable = this.createCustomObjectTable(cmdFactory, ispnMarshaller);
        this.configuration.setObjectTable(this.objectTable);
    }

    public void stop() {
        this.defaultCl = null;
        if (this.objectTable != null) {
            this.objectTable.stop();
        }
    }

    @Override
    public Object objectFromInputStream(InputStream inputStream) throws IOException, ClassNotFoundException {
        int bytesRead;
        ExposedByteArrayOutputStream bytes = new ExposedByteArrayOutputStream(512);
        byte[] buf = new byte[Math.min(512, 1024)];
        while ((bytesRead = inputStream.read(buf, 0, buf.length)) != -1) {
            bytes.write(buf, 0, bytesRead);
        }
        return this.objectFromByteBuffer(bytes.getRawBuffer(), 0, bytes.size());
    }

    @Override
    public boolean isMarshallable(Object o) {
        return super.isMarshallable(o) || ReflectionUtil.isAnnotationPresent(o.getClass(), Marshallable.class);
    }

    private ConstantObjectTable createCustomObjectTable(RemoteCommandsFactory cmdFactory, StreamingMarshaller ispnMarshaller) {
        ConstantObjectTable objectTable = new ConstantObjectTable();
        objectTable.start(cmdFactory, ispnMarshaller);
        return objectTable;
    }
}

