/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.xa;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import javax.transaction.Transaction;
import org.infinispan.CacheException;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.config.Configuration;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.MembershipArithmetic;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.GlobalTransactionFactory;
import org.infinispan.transaction.xa.RemoteTransaction;
import org.infinispan.transaction.xa.TransactionXaAdapter;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TransactionTable {
    private static final Log log = LogFactory.getLog(TransactionTable.class);
    private static boolean trace = log.isTraceEnabled();
    private final Map<Transaction, TransactionXaAdapter> localTransactions = new HashMap<Transaction, TransactionXaAdapter>();
    private final Map<GlobalTransaction, RemoteTransaction> remoteTransactions = new HashMap<GlobalTransaction, RemoteTransaction>();
    private CommandsFactory commandsFactory;
    private Configuration configuration;
    private InvocationContextContainer icc;
    private InterceptorChain invoker;
    private CacheNotifier notifier;
    private RpcManager rpcManager;
    private GlobalTransactionFactory gtf;
    private ExecutorService lockBreakingService = Executors.newFixedThreadPool(1);
    private EmbeddedCacheManager cm;

    @Inject
    public void initialize(CommandsFactory commandsFactory, RpcManager rpcManager, Configuration configuration, InvocationContextContainer icc, InterceptorChain invoker, CacheNotifier notifier, GlobalTransactionFactory gtf, EmbeddedCacheManager cm) {
        this.commandsFactory = commandsFactory;
        this.rpcManager = rpcManager;
        this.configuration = configuration;
        this.icc = icc;
        this.invoker = invoker;
        this.notifier = notifier;
        this.gtf = gtf;
        this.cm = cm;
    }

    @Start
    private void start() {
        this.cm.addListener(new StaleTransactionCleanup());
    }

    @Stop
    private void stop() {
        this.lockBreakingService.shutdownNow();
    }

    public RemoteTransaction getRemoteTransaction(GlobalTransaction txId) {
        return this.remoteTransactions.get(txId);
    }

    public RemoteTransaction createRemoteTransaction(GlobalTransaction globalTx, WriteCommand[] modifications) {
        RemoteTransaction remoteTransaction = new RemoteTransaction(modifications, globalTx);
        this.registerRemoteTransaction(globalTx, remoteTransaction);
        return remoteTransaction;
    }

    public RemoteTransaction createRemoteTransaction(GlobalTransaction globalTx) {
        RemoteTransaction remoteTransaction = new RemoteTransaction(globalTx);
        this.registerRemoteTransaction(globalTx, remoteTransaction);
        return remoteTransaction;
    }

    private void registerRemoteTransaction(GlobalTransaction gtx, RemoteTransaction rtx) {
        RemoteTransaction transaction = this.remoteTransactions.put(gtx, rtx);
        if (transaction != null) {
            String message = "A remote transaction with the given id was already registered!!!";
            log.error(message);
            throw new IllegalStateException(message);
        }
        if (trace) {
            log.trace("Created and registered remote transaction " + rtx);
        }
    }

    public TransactionXaAdapter getOrCreateXaAdapter(Transaction transaction, InvocationContext ctx) {
        TransactionXaAdapter current = this.localTransactions.get(transaction);
        if (current == null) {
            Address localAddress = this.rpcManager != null ? this.rpcManager.getTransport().getAddress() : null;
            GlobalTransaction tx = this.gtf.newGlobalTransaction(localAddress, false);
            if (trace) {
                log.trace((Object)"Created a new GlobalTransaction {0}", tx);
            }
            current = new TransactionXaAdapter(tx, this.icc, this.invoker, this.commandsFactory, this.configuration, this, transaction);
            this.localTransactions.put(transaction, current);
            try {
                transaction.enlistResource(current);
            }
            catch (Exception e) {
                log.error("Failed to enlist TransactionXaAdapter to transaction");
                throw new CacheException(e);
            }
            this.notifier.notifyTransactionRegistered(tx, ctx);
        }
        return current;
    }

    public boolean removeLocalTransaction(Transaction tx) {
        return this.localTransactions.remove(tx) != null;
    }

    public boolean removeRemoteTransaction(GlobalTransaction txId) {
        boolean existed;
        boolean bl = existed = this.remoteTransactions.remove(txId) != null;
        if (trace) {
            log.trace("Removed " + txId + " from transaction table. Returning " + existed);
        }
        return existed;
    }

    public int getRemoteTxCount() {
        return this.remoteTransactions.size();
    }

    public int getLocalTxCount() {
        return this.localTransactions.size();
    }

    public TransactionXaAdapter getXaCacheAdapter(Transaction tx) {
        return this.localTransactions.get(tx);
    }

    public boolean containRemoteTx(GlobalTransaction globalTransaction) {
        return this.remoteTransactions.containsKey(globalTransaction);
    }

    @Listener
    public class StaleTransactionCleanup {
        @ViewChanged
        public void onViewChange(ViewChangedEvent vce) {
            final List<Address> leavers = MembershipArithmetic.getMembersLeft(vce.getOldMembers(), vce.getNewMembers());
            if (!leavers.isEmpty()) {
                if (trace) {
                    log.trace((Object)"Saw {0} leavers - kicking off a lock breaking task", leavers.size());
                }
                try {
                    TransactionTable.this.lockBreakingService.submit(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            HashSet<GlobalTransaction> toKill = new HashSet<GlobalTransaction>();
                            for (GlobalTransaction gt : TransactionTable.this.remoteTransactions.keySet()) {
                                if (!leavers.contains(gt.getAddress())) continue;
                                toKill.add(gt);
                            }
                            if (trace) {
                                log.trace((Object)"Global transactions {0} pertain to leavers list {1} and need to be killed", toKill, leavers);
                            }
                            for (GlobalTransaction gtx : toKill) {
                                if (trace) {
                                    log.trace((Object)"Killing {0}", gtx);
                                }
                                RollbackCommand rc = new RollbackCommand(gtx);
                                rc.init(TransactionTable.this.invoker, TransactionTable.this.icc, TransactionTable.this);
                                try {
                                    rc.perform(null);
                                }
                                catch (Throwable e) {
                                    log.warn((Object)("Unable to roll back gtx " + gtx), e);
                                }
                                finally {
                                    TransactionTable.this.removeRemoteTransaction(gtx);
                                }
                            }
                        }
                    });
                }
                catch (RejectedExecutionException ree) {
                    log.debug((Object)"Unable to submit task to executor", ree);
                }
            }
        }
    }
}

