/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FieldSetter {
    private final Field field;

    private FieldSetter(Field field) {
        this.field = field;
    }

    public void set(Object instance, Object value) throws IllegalArgumentException {
        try {
            this.field.set(instance, value);
        }
        catch (IllegalAccessException e) {
            throw this.illegalState(e);
        }
    }

    public void setBoolean(Object instance, boolean value) throws IllegalArgumentException {
        try {
            this.field.setBoolean(instance, value);
        }
        catch (IllegalAccessException e) {
            throw this.illegalState(e);
        }
    }

    public void setByte(Object instance, byte value) throws IllegalArgumentException {
        try {
            this.field.setByte(instance, value);
        }
        catch (IllegalAccessException e) {
            throw this.illegalState(e);
        }
    }

    public void setChar(Object instance, char value) throws IllegalArgumentException {
        try {
            this.field.setChar(instance, value);
        }
        catch (IllegalAccessException e) {
            throw this.illegalState(e);
        }
    }

    public void setDouble(Object instance, double value) throws IllegalArgumentException {
        try {
            this.field.setDouble(instance, value);
        }
        catch (IllegalAccessException e) {
            throw this.illegalState(e);
        }
    }

    public void setFloat(Object instance, float value) throws IllegalArgumentException {
        try {
            this.field.setFloat(instance, value);
        }
        catch (IllegalAccessException e) {
            throw this.illegalState(e);
        }
    }

    public void setInt(Object instance, int value) throws IllegalArgumentException {
        try {
            this.field.setInt(instance, value);
        }
        catch (IllegalAccessException e) {
            throw this.illegalState(e);
        }
    }

    public void setLong(Object instance, long value) throws IllegalArgumentException {
        try {
            this.field.setLong(instance, value);
        }
        catch (IllegalAccessException e) {
            throw this.illegalState(e);
        }
    }

    public void setShort(Object instance, short value) throws IllegalArgumentException {
        try {
            this.field.setShort(instance, value);
        }
        catch (IllegalAccessException e) {
            throw this.illegalState(e);
        }
    }

    private IllegalStateException illegalState(IllegalAccessException e) {
        return new IllegalStateException("Unexpected illegal access of accessible field", e);
    }

    public static FieldSetter get(Class<?> clazz, String name) throws SecurityException, IllegalArgumentException {
        Class[] stackTrace = Holder.STACK_TRACE_READER.getClassContext();
        if (stackTrace[2] != clazz) {
            throw new SecurityException("Cannot get accessible field from someone else's class");
        }
        return new FieldSetter(AccessController.doPrivileged(new GetFieldAction(clazz, name)));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetFieldAction
    implements PrivilegedAction<Field> {
        private final Class<?> clazz;
        private final String name;

        private GetFieldAction(Class<?> clazz, String name) {
            this.clazz = clazz;
            this.name = name;
        }

        @Override
        public Field run() {
            try {
                Field field = this.clazz.getDeclaredField(this.name);
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers)) {
                    throw new SecurityException("Cannot get access to static field '" + this.name + "'");
                }
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException e) {
                throw new IllegalArgumentException("No such field '" + this.name + "'", e);
            }
        }
    }

    private static final class Holder {
        static final StackTraceReader STACK_TRACE_READER = AccessController.doPrivileged(new PrivilegedAction<StackTraceReader>(){

            @Override
            public StackTraceReader run() {
                return new StackTraceReader();
            }
        });

        private Holder() {
        }

        static final class StackTraceReader
        extends SecurityManager {
            StackTraceReader() {
            }

            protected Class[] getClassContext() {
                return super.getClassContext();
            }
        }
    }
}

