/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.infinispan;

import java.util.Set;
import org.apache.log4j.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.infinispan.Cache;
import org.infinispan.manager.DefaultCacheManager;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.modeshape.connector.infinispan.InfinispanSource;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Node;
import org.modeshape.graph.Workspace;
import org.modeshape.graph.connector.MockRepositoryContext;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.property.PathNotFoundException;

public class InfinispanClusterTest {
    private static final String CONFIG_FILE = "./src/test/resources/infinispan_clustered_config.xml";
    private final ExecutionContext context = new ExecutionContext();

    @Test
    public void shouldWorkAndDoes() throws Exception {
        DefaultCacheManager manager1 = new DefaultCacheManager(CONFIG_FILE);
        Cache cache1 = manager1.getCache("cache");
        DefaultCacheManager manager2 = new DefaultCacheManager(CONFIG_FILE);
        Cache cache2 = manager2.getCache("cache");
        cache1.put((Object)"key1", (Object)"value1");
        cache1.put((Object)"key2", (Object)"value2");
        String v1 = (String)cache2.get((Object)"key1");
        String v2 = (String)cache2.get((Object)"key2");
        Assert.assertThat((Object)v1, (Matcher)CoreMatchers.is((Object)"value1"));
        Assert.assertThat((Object)v2, (Matcher)CoreMatchers.is((Object)"value2"));
        Logger.getLogger(this.getClass()).info((Object)"*** Getting ready to create 'new-cache' programmatically");
        manager1.defineConfiguration("new-cache", manager1.getDefaultConfiguration());
        Cache cache1b = manager1.getCache("new-cache");
        manager2.defineConfiguration("new-cache", manager2.getDefaultConfiguration());
        Cache cache2b = manager2.getCache("new-cache");
        Logger.getLogger(this.getClass()).info((Object)"*** Getting ready to insert entry into 'new-cache'");
        cache1b.put((Object)"key1b", (Object)"value1b");
        Logger.getLogger(this.getClass()).info((Object)"*** Getting ready to find 'new-cache' from second manager");
        String v1b = (String)cache2b.get((Object)"key1b");
        Assert.assertThat((Object)v1b, (Matcher)CoreMatchers.is((Object)"value1b"));
        manager1.stop();
        manager2.stop();
    }

    @Ignore
    @Test
    public void shouldWorkButDoesNot() throws Exception {
        DefaultCacheManager manager1 = new DefaultCacheManager(CONFIG_FILE);
        Cache cache1 = manager1.getCache("cache");
        DefaultCacheManager manager2 = new DefaultCacheManager(CONFIG_FILE);
        Cache cache2 = manager2.getCache("cache");
        cache1.put((Object)"key1", (Object)"value1");
        cache1.put((Object)"key2", (Object)"value2");
        String v1 = (String)cache2.get((Object)"key1");
        String v2 = (String)cache2.get((Object)"key2");
        Assert.assertThat((Object)v1, (Matcher)CoreMatchers.is((Object)"value1"));
        Assert.assertThat((Object)v2, (Matcher)CoreMatchers.is((Object)"value2"));
        Logger.getLogger(this.getClass()).info((Object)"*** Getting ready to create 'new-cache' programmatically");
        manager1.defineConfiguration("new-cache", manager1.getDefaultConfiguration());
        Cache cache1b = manager1.getCache("new-cache");
        Logger.getLogger(this.getClass()).info((Object)"*** Getting ready to insert entry into 'new-cache'");
        cache1b.put((Object)"key1b", (Object)"value1b");
        Logger.getLogger(this.getClass()).info((Object)"*** Getting ready to find 'new-cache' from second manager");
        manager2.defineConfiguration("new-cache", manager2.getDefaultConfiguration());
        Cache cache2b = manager2.getCache("new-cache");
        String v1b = (String)cache2b.get((Object)"key1b");
        Assert.assertThat((Object)v1b, (Matcher)CoreMatchers.is((Object)"value1b"));
        manager1.stop();
        manager2.stop();
    }

    @Test
    public void shouldDistributeGraphNodesUsingPredefinedWorkspaces() {
        InfinispanSource source1 = new InfinispanSource();
        source1.setName("source1");
        source1.setCacheConfigurationName(CONFIG_FILE);
        source1.initialize(this.repositoryContextFor((RepositorySource)source1));
        InfinispanSource source2 = new InfinispanSource();
        source2.setName("source2");
        source2.setCacheConfigurationName(CONFIG_FILE);
        source2.initialize(this.repositoryContextFor((RepositorySource)source2));
        Graph graph1 = Graph.create((RepositorySource)source1, (ExecutionContext)this.context);
        Graph graph2 = Graph.create((RepositorySource)source2, (ExecutionContext)this.context);
        Assert.assertThat((Object)source1.getRootNodeUuid(), (Matcher)CoreMatchers.is((Object)source2.getRootNodeUuid()));
        Node root1 = graph1.getNodeAt("/");
        Node root2 = graph2.getNodeAt("/");
        Assert.assertThat((Object)root1.getLocation(), (Matcher)CoreMatchers.is((Object)root2.getLocation()));
        graph1.create("/foo").and();
        Cache cache1 = source1.cacheContainer().getCache("");
        Cache cache2 = source2.cacheContainer().getCache("");
        Assert.assertThat((Object)cache1.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)cache2.size(), (Matcher)CoreMatchers.is((Object)2));
        graph2.getNodeAt("/foo");
        graph2.delete("/foo");
        try {
            Thread.sleep(5000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            graph1.getNodeAt("/foo");
            Assert.fail((String)"/foo was deleted by the other source and should no longer exist");
        }
        catch (PathNotFoundException expected) {
            // empty catch block
        }
    }

    @Ignore
    @Test
    public void shouldDistributeGraphNodesUsingDynamicallyCreatedWorkspaces() {
        InfinispanSource source1 = new InfinispanSource();
        source1.setName("source1");
        source1.setCacheConfigurationName(CONFIG_FILE);
        source1.initialize(this.repositoryContextFor((RepositorySource)source1));
        InfinispanSource source2 = new InfinispanSource();
        source2.setName("source2");
        source2.setCacheConfigurationName(CONFIG_FILE);
        source2.initialize(this.repositoryContextFor((RepositorySource)source2));
        Graph graph1 = Graph.create((RepositorySource)source1, (ExecutionContext)this.context);
        Graph graph2 = Graph.create((RepositorySource)source2, (ExecutionContext)this.context);
        Assert.assertThat((Object)source1.getRootNodeUuid(), (Matcher)CoreMatchers.is((Object)source2.getRootNodeUuid()));
        Node root1 = graph1.getNodeAt("/");
        Node root2 = graph2.getNodeAt("/");
        Assert.assertThat((Object)root1.getLocation(), (Matcher)CoreMatchers.is((Object)root2.getLocation()));
        graph1.create("/foo").and();
        Cache cache1 = source1.cacheContainer().getCache("");
        Cache cache2 = source2.cacheContainer().getCache("");
        Assert.assertThat((Object)cache1.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)cache2.size(), (Matcher)CoreMatchers.is((Object)2));
        graph2.getNodeAt("/foo");
        graph2.delete("/foo");
        try {
            Thread.sleep(5000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            graph1.getNodeAt("/foo");
            Assert.fail((String)"/foo was deleted by the other source and should no longer exist");
        }
        catch (PathNotFoundException expected) {
            // empty catch block
        }
        Workspace nfws1 = graph1.createWorkspace().named("new-fangled-workspace");
        Set workspaces1 = graph1.getWorkspaces();
        Set workspaces2 = graph2.getWorkspaces();
        Assert.assertThat((Object)workspaces1, (Matcher)CoreMatchers.is((Object)workspaces2));
        Workspace nfws2 = graph2.useWorkspace(nfws1.getName());
        Assert.assertThat((Object)nfws1.getRoot(), (Matcher)CoreMatchers.is((Object)nfws2.getRoot()));
    }

    private final RepositoryContext repositoryContextFor(RepositorySource source) {
        return new MockRepositoryContext(this.context, source);
    }
}

