/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.async;

import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.executors.ExecutorFactory;
import org.infinispan.util.TypedProperties;

public class DefaultAsyncExecutorFactory
implements ExecutorFactory {
    public static final String THREAD_NAME = "HotRod-client-async-pool";
    public static final AtomicInteger counter = new AtomicInteger(0);
    private int poolSize = 10;
    private int queueSize = 100000;

    @Override
    public ExecutorService getExecutor(Properties p) {
        this.readParams(p);
        ThreadFactory tf = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread th = new Thread(r, "HotRod-client-async-pool-" + counter.getAndIncrement());
                th.setDaemon(true);
                return th;
            }
        };
        return new ThreadPoolExecutor(this.poolSize, this.poolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(this.queueSize), tf);
    }

    private void readParams(Properties props) {
        TypedProperties tp = TypedProperties.toTypedProperties(props);
        this.poolSize = tp.getIntProperty("infinispan.client.hotrod.default_executor_factory.pool_size", 10);
        this.queueSize = tp.getIntProperty("infinispan.client.hotrod.default_executor_factory.queue_size", 100000);
    }
}

