/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.consistenthash;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.client.hotrod.impl.ConfigurationProperties;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHash;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ConsistentHashFactory {
    private static final Log log = LogFactory.getLog(ConsistentHashFactory.class);
    private final Map<Integer, String> version2ConsistentHash = new HashMap<Integer, String>();

    public void init(ConfigurationProperties config) {
        for (String propName : config.getProperties().stringPropertyNames()) {
            if (!propName.startsWith("infinispan.client.hotrod.hash_function_impl")) continue;
            if (log.isTraceEnabled()) {
                log.trace("Processing consistent hash: " + propName);
            }
            String versionString = propName.substring("infinispan.client.hotrod.hash_function_impl.".length());
            int version = Integer.parseInt(versionString);
            String hashFunction = config.getProperties().getProperty(propName);
            this.version2ConsistentHash.put(version, hashFunction);
            if (!log.isTraceEnabled()) continue;
            log.trace("Added consistent hash version " + version + ": " + hashFunction);
        }
    }

    public ConsistentHash newConsistentHash(int version) {
        String hashFunctionClass = this.version2ConsistentHash.get(version);
        if (hashFunctionClass == null) {
            if (log.isTraceEnabled()) {
                log.trace("No hash function configured for version " + version);
            }
            hashFunctionClass = ConsistentHashFactory.class.getPackage().getName() + ".ConsistentHashV" + version;
            if (log.isTraceEnabled()) {
                log.trace("Trying to use default value: " + hashFunctionClass);
            }
            this.version2ConsistentHash.put(version, hashFunctionClass);
        }
        return (ConsistentHash)Util.getInstance(hashFunctionClass);
    }

    public Map<Integer, String> getVersion2ConsistentHash() {
        return Collections.unmodifiableMap(this.version2ConsistentHash);
    }
}

