/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.consistenthash;

import java.net.InetSocketAddress;
import java.util.LinkedHashMap;
import java.util.SortedMap;
import java.util.TreeMap;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHash;
import org.infinispan.util.hash.MurmurHash2;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ConsistentHashV1
implements ConsistentHash {
    private static final Log log = LogFactory.getLog(ConsistentHashV1.class);
    private final SortedMap<Integer, InetSocketAddress> positions = new TreeMap<Integer, InetSocketAddress>();
    private volatile int hashSpace;
    MurmurHash2 mmh = new MurmurHash2();

    @Override
    public void init(LinkedHashMap<InetSocketAddress, Integer> servers2HashCode, int numKeyOwners, int hashSpace) {
        for (InetSocketAddress addr : servers2HashCode.keySet()) {
            this.positions.put(servers2HashCode.get(addr), addr);
        }
        if (log.isTraceEnabled()) {
            log.trace("Positions are: " + this.positions);
        }
        this.hashSpace = hashSpace;
    }

    @Override
    public InetSocketAddress getServer(byte[] key) {
        int keyHashCode = this.mmh.hash(key);
        if (keyHashCode == Integer.MIN_VALUE) {
            ++keyHashCode;
        }
        int hash = Math.abs(keyHashCode);
        SortedMap<Integer, InetSocketAddress> candidates = this.positions.tailMap(hash % this.hashSpace);
        if (log.isTraceEnabled()) {
            log.trace("Found possible candidates: " + candidates);
        }
        if (candidates.isEmpty()) {
            InetSocketAddress socketAddress = (InetSocketAddress)this.positions.get(this.positions.firstKey());
            if (log.isTraceEnabled()) {
                log.trace("Over the wheel, returning first member: " + socketAddress);
            }
            return socketAddress;
        }
        InetSocketAddress socketAddress = (InetSocketAddress)candidates.get(candidates.firstKey());
        log.trace("Found candidate: " + socketAddress);
        return socketAddress;
    }
}

