/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.config.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.DataLocality;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.marshall.Marshallable;
import org.infinispan.marshall.exts.ReplicableCommandExternalizer;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Marshallable(externalizer=ReplicableCommandExternalizer.class, id=35)
public class InvalidateL1Command
extends InvalidateCommand {
    public static final int COMMAND_ID = 7;
    private static final Log log = LogFactory.getLog(InvalidateL1Command.class);
    private DistributionManager dm;
    private DataContainer dataContainer;
    private Configuration config;
    private boolean forRehash;

    public InvalidateL1Command() {
    }

    public InvalidateL1Command(boolean forRehash, DataContainer dc, Configuration config, DistributionManager dm, CacheNotifier notifier, Object ... keys) {
        super(notifier, keys);
        this.dm = dm;
        this.forRehash = forRehash;
        this.dataContainer = dc;
        this.config = config;
    }

    public InvalidateL1Command(boolean forRehash, DataContainer dc, Configuration config, DistributionManager dm, CacheNotifier notifier, Collection<Object> keys) {
        super(notifier, keys);
        this.dm = dm;
        this.forRehash = forRehash;
        this.dataContainer = dc;
        this.config = config;
    }

    @Override
    public byte getCommandId() {
        return 7;
    }

    public void init(Configuration config, DistributionManager dm, CacheNotifier n, DataContainer dc) {
        super.init(n);
        this.dm = dm;
        this.config = config;
        this.dataContainer = dc;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        for (Object k : this.getKeys()) {
            InternalCacheEntry ice = this.dataContainer.get(k);
            if (ice == null) continue;
            DataLocality locality = this.dm.getLocality(k);
            while (locality.isUncertain() && this.dm.isRehashInProgress()) {
                LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(50L));
                locality = this.dm.getLocality(k);
            }
            if (locality.isLocal()) continue;
            if (this.forRehash && this.config.isL1OnRehash()) {
                if (log.isTraceEnabled()) {
                    log.trace("Not removing, instead putting entry into L1.");
                }
                this.dataContainer.put(k, ice.getValue(), this.config.getL1Lifespan(), this.config.getExpirationMaxIdle());
                continue;
            }
            this.invalidate(ctx, k);
        }
        return null;
    }

    public void setKeys(Object[] keys) {
        this.keys = keys;
    }

    @Override
    public boolean shouldInvoke(InvocationContext ctx) {
        if (ctx.isOriginLocal() || this.forRehash) {
            return true;
        }
        for (Object k : this.getKeys()) {
            DataLocality locality = this.dm.getLocality(k);
            if (locality.isLocal() && !locality.isUncertain()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InvalidateL1Command that = (InvalidateL1Command)o;
        return this.forRehash == that.forRehash;
    }

    @Override
    public Object[] getParameters() {
        if (this.keys == null || this.keys.length == 0) {
            return new Object[]{this.forRehash};
        }
        if (this.keys.length == 1) {
            return new Object[]{this.forRehash, 1, this.keys[0]};
        }
        Object[] retval = new Object[this.keys.length + 2];
        retval[0] = this.forRehash;
        retval[1] = this.keys.length;
        System.arraycopy(this.keys, 0, retval, 2, this.keys.length);
        return retval;
    }

    @Override
    public void setParameters(int commandId, Object[] args) {
        this.forRehash = (Boolean)args[0];
        int size = (Integer)args[1];
        this.keys = new Object[size];
        if (size == 1) {
            this.keys[0] = args[2];
        } else if (size > 0) {
            System.arraycopy(args, 2, this.keys, 0, size);
        }
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitInvalidateL1Command(ctx, this);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.forRehash ? 1 : 0);
        return result;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{" + "num keys=" + (this.keys == null ? 0 : this.keys.length) + ", forRehash=" + this.forRehash + '}';
    }
}

