/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.CacheException;
import org.infinispan.factories.AbstractComponentRegistry;
import org.infinispan.jmx.ResourceDMBean;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ComponentsJmxRegistration {
    private static final Log log = LogFactory.getLog(ComponentsJmxRegistration.class);
    private MBeanServer mBeanServer;
    private String jmxDomain;
    private String groupName;
    private Set<AbstractComponentRegistry.Component> components;
    public static String COMPONENT_KEY = "component";
    public static String NAME_KEY = "name";

    public ComponentsJmxRegistration(MBeanServer mBeanServer, Set<AbstractComponentRegistry.Component> components, String groupName) {
        this.mBeanServer = mBeanServer;
        this.components = components;
        this.groupName = groupName;
    }

    public void setJmxDomain(String jmxDomain) {
        this.jmxDomain = jmxDomain;
    }

    public void registerMBeans() throws CacheException {
        try {
            List<ResourceDMBean> resourceDMBeans = this.getResourceDMBeansFromComponents();
            boolean trace = log.isTraceEnabled();
            for (ResourceDMBean resource : resourceDMBeans) {
                ObjectName objectName = this.getObjectName(resource);
                if (!this.mBeanServer.isRegistered(objectName)) {
                    try {
                        this.mBeanServer.registerMBean(resource, objectName);
                        if (!trace) continue;
                        log.trace((Object)"Registered %s under %s", resource, objectName);
                    }
                    catch (InstanceAlreadyExistsException e) {
                        log.info("Could not register object with name:" + objectName + "(" + e.getMessage() + ")");
                    }
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"Object name %s already registered", objectName);
            }
        }
        catch (Exception e) {
            throw new CacheException("Failure while registering mbeans", e);
        }
    }

    public void unregisterMBeans() throws CacheException {
        log.trace("Unregistering jmx resources..");
        try {
            List<ResourceDMBean> resourceDMBeans = this.getResourceDMBeansFromComponents();
            boolean trace = log.isTraceEnabled();
            for (ResourceDMBean resource : resourceDMBeans) {
                ObjectName objectName = this.getObjectName(resource);
                if (!this.mBeanServer.isRegistered(objectName)) continue;
                this.mBeanServer.unregisterMBean(objectName);
                if (!trace) continue;
                log.trace("Unregistered " + objectName);
            }
        }
        catch (Exception e) {
            throw new CacheException("Failure while unregistering mbeans", e);
        }
    }

    private List<ResourceDMBean> getResourceDMBeansFromComponents() {
        ArrayList<ResourceDMBean> resourceDMBeans = new ArrayList<ResourceDMBean>();
        for (AbstractComponentRegistry.Component component : this.components) {
            ResourceDMBean resourceDMBean = new ResourceDMBean(component.getInstance());
            if (!resourceDMBean.isManagedResource()) continue;
            resourceDMBeans.add(resourceDMBean);
        }
        return resourceDMBeans;
    }

    private ObjectName getObjectName(ResourceDMBean resource) throws Exception {
        return this.getObjectName(resource.getObjectName());
    }

    protected ObjectName getObjectName(String resourceName) throws Exception {
        return new ObjectName(ComponentsJmxRegistration.getObjectName(this.jmxDomain, this.groupName, resourceName));
    }

    public static String getObjectName(String jmxDomain, String groupName, String resourceName) {
        return jmxDomain + ":" + groupName + "," + COMPONENT_KEY + "=" + resourceName;
    }
}

