/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.jboss;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.infinispan.CacheException;
import org.infinispan.atomic.AtomicHashMap;
import org.infinispan.atomic.AtomicHashMapDelta;
import org.infinispan.atomic.ClearOperation;
import org.infinispan.atomic.PutOperation;
import org.infinispan.atomic.RemoveOperation;
import org.infinispan.commands.RemoteCommandsFactory;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.control.RehashControlCommand;
import org.infinispan.commands.control.StateTransferControlCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.remote.MultipleRpcCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.ImmortalCacheValue;
import org.infinispan.container.entries.MortalCacheEntry;
import org.infinispan.container.entries.MortalCacheValue;
import org.infinispan.container.entries.TransientCacheEntry;
import org.infinispan.container.entries.TransientCacheValue;
import org.infinispan.container.entries.TransientMortalCacheEntry;
import org.infinispan.container.entries.TransientMortalCacheValue;
import org.infinispan.distribution.RemoteTransactionLogDetails;
import org.infinispan.distribution.ch.DefaultConsistentHash;
import org.infinispan.distribution.ch.NodeTopologyInfo;
import org.infinispan.distribution.ch.TopologyAwareConsistentHash;
import org.infinispan.distribution.ch.UnionConsistentHash;
import org.infinispan.loaders.bucket.Bucket;
import org.infinispan.marshall.Externalizer;
import org.infinispan.marshall.Marshallable;
import org.infinispan.marshall.MarshalledValue;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.marshall.exts.ArrayListExternalizer;
import org.infinispan.marshall.exts.LinkedListExternalizer;
import org.infinispan.marshall.exts.MapExternalizer;
import org.infinispan.marshall.exts.ReplicableCommandExternalizer;
import org.infinispan.marshall.exts.SetExternalizer;
import org.infinispan.marshall.exts.SingletonListExternalizer;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.ExtendedResponse;
import org.infinispan.remoting.responses.RequestIgnoredResponse;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.responses.UnsuccessfulResponse;
import org.infinispan.remoting.responses.UnsureResponse;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.transaction.xa.DldGlobalTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.ByteArrayKey;
import org.infinispan.util.FastCopyHashMap;
import org.infinispan.util.ReflectionUtil;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.Unmarshaller;

public class ConstantObjectTable
implements ObjectTable {
    private static final Log log = LogFactory.getLog(ConstantObjectTable.class);
    private static final Map<String, String> JDK_EXTERNALIZERS = new HashMap<String, String>();
    static final Set<String> MARSHALLABLES = new HashSet<String>();
    private final Map<Class<?>, ExternalizerAdapter> writers = new IdentityHashMap();
    private final Map<Integer, ExternalizerAdapter> readers = new HashMap<Integer, ExternalizerAdapter>();
    private volatile boolean started;

    public void start(RemoteCommandsFactory cmdFactory, StreamingMarshaller ispnMarshaller) {
        ExternalizerAdapter adapter;
        Class clazz;
        HashSet<Integer> ids = new HashSet<Integer>();
        for (Map.Entry<String, String> entry : JDK_EXTERNALIZERS.entrySet()) {
            try {
                clazz = Util.loadClassStrict(entry.getKey());
                Externalizer ext = null;
                ext = (Externalizer)Util.getInstanceStrict(entry.getValue());
                Marshallable marshallable = ReflectionUtil.getAnnotation(ext.getClass(), Marshallable.class);
                int id = marshallable.id();
                ids.add(id);
                adapter = new ExternalizerAdapter(id, ext);
                this.writers.put(clazz, adapter);
                this.readers.put(id, adapter);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"Unable to load class %s", e.getMessage());
            }
        }
        for (String marshallableClass : MARSHALLABLES) {
            try {
                clazz = Util.loadClassStrict(marshallableClass);
                Marshallable marshallable = ReflectionUtil.getAnnotation(clazz, Marshallable.class);
                if (marshallable == null || marshallable.externalizer().equals(Externalizer.class)) continue;
                int id = marshallable.id();
                Externalizer ext = null;
                ext = Util.getInstance(marshallable.externalizer());
                if (!ids.add(id)) {
                    throw new CacheException("Duplicate id found! id=" + id + " in " + ext.getClass().getName() + " is shared by another marshallable class.");
                }
                if (ext instanceof ReplicableCommandExternalizer) {
                    ((ReplicableCommandExternalizer)ext).inject(cmdFactory);
                }
                if (ext instanceof MarshalledValue.Externalizer) {
                    ((MarshalledValue.Externalizer)ext).inject(ispnMarshaller);
                }
                adapter = new ExternalizerAdapter(id, ext);
                this.writers.put(clazz, adapter);
                this.readers.put(id, adapter);
            }
            catch (ClassNotFoundException e) {
                if (marshallableClass.startsWith("org.infinispan") || !log.isDebugEnabled()) continue;
                log.debug((Object)"Unable to load class %s", e.getMessage());
            }
        }
        this.started = true;
        if (log.isTraceEnabled()) {
            log.trace((Object)"Constant object table was started and contains these externalizer readers: %s", this.readers);
        }
    }

    boolean isMarshallableCandidate(Object o) {
        return ReflectionUtil.isAnnotationPresent(o.getClass(), Marshallable.class);
    }

    public void stop() {
        this.writers.clear();
        this.readers.clear();
        this.started = false;
        if (log.isTraceEnabled()) {
            log.trace("Externalizer reader and writer maps have been cleared and constant object table was stopped");
        }
    }

    @Override
    public ObjectTable.Writer getObjectWriter(Object o) throws IOException {
        Class<?> clazz = o.getClass();
        ObjectTable.Writer writer = this.writers.get(clazz);
        if (writer == null && (MARSHALLABLES.contains(clazz.getName()) || JDK_EXTERNALIZERS.containsKey(clazz.getName()))) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Either the marshaller has stopped or hasn't started. Write externalizers are not propery populated: %s", this.writers);
            }
            if (Thread.currentThread().isInterrupted()) {
                throw new IOException("Cache manager is shutting down, so type write externalizer for type=" + clazz.getName() + " cannot be resolved. " + "Interruption being pushed up.", new InterruptedException());
            }
            throw new IllegalStateException("No write externalizer available for: " + clazz.getName() + ", either marshaller is stopped or has not started up yet.");
        }
        return writer;
    }

    @Override
    public Object readObject(Unmarshaller input) throws IOException, ClassNotFoundException {
        int readerIndex = input.readUnsignedByte();
        ExternalizerAdapter adapter = this.readers.get(readerIndex);
        if (adapter == null) {
            if (!this.started) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Either the marshaller has stopped or hasn't started. Read externalizers are not propery populated: %s", this.readers);
                }
                if (Thread.currentThread().isInterrupted()) {
                    throw new IOException("Cache manager is shutting down, so type (id=" + readerIndex + ") cannot be resolved. Interruption being pushed up.", new InterruptedException());
                }
                throw new CacheException("Cache manager is either starting up or shutting down but it's not interrupted, so type (id=" + readerIndex + ") cannot be resolved.");
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)"Unknown type. Input stream has %s to read", input.available());
                log.trace((Object)"Check contents of read externalizers: %s", this.readers);
            }
            throw new CacheException("Type of data read is unknown. Id=" + readerIndex + " " + "is not amongst known reader indexes.");
        }
        return adapter.readObject(input);
    }

    static {
        JDK_EXTERNALIZERS.put(ArrayList.class.getName(), ArrayListExternalizer.class.getName());
        JDK_EXTERNALIZERS.put(LinkedList.class.getName(), LinkedListExternalizer.class.getName());
        JDK_EXTERNALIZERS.put(HashMap.class.getName(), MapExternalizer.class.getName());
        JDK_EXTERNALIZERS.put(TreeMap.class.getName(), MapExternalizer.class.getName());
        JDK_EXTERNALIZERS.put(HashSet.class.getName(), SetExternalizer.class.getName());
        JDK_EXTERNALIZERS.put(TreeSet.class.getName(), SetExternalizer.class.getName());
        JDK_EXTERNALIZERS.put("java.util.Collections$SingletonList", SingletonListExternalizer.class.getName());
        MARSHALLABLES.add(GlobalTransaction.class.getName());
        MARSHALLABLES.add(DldGlobalTransaction.class.getName());
        MARSHALLABLES.add(JGroupsAddress.class.getName());
        MARSHALLABLES.add("org.infinispan.util.Immutables$ImmutableMapWrapper");
        MARSHALLABLES.add(MarshalledValue.class.getName());
        MARSHALLABLES.add(FastCopyHashMap.class.getName());
        MARSHALLABLES.add("org.infinispan.transaction.TransactionLog$LogEntry");
        MARSHALLABLES.add(ExtendedResponse.class.getName());
        MARSHALLABLES.add(SuccessfulResponse.class.getName());
        MARSHALLABLES.add(ExceptionResponse.class.getName());
        MARSHALLABLES.add(RequestIgnoredResponse.class.getName());
        MARSHALLABLES.add(UnsuccessfulResponse.class.getName());
        MARSHALLABLES.add(UnsureResponse.class.getName());
        MARSHALLABLES.add(StateTransferControlCommand.class.getName());
        MARSHALLABLES.add(ClusteredGetCommand.class.getName());
        MARSHALLABLES.add(MultipleRpcCommand.class.getName());
        MARSHALLABLES.add(SingleRpcCommand.class.getName());
        MARSHALLABLES.add(GetKeyValueCommand.class.getName());
        MARSHALLABLES.add(PutKeyValueCommand.class.getName());
        MARSHALLABLES.add(RemoveCommand.class.getName());
        MARSHALLABLES.add(InvalidateCommand.class.getName());
        MARSHALLABLES.add(ReplaceCommand.class.getName());
        MARSHALLABLES.add(ClearCommand.class.getName());
        MARSHALLABLES.add(PutMapCommand.class.getName());
        MARSHALLABLES.add(PrepareCommand.class.getName());
        MARSHALLABLES.add(CommitCommand.class.getName());
        MARSHALLABLES.add(RollbackCommand.class.getName());
        MARSHALLABLES.add(InvalidateL1Command.class.getName());
        MARSHALLABLES.add(LockControlCommand.class.getName());
        MARSHALLABLES.add(RehashControlCommand.class.getName());
        MARSHALLABLES.add(ImmortalCacheEntry.class.getName());
        MARSHALLABLES.add(MortalCacheEntry.class.getName());
        MARSHALLABLES.add(TransientCacheEntry.class.getName());
        MARSHALLABLES.add(TransientMortalCacheEntry.class.getName());
        MARSHALLABLES.add(ImmortalCacheValue.class.getName());
        MARSHALLABLES.add(MortalCacheValue.class.getName());
        MARSHALLABLES.add(TransientCacheValue.class.getName());
        MARSHALLABLES.add(TransientMortalCacheValue.class.getName());
        MARSHALLABLES.add(AtomicHashMap.class.getName());
        MARSHALLABLES.add(Bucket.class.getName());
        MARSHALLABLES.add("org.infinispan.tree.NodeKey");
        MARSHALLABLES.add("org.infinispan.tree.Fqn");
        MARSHALLABLES.add(AtomicHashMapDelta.class.getName());
        MARSHALLABLES.add(PutOperation.class.getName());
        MARSHALLABLES.add(RemoveOperation.class.getName());
        MARSHALLABLES.add(ClearOperation.class.getName());
        MARSHALLABLES.add(DefaultConsistentHash.class.getName());
        MARSHALLABLES.add(UnionConsistentHash.class.getName());
        MARSHALLABLES.add(NodeTopologyInfo.class.getName());
        MARSHALLABLES.add(TopologyAwareConsistentHash.class.getName());
        MARSHALLABLES.add("org.infinispan.server.core.CacheValue");
        MARSHALLABLES.add("org.infinispan.server.memcached.MemcachedValue");
        MARSHALLABLES.add(ByteArrayKey.class.getName());
        MARSHALLABLES.add("org.infinispan.server.hotrod.TopologyAddress");
        MARSHALLABLES.add("org.infinispan.server.hotrod.TopologyView");
        MARSHALLABLES.add(RemoteTransactionLogDetails.class.getName());
    }

    static class ExternalizerAdapter
    implements ObjectTable.Writer {
        final int id;
        final Externalizer externalizer;

        ExternalizerAdapter(int id, Externalizer externalizer) {
            this.id = id;
            this.externalizer = externalizer;
        }

        public Object readObject(Unmarshaller input) throws IOException, ClassNotFoundException {
            return this.externalizer.readObject(input);
        }

        @Override
        public void writeObject(Marshaller output, Object object) throws IOException {
            output.write(this.id);
            this.externalizer.writeObject(output, object);
        }

        public String toString() {
            return this.externalizer.getClass().getName();
        }
    }
}

