/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.tm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.infinispan.transaction.tm.DummyBaseTransactionManager;
import org.infinispan.transaction.tm.DummyXid;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class DummyTransaction
implements Transaction {
    private static final Log log = LogFactory.getLog(DummyTransaction.class);
    private static boolean trace = log.isTraceEnabled();
    private volatile int status = 5;
    protected DummyBaseTransactionManager tm_;
    protected DummyXid xid = new DummyXid();
    protected Set<Synchronization> syncs;
    private List<XAResource> enlistedResources = new ArrayList<XAResource>();
    private int prepareStatus;

    public DummyTransaction(DummyBaseTransactionManager tm) {
        this.tm_ = tm;
        this.status = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException {
        try {
            boolean successfulInit = this.notifyBeforeCompletion();
            if (successfulInit) {
                this.status = 7;
            }
            this.status = !successfulInit || !this.runPrepare() ? 9 : 2;
            if (this.status == 1 || this.status == 9) {
                this.runRollback();
                throw new RollbackException("Exception rolled back, status is: " + this.status);
            }
            try {
                this.status = 8;
                this.runCommitTx();
                this.status = 3;
            }
            catch (HeuristicMixedException e) {
                this.status = 5;
                throw e;
            }
            finally {
                this.notifyAfterCompletion(this.status);
            }
        }
        finally {
            this.tm_.setTransaction(null);
        }
    }

    @Override
    public void rollback() throws IllegalStateException, SystemException {
        try {
            this.status = 9;
            this.runRollback();
            this.status = 4;
            this.notifyAfterCompletion(4);
        }
        catch (Throwable t) {
            log.error(t);
            throw new IllegalStateException(t);
        }
        this.tm_.setTransaction(null);
    }

    @Override
    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.status = 1;
    }

    @Override
    public int getStatus() throws SystemException {
        return this.status;
    }

    @Override
    public boolean enlistResource(XAResource xaRes) throws RollbackException, IllegalStateException, SystemException {
        this.enlistedResources.add(xaRes);
        try {
            xaRes.start(this.xid, 0);
        }
        catch (XAException e) {
            log.error(e);
            throw new SystemException(e.getMessage());
        }
        return true;
    }

    @Override
    public boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
        throw new SystemException("not supported");
    }

    @Override
    public void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
        if (sync == null) {
            throw new IllegalArgumentException("null synchronization " + this);
        }
        if (this.syncs == null) {
            this.syncs = new HashSet<Synchronization>(8);
        }
        switch (this.status) {
            case 0: 
            case 7: {
                break;
            }
            case 2: {
                throw new IllegalStateException("already prepared. " + this);
            }
            case 8: {
                throw new IllegalStateException("already started committing. " + this);
            }
            case 3: {
                throw new IllegalStateException("already committed. " + this);
            }
            case 1: {
                throw new RollbackException("already marked for rollback " + this);
            }
            case 9: {
                throw new RollbackException("already started rolling back. " + this);
            }
            case 4: {
                throw new RollbackException("already rolled back. " + this);
            }
            case 6: {
                throw new IllegalStateException("no transaction. " + this);
            }
            case 5: {
                throw new IllegalStateException("unknown state " + this);
            }
            default: {
                throw new IllegalStateException("illegal status: " + this.status + " tx=" + this);
            }
        }
        if (trace) {
            log.trace("registering synchronization handler " + sync);
        }
        this.syncs.add(sync);
    }

    protected boolean notifyBeforeCompletion() throws SystemException {
        boolean retval = true;
        if (this.syncs == null) {
            return true;
        }
        for (Synchronization s : this.syncs) {
            if (trace) {
                log.trace("processing beforeCompletion for " + s);
            }
            try {
                s.beforeCompletion();
            }
            catch (Throwable t) {
                retval = false;
                log.error((Object)("beforeCompletion() failed for " + s), t);
            }
        }
        return retval;
    }

    private boolean runPrepare() throws SystemException {
        DummyTransaction transaction = this.tm_.getTransaction();
        Collection<XAResource> resources = transaction.getEnlistedResources();
        for (XAResource res : resources) {
            try {
                int prepareStatus = res.prepare(this.xid);
                transaction.setPrepareStatus(prepareStatus);
            }
            catch (XAException e) {
                log.trace((Object)"The resource wants to rollback!", e);
                return false;
            }
            catch (Throwable th) {
                log.error((Object)"Unexpected error from resource manager!", th);
                throw new SystemException(th.getMessage());
            }
        }
        return true;
    }

    private void setPrepareStatus(int prepareStatus) {
        this.prepareStatus = prepareStatus;
    }

    protected void notifyAfterCompletion(int status) {
        if (this.syncs == null) {
            return;
        }
        for (Synchronization s : this.syncs) {
            if (trace) {
                log.trace("processing afterCompletion for " + s);
            }
            try {
                s.afterCompletion(status);
            }
            catch (Throwable t) {
                log.error((Object)("afterCompletion() failed for " + s), t);
            }
        }
        this.syncs.clear();
    }

    public Collection<XAResource> getEnlistedResources() {
        return this.enlistedResources;
    }

    private void runRollback() {
        DummyTransaction transaction = this.tm_.getTransaction();
        Collection<XAResource> resources = transaction.getEnlistedResources();
        for (XAResource res : resources) {
            try {
                res.rollback(this.xid);
            }
            catch (XAException e) {
                log.warn((Object)"Error while rolling back", e);
            }
        }
    }

    private void runCommitTx() throws HeuristicMixedException {
        DummyTransaction transaction = this.tm_.getTransaction();
        if (transaction.getPrepareStatus() == 3) {
            log.debug("This is a read-only tx");
        } else {
            Collection<XAResource> resources = transaction.getEnlistedResources();
            for (XAResource res : resources) {
                try {
                    res.commit(this.xid, false);
                }
                catch (XAException e) {
                    log.warn((Object)"exception while committing", e);
                    throw new HeuristicMixedException(e.getMessage());
                }
            }
        }
    }

    public void setStatus(int stat) {
        this.status = stat;
    }

    public String toString() {
        return "DummyTransaction{xid=" + this.xid + ", status=" + this.status + '}';
    }

    public int getPrepareStatus() {
        return this.prepareStatus;
    }
}

