/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling;

import java.io.EOFException;
import java.io.IOException;
import org.jboss.marshalling.AbstractMarshallerFactory;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ClassExternalizerFactory;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.Creator;
import org.jboss.marshalling.ExceptionListener;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ObjectResolver;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.StreamHeader;
import org.jboss.marshalling.UTFUtils;
import org.jboss.marshalling.Unmarshaller;

public abstract class AbstractUnmarshaller
implements Unmarshaller {
    protected final ClassExternalizerFactory classExternalizerFactory;
    protected final StreamHeader streamHeader;
    protected final ClassResolver classResolver;
    protected final ObjectResolver objectResolver;
    protected final Creator creator;
    protected final ClassTable classTable;
    protected final ObjectTable objectTable;
    protected final ExceptionListener exceptionListener;
    protected final int configuredVersion;
    protected ByteInput byteInput;
    private final byte[] buffer;
    private int position;
    private int limit;

    protected AbstractUnmarshaller(AbstractMarshallerFactory marshallerFactory, MarshallingConfiguration configuration) {
        ClassExternalizerFactory classExternalizerFactory = configuration.getClassExternalizerFactory();
        this.classExternalizerFactory = classExternalizerFactory == null ? marshallerFactory.getDefaultClassExternalizerFactory() : classExternalizerFactory;
        StreamHeader streamHeader = configuration.getStreamHeader();
        this.streamHeader = streamHeader == null ? marshallerFactory.getDefaultStreamHeader() : streamHeader;
        ClassResolver classResolver = configuration.getClassResolver();
        this.classResolver = classResolver == null ? marshallerFactory.getDefaultClassResolver() : classResolver;
        ObjectResolver objectResolver = configuration.getObjectResolver();
        this.objectResolver = objectResolver == null ? marshallerFactory.getDefaultObjectResolver() : objectResolver;
        Creator creator = configuration.getCreator();
        this.creator = creator == null ? marshallerFactory.getDefaultCreator() : creator;
        ClassTable classTable = configuration.getClassTable();
        this.classTable = classTable == null ? marshallerFactory.getDefaultClassTable() : classTable;
        ObjectTable objectTable = configuration.getObjectTable();
        this.objectTable = objectTable == null ? marshallerFactory.getDefaultObjectTable() : objectTable;
        ExceptionListener exceptionListener = configuration.getExceptionListener();
        this.exceptionListener = exceptionListener == null ? ExceptionListener.NO_OP : exceptionListener;
        int configuredVersion = configuration.getVersion();
        this.configuredVersion = configuredVersion == -1 ? marshallerFactory.getDefaultVersion() : configuredVersion;
        this.buffer = new byte[configuration.getBufferSize()];
    }

    public final Object readObject() throws ClassNotFoundException, IOException {
        return this.doReadObject(false);
    }

    public final Object readObjectUnshared() throws ClassNotFoundException, IOException {
        return this.doReadObject(true);
    }

    protected abstract Object doReadObject(boolean var1) throws ClassNotFoundException, IOException;

    public int read() throws IOException {
        int limit = this.limit;
        if (limit == -1) {
            return -1;
        }
        int position = this.position;
        byte[] buffer = this.buffer;
        if (position == limit) {
            this.limit = this.byteInput.read(buffer);
            if (this.limit == -1) {
                this.position = 0;
                return -1;
            }
            this.position = 1;
            return buffer[0] & 0xFF;
        }
        this.position = position + 1;
        return buffer[position] & 0xFF;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int limit = this.limit;
        if (limit == -1) {
            return -1;
        }
        int position = this.position;
        int remaining = limit - position;
        if (remaining == 0) {
            return this.byteInput.read(b, off, len);
        }
        byte[] buffer = this.buffer;
        if (len > remaining) {
            System.arraycopy(buffer, position, b, off, remaining);
            this.position = 0;
            this.limit = 0;
            int res = this.byteInput.read(b, off + remaining, len - remaining);
            return res == -1 ? (remaining == 0 ? -1 : remaining) : res + remaining;
        }
        System.arraycopy(buffer, position, b, off, len);
        this.position += len;
        return len;
    }

    public long skip(long n) throws IOException {
        if (n < 0L) {
            throw new IllegalArgumentException("n < 0");
        }
        int limit = this.limit;
        if (limit == -1) {
            return 0L;
        }
        long remaining = limit - this.position;
        if (remaining > n) {
            this.position += (int)n;
            return n;
        }
        this.limit = 0;
        this.position = 0;
        return this.byteInput.skip(n - remaining) + remaining;
    }

    public int available() throws IOException {
        return this.limit - this.position + this.byteInput.available();
    }

    private EOFException eofOnRead() {
        return new EOFException("Read past end of file");
    }

    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        if (this.limit == -1) {
            throw this.eofOnRead();
        }
        int remaining = this.limit - this.position;
        if (len > remaining) {
            if (remaining > 0) {
                System.arraycopy(this.buffer, this.position, b, off, remaining);
                this.position = 0;
                this.limit = 0;
                off += remaining;
                len -= remaining;
            }
            do {
                if ((remaining = this.byteInput.read(b, off, len)) == -1) {
                    throw this.eofOnRead();
                }
                off += remaining;
            } while ((len -= remaining) != 0);
        } else {
            try {
                System.arraycopy(this.buffer, this.position, b, off, len);
                this.position += len;
            }
            catch (NullPointerException e) {
                throw this.eofOnRead();
            }
        }
    }

    public int skipBytes(int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("n < 0");
        }
        int limit = this.limit;
        if (limit == -1) {
            return 0;
        }
        int remaining = limit - this.position;
        if (remaining > n) {
            this.position += n;
            return n;
        }
        this.limit = 0;
        this.position = 0;
        return (int)(this.byteInput.skip(n - remaining) + (long)remaining);
    }

    public boolean readBoolean() throws IOException {
        int position;
        int limit = this.limit;
        if (limit == -1) {
            throw this.eofOnRead();
        }
        byte[] buffer = this.buffer;
        if ((position = this.position++) == limit) {
            this.position = 1;
            this.limit = this.byteInput.read(buffer);
            if (this.limit == -1) {
                throw this.eofOnRead();
            }
            return buffer[0] != 0;
        }
        this.position = position + 1;
        return buffer[position] != 0;
    }

    public byte readByte() throws IOException {
        int position;
        int limit = this.limit;
        if (limit == -1) {
            throw this.eofOnRead();
        }
        byte[] buffer = this.buffer;
        if ((position = this.position++) == limit) {
            this.position = 1;
            this.limit = this.byteInput.read(buffer);
            if (this.limit == -1) {
                throw this.eofOnRead();
            }
            return buffer[0];
        }
        this.position = position + 1;
        return buffer[position];
    }

    public int readUnsignedByte() throws IOException {
        return this.readUnsignedByteDirect();
    }

    public short readShort() throws IOException {
        int position = this.position;
        int remaining = this.limit - position;
        if (remaining < 2) {
            return (short)(this.readUnsignedByteDirect() << 8 | this.readUnsignedByteDirect());
        }
        byte[] buffer = this.buffer;
        this.position = position + 2;
        return (short)(buffer[position] << 8 | buffer[position + 1] & 0xFF);
    }

    public int readUnsignedShort() throws IOException {
        int position = this.position;
        int remaining = this.limit - position;
        if (remaining < 2) {
            return this.readUnsignedByteDirect() << 8 | this.readUnsignedByteDirect();
        }
        byte[] buffer = this.buffer;
        this.position = position + 2;
        return (buffer[position] & 0xFF) << 8 | buffer[position + 1] & 0xFF;
    }

    protected int readUnsignedByteDirect() throws IOException {
        int position;
        int limit = this.limit;
        if (limit == -1) {
            throw this.eofOnRead();
        }
        byte[] buffer = this.buffer;
        if ((position = this.position++) == limit) {
            this.position = 1;
            this.limit = this.byteInput.read(buffer);
            if (this.limit == -1) {
                throw this.eofOnRead();
            }
            return buffer[0] & 0xFF;
        }
        return buffer[position] & 0xFF;
    }

    public char readChar() throws IOException {
        int position = this.position;
        int remaining = this.limit - position;
        if (remaining < 2) {
            return (char)(this.readUnsignedByteDirect() << 8 | this.readUnsignedByteDirect());
        }
        byte[] buffer = this.buffer;
        this.position = position + 2;
        return (char)(buffer[position] << 8 | buffer[position + 1] & 0xFF);
    }

    public int readInt() throws IOException {
        return this.readIntDirect();
    }

    public long readLong() throws IOException {
        return this.readLongDirect();
    }

    protected long readLongDirect() throws IOException {
        return (long)this.readIntDirect() << 32 | (long)this.readIntDirect() & 0xFFFFFFFFL;
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readIntDirect());
    }

    protected int readIntDirect() throws IOException {
        int position = this.position;
        int remaining = this.limit - position;
        if (remaining < 4) {
            return this.readUnsignedByteDirect() << 24 | this.readUnsignedByteDirect() << 16 | this.readUnsignedByteDirect() << 8 | this.readUnsignedByteDirect();
        }
        byte[] buffer = this.buffer;
        this.position = position + 4;
        return buffer[position] << 24 | (buffer[position + 1] & 0xFF) << 16 | (buffer[position + 2] & 0xFF) << 8 | buffer[position + 3] & 0xFF;
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLongDirect());
    }

    public String readLine() throws IOException {
        throw new UnsupportedOperationException("readLine() not supported");
    }

    public String readUTF() throws IOException {
        return UTFUtils.readUTFBytesByByteCount(this, this.readUnsignedShort());
    }

    public void start(ByteInput byteInput) throws IOException {
        this.byteInput = byteInput;
        this.limit = 0;
        this.position = 0;
        this.doStart();
    }

    public void finish() throws IOException {
        this.limit = -1;
        this.position = 0;
        this.byteInput = null;
        this.clearClassCache();
    }

    protected void doStart() throws IOException {
        this.streamHeader.readHeader(this);
    }
}

