/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.jbosscache;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.connector.jbosscache.JBossCacheSource;
import org.modeshape.graph.cache.BasicCachePolicy;
import org.modeshape.graph.cache.CachePolicy;
import org.modeshape.graph.connector.RepositoryConnection;

public class JBossCacheSourceTest {
    private JBossCacheSource source;
    private RepositoryConnection connection;
    private String validName;
    private String validCacheConfigurationName;
    private String validCacheFactoryJndiName;
    private String validCacheJndiName;
    private UUID validRootNodeUuid;
    @MockitoAnnotations.Mock
    private Context jndiContext;
    @MockitoAnnotations.Mock
    private CacheFactory<Name, Object> cacheFactory;
    @MockitoAnnotations.Mock
    private Cache<Name, Object> cache;

    @Before
    public void beforeEach() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.validName = "cache source";
        this.validCacheConfigurationName = "cache config name";
        this.validCacheFactoryJndiName = "cache factory jndi name";
        this.validCacheJndiName = "cache jndi name";
        this.validRootNodeUuid = UUID.randomUUID();
        this.source = new JBossCacheSource();
        this.source.setContext(this.jndiContext);
        Mockito.stub((Object)this.jndiContext.lookup(this.validCacheFactoryJndiName)).toReturn(this.cacheFactory);
        Mockito.stub((Object)this.jndiContext.lookup(this.validCacheJndiName)).toReturn(this.cache);
    }

    @After
    public void afterEach() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    @Test
    public void shouldReturnNonNullCapabilities() {
        Assert.assertThat((Object)this.source.getCapabilities(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldSupportSameNameSiblings() {
        Assert.assertThat((Object)this.source.getCapabilities().supportsSameNameSiblings(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldSupportUpdates() {
        Assert.assertThat((Object)this.source.getCapabilities().supportsUpdates(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldHaveNullSourceNameUponConstruction() {
        this.source = new JBossCacheSource();
        Assert.assertThat((Object)this.source.getName(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldAllowSettingName() {
        this.source.setName("Something");
        Assert.assertThat((Object)this.source.getName(), (Matcher)Is.is((Object)"Something"));
        this.source.setName("another name");
        Assert.assertThat((Object)this.source.getName(), (Matcher)Is.is((Object)"another name"));
    }

    @Test
    public void shouldAllowSettingNameToNull() {
        this.source.setName("some name");
        this.source.setName(null);
        Assert.assertThat((Object)this.source.getName(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldHaveDefaultRetryLimit() {
        Assert.assertThat((Object)this.source.getRetryLimit(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldSetRetryLimitToZeroWhenSetWithNonPositiveValue() {
        this.source.setRetryLimit(0);
        Assert.assertThat((Object)this.source.getRetryLimit(), (Matcher)Is.is((Object)0));
        this.source.setRetryLimit(-1);
        Assert.assertThat((Object)this.source.getRetryLimit(), (Matcher)Is.is((Object)0));
        this.source.setRetryLimit(-100);
        Assert.assertThat((Object)this.source.getRetryLimit(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldAllowRetryLimitToBeSet() {
        for (int i = 0; i != 100; ++i) {
            this.source.setRetryLimit(i);
            Assert.assertThat((Object)this.source.getRetryLimit(), (Matcher)Is.is((Object)i));
        }
    }

    @Test
    public void shouldCreateJndiReferenceAndRecreatedObjectFromReference() throws Exception {
        BasicCachePolicy cachePolicy = new BasicCachePolicy();
        cachePolicy.setTimeToLive(1000L, TimeUnit.MILLISECONDS);
        this.convertToAndFromJndiReference(this.validName, this.validRootNodeUuid, this.validCacheConfigurationName, this.validCacheJndiName, this.validCacheFactoryJndiName, cachePolicy, 100);
    }

    @Test
    public void shouldCreateJndiReferenceAndRecreatedObjectFromReferenceWithNullProperties() throws Exception {
        BasicCachePolicy cachePolicy = new BasicCachePolicy();
        cachePolicy.setTimeToLive(1000L, TimeUnit.MILLISECONDS);
        this.convertToAndFromJndiReference("some source", null, null, null, null, null, 100);
        this.convertToAndFromJndiReference(null, null, null, null, null, null, 100);
    }

    private void convertToAndFromJndiReference(String sourceName, UUID rootNodeUuid, String cacheConfigName, String cacheJndiName, String cacheFactoryJndiName, BasicCachePolicy cachePolicy, int retryLimit) throws Exception {
        this.source.setRetryLimit(retryLimit);
        this.source.setName(sourceName);
        this.source.setCacheConfigurationName(cacheConfigName);
        this.source.setCacheFactoryJndiName(cacheFactoryJndiName);
        this.source.setCacheJndiName(cacheJndiName);
        this.source.setDefaultCachePolicy((CachePolicy)cachePolicy);
        this.source.setRootNodeUuid(rootNodeUuid != null ? rootNodeUuid.toString() : null);
        Reference ref = this.source.getReference();
        Assert.assertThat((Object)ref.getClassName(), (Matcher)Is.is((Object)JBossCacheSource.class.getName()));
        Assert.assertThat((Object)ref.getFactoryClassName(), (Matcher)Is.is((Object)JBossCacheSource.class.getName()));
        HashMap<String, Object> refAttributes = new HashMap<String, Object>();
        Enumeration<RefAddr> enumeration = ref.getAll();
        while (enumeration.hasMoreElements()) {
            RefAddr addr = enumeration.nextElement();
            refAttributes.put(addr.getType(), addr.getContent());
        }
        JBossCacheSource factory = new JBossCacheSource();
        Name name = (Name)Mockito.mock(Name.class);
        Context context = (Context)Mockito.mock(Context.class);
        Hashtable env = new Hashtable();
        JBossCacheSource recoveredSource = (JBossCacheSource)factory.getObjectInstance(ref, name, context, env);
        Assert.assertThat((Object)recoveredSource, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)recoveredSource.getName(), (Matcher)Is.is((Object)this.source.getName()));
        Assert.assertThat((Object)recoveredSource.getRootNodeUuid(), (Matcher)Is.is((Object)this.source.getRootNodeUuid()));
        Assert.assertThat((Object)recoveredSource.getCacheJndiName(), (Matcher)Is.is((Object)this.source.getCacheJndiName()));
        Assert.assertThat((Object)recoveredSource.getRetryLimit(), (Matcher)Is.is((Object)this.source.getRetryLimit()));
        Assert.assertThat((Object)recoveredSource.getCacheFactoryJndiName(), (Matcher)Is.is((Object)this.source.getCacheFactoryJndiName()));
        Assert.assertThat((Object)recoveredSource.getCacheConfigurationName(), (Matcher)Is.is((Object)this.source.getCacheConfigurationName()));
        Assert.assertThat((Object)recoveredSource.getDefaultCachePolicy(), (Matcher)Is.is((Object)this.source.getDefaultCachePolicy()));
        Assert.assertThat((Object)recoveredSource.equals((Object)this.source), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.source.equals((Object)recoveredSource), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldCreateCacheUsingDefaultCacheFactoryWhenNoCacheOrCacheFactoryOrCacheConfigurationNameIsFound() throws Exception {
        this.source.setName(this.validName);
        this.connection = this.source.getConnection();
        Assert.assertThat((Object)this.connection, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldCreateCacheUsingDefaultCacheFactoryWithConfigurationNameWhenNoCacheOrCacheFactoryIsFound() throws Exception {
    }

    @Test
    public void shouldCreateCacheUsingCacheFactoryAndDefaultConfigurationWhenNoCacheOrCacheConfigurationNameIsFound() throws Exception {
    }

    @Test
    public void shouldCreateCacheUsingCacheFactoryAndConfigurationWhenNoCacheIsFound() throws Exception {
    }

    @Test
    public void shouldUseCacheIfFoundInJndi() throws Exception {
    }
}

