/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.jbosscache;

import java.util.UUID;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.connector.LockFailedException;
import org.modeshape.graph.connector.map.AbstractMapWorkspace;
import org.modeshape.graph.connector.map.LockBasedTransaction;
import org.modeshape.graph.connector.map.MapNode;
import org.modeshape.graph.connector.map.MapRepository;
import org.modeshape.graph.connector.map.MapRepositoryTransaction;
import org.modeshape.graph.connector.map.MapWorkspace;
import org.modeshape.graph.request.LockBranchRequest;

public class JBossCacheRepository
extends MapRepository {
    protected final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Cache<UUID, MapNode> cache;

    public JBossCacheRepository(String sourceName, UUID rootNodeUuid, Cache<UUID, MapNode> cache) {
        super(sourceName, rootNodeUuid, null);
        assert (cache != null);
        this.cache = cache;
        this.initialize();
    }

    public JBossCacheRepository(String sourceName, UUID rootNodeUuid, String defaultWorkspaceName, Cache<UUID, MapNode> cache) {
        super(sourceName, rootNodeUuid, defaultWorkspaceName);
        assert (cache != null);
        this.cache = cache;
        this.initialize();
    }

    protected MapWorkspace createWorkspace(ExecutionContext context, String name) {
        assert (name != null);
        assert (this.cache != null);
        Node newWorkspaceNode = this.cache.getRoot().addChild(Fqn.fromElements((Object[])new String[]{name}));
        return new Workspace(this, name, (Node<UUID, MapNode>)newWorkspaceNode);
    }

    public MapRepositoryTransaction startTransaction(boolean readonly) {
        return new LockBasedTransaction(readonly ? this.lock.readLock() : this.lock.writeLock()){

            public void commit() {
                super.commit();
            }

            public void rollback() {
                super.rollback();
            }
        };
    }

    protected ReadWriteLock getLock() {
        return this.lock;
    }

    protected class Workspace
    extends AbstractMapWorkspace {
        private final Node<UUID, MapNode> workspaceNode;

        public Workspace(MapRepository repository, String name, Node<UUID, MapNode> workspaceNode) {
            super(repository, name);
            this.workspaceNode = workspaceNode;
            this.initialize();
        }

        protected void addNodeToMap(MapNode node) {
            assert (node != null);
            this.workspaceNode.put((Object)node.getUuid(), (Object)node);
        }

        protected MapNode removeNodeFromMap(UUID nodeUuid) {
            assert (nodeUuid != null);
            return (MapNode)this.workspaceNode.remove((Object)nodeUuid);
        }

        protected void removeAllNodesFromMap() {
            this.workspaceNode.clearData();
        }

        public MapNode getNode(UUID nodeUuid) {
            assert (nodeUuid != null);
            return (MapNode)this.workspaceNode.get((Object)nodeUuid);
        }

        public void lockNode(MapNode node, LockBranchRequest.LockScope lockScope, long lockTimeoutInMillis) throws LockFailedException {
        }

        public void unlockNode(MapNode node) {
        }
    }
}

